/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.action;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.refactoring.RefactoringReplaceInfo;
import aurora.ide.refactoring.ReplaceRefactoring;
import aurora.ide.search.action.AbstractSearchResultPageAction;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AuroraMatch;
import aurora.ide.search.core.AuroraSearchResult;
import aurora.ide.search.core.CompositeMapInDocument;
import aurora.ide.search.core.CompositeMapInDocumentManager;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;

public class ChangeElementAction
extends AbstractSearchResultPageAction {
    private String s_name;
    private String s_namespace;
    private ArrayList<RefactoringReplaceInfo> infos;
    private IFile c_file;
    private static final String DEFAULT_KEY = "ns";
    private Map<IFile, String> keyMaps;

    public ChangeElementAction(Shell shell) {
        super(shell);
    }

    public void setControl(final Text namespace, final Text name) {
        this.s_name = name.getText().trim();
        this.s_namespace = namespace.getText().trim();
        name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeElementAction.this.s_name = name.getText().trim();
                ChangeElementAction.this.notifyActionChanged();
            }
        });
        namespace.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangeElementAction.this.s_namespace = namespace.getText().trim();
                ChangeElementAction.this.notifyActionChanged();
            }
        });
    }

    protected int getInfoSize() {
        return this.infos == null ? 0 : this.infos.size();
    }

    protected String getSubTaskName() {
        return this.c_file == null ? "" : this.c_file.getName();
    }

    protected Refactoring createRefactoring(List lines, IProgressMonitor monitor) {
        this.createInfo(lines, monitor);
        return new ReplaceRefactoring(this.infos.toArray(new RefactoringReplaceInfo[this.infos.size()]));
    }

    private void createInfo(List lines, IProgressMonitor monitor) {
        this.infos = new ArrayList();
        this.keyMaps = new HashMap<IFile, String>();
        this.createNamespaceInfo(lines, monitor);
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            Object next = it.next();
            if (!(next instanceof LineElement)) continue;
            LineElement line = (LineElement)next;
            this.c_file = (IFile)line.getParent();
            RefactoringReplaceInfo info = this.createStartTagReplaceInfo(line);
            if (info != null) {
                this.infos.add(info);
            }
            RefactoringReplaceInfo endInfo = this.createEndTagReplaceInfo(line);
            if (info == null) continue;
            this.infos.add(endInfo);
        }
    }

    private RefactoringReplaceInfo createEndTagReplaceInfo(LineElement line) {
        AuroraSearchResult result = this.getSearchResult();
        AbstractMatch[] matches = line.getMatches(result);
        if (matches.length > 0) {
            AuroraMatch am = (AuroraMatch)matches[0];
            CompositeMap map = am.getMatchs().getMap();
            IFile file = (IFile)line.getParent();
            String replaceWith = this.getNewTagname(this.keyMaps.get(file));
            try {
                CompositeMapInDocument mid = CompositeMapInDocumentManager.getCompositeMapInDocument(map, this.getDocument(file));
                IRegion tagRegion = this.getTagRegion(mid.getEnd().getOffset(), map, file);
                RefactoringReplaceInfo info = new RefactoringReplaceInfo((IRegion)new Region(tagRegion.getOffset(), tagRegion.getLength()), replaceWith);
                info.setFile(file);
                return info;
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    private void createNamespaceInfo(List lines, IProgressMonitor monitor) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Object next : lines) {
            LineElement line;
            block5: {
                if (!(next instanceof LineElement)) continue;
                line = (LineElement)next;
                this.c_file = (IFile)line.getParent();
                if (files.contains(this.c_file)) continue;
                files.add(this.c_file);
                try {
                    IFile file = (IFile)line.getParent();
                    CompositeMap fileMap = CacheManager.getCompositeMap(file);
                    Map namespaceMapping = fileMap.getNamespaceMapping();
                    if (namespaceMapping != null && namespaceMapping.get(this.s_namespace) != null) {
                        this.keyMaps.put(file, (String)namespaceMapping.get(this.s_namespace));
                    }
                    break block5;
                }
                catch (CoreException e) {
                }
                catch (ApplicationException e) {}
                continue;
            }
            RefactoringReplaceInfo info = this.createNamespaceReplaceInfo(line);
            if (info == null) continue;
            this.infos.add(info);
        }
    }

    private RefactoringReplaceInfo createNamespaceReplaceInfo(LineElement line) {
        IFile file = (IFile)line.getParent();
        try {
            CompositeMap fileMap = CacheManager.getCompositeMap(file);
            int startLine = fileMap.getLocation().getStartLine();
            IDocument document = this.getDocument(file);
            String key = this.getKey(fileMap.getNamespaceMapping(), 0);
            this.keyMaps.put(file, key);
            String ns = this.getNewNamespaceString(key);
            try {
                IRegion lineInformation = document.getLineInformation(startLine - 1);
                return this.createReplaceInfo(lineInformation.getOffset(), fileMap, file, ns);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getNewNamespaceString(String key) {
        StringBuilder b = new StringBuilder(" xmlns:");
        b.append(key);
        b.append("=\"");
        b.append(this.s_namespace);
        b.append("\"");
        return b.toString();
    }

    private String getKey(Map nsMapping, int i) {
        String key = DEFAULT_KEY + i;
        if (nsMapping != null && nsMapping.containsKey(key)) {
            return this.getKey(nsMapping, i++);
        }
        return key;
    }

    public boolean isRefactorSelectionEnabled() {
        boolean s;
        boolean bl = s = !"".equals(this.s_name) && !"".equals(this.s_namespace) && super.isRefactorSelectionEnabled();
        return s && this.checkReplaceWith();
    }

    private boolean checkReplaceWith() {
        StringBuilder b = new StringBuilder("<");
        b.append(this.getNewTagname("c"));
        b.append(" ");
        b.append(this.getNewNamespaceString("c"));
        b.append("/>");
        return Util.checkXMLForm(b.toString());
    }

    public boolean isRefactorAllEnabled() {
        return !"".equals(this.s_name) && !"".equals(this.s_namespace) && super.isRefactorAllEnabled() && this.checkReplaceWith();
    }

    private RefactoringReplaceInfo createStartTagReplaceInfo(LineElement line) {
        AuroraSearchResult result = this.getSearchResult();
        AbstractMatch[] matches = line.getMatches(result);
        if (matches.length > 0) {
            AuroraMatch am = (AuroraMatch)matches[0];
            int offset = am.getOffset();
            CompositeMap map = am.getMatchs().getMap();
            IFile file = (IFile)line.getParent();
            String replaceWith = this.getNewTagname(this.keyMaps.get(file));
            try {
                IRegion tagRegion = this.getTagRegion(offset, map, file);
                RefactoringReplaceInfo info = new RefactoringReplaceInfo((IRegion)new Region(tagRegion.getOffset(), tagRegion.getLength()), replaceWith);
                info.setFile(file);
                return info;
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    private RefactoringReplaceInfo createReplaceInfo(int offset, CompositeMap map, IFile file, String replaceWith) throws CoreException, BadLocationException {
        IRegion tagRegion = this.getTagRegion(offset, map, file);
        RefactoringReplaceInfo info = new RefactoringReplaceInfo((IRegion)new Region(tagRegion.getOffset() + tagRegion.getLength(), 0), replaceWith);
        info.setFile(file);
        return info;
    }

    private IRegion getTagRegion(int offset, CompositeMap map, IFile file) throws CoreException, BadLocationException {
        IDocument document = this.getDocument(file);
        ITypedRegion partition = document.getPartition(offset);
        IRegion tagRegion = Util.getDocumentRegion(partition.getOffset(), partition.getLength(), map.getRawName(), document, IColorConstants.TAG_NAME);
        return tagRegion;
    }

    private String getNewTagname(String key) {
        StringBuilder builder = new StringBuilder(key);
        builder.append(":");
        builder.append(this.s_name);
        return builder.toString();
    }
}

