/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.action;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.refactoring.RefactoringReplaceInfo;
import aurora.ide.refactoring.ReplaceRefactoring;
import aurora.ide.search.action.AbstractSearchResultPageAction;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AuroraMatch;
import aurora.ide.search.core.AuroraSearchResult;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import uncertain.composite.CompositeMap;

public class AddAttributeAction
extends AbstractSearchResultPageAction {
    private String s_name;
    private String s_value;
    private ArrayList<RefactoringReplaceInfo> infos;
    private IFile c_file;

    public AddAttributeAction(Shell shell) {
        super(shell);
    }

    public void setControl(final Text name, final Text value) {
        this.s_name = name.getText().trim();
        this.s_value = value.getText().trim();
        name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddAttributeAction.this.s_name = name.getText().trim();
                AddAttributeAction.this.notifyActionChanged();
            }
        });
        value.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddAttributeAction.this.s_value = value.getText().trim();
                AddAttributeAction.this.notifyActionChanged();
            }
        });
    }

    protected int getInfoSize() {
        return this.infos == null ? 0 : this.infos.size();
    }

    protected String getSubTaskName() {
        return this.c_file == null ? "" : this.c_file.getName();
    }

    protected Refactoring createRefactoring(List lines, IProgressMonitor monitor) {
        this.createInfo(lines, monitor);
        return new ReplaceRefactoring(this.infos.toArray(new RefactoringReplaceInfo[this.infos.size()]));
    }

    private void createInfo(List lines, IProgressMonitor monitor) {
        this.infos = new ArrayList();
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            Object next = it.next();
            if (!(next instanceof LineElement)) continue;
            LineElement line = (LineElement)next;
            this.c_file = (IFile)line.getParent();
            RefactoringReplaceInfo info = this.toRefactoringReplaceInfo(line);
            if (info == null) continue;
            this.infos.add(info);
        }
    }

    public boolean isRefactorSelectionEnabled() {
        boolean s = super.isRefactorSelectionEnabled();
        return s && this.checkReplaceWith();
    }

    private boolean checkReplaceWith() {
        String s = "<a replace />";
        s = s.replace("replace", this.getReplaceWith());
        return Util.checkXMLForm(s);
    }

    public boolean isRefactorAllEnabled() {
        return super.isRefactorAllEnabled() && this.checkReplaceWith();
    }

    private RefactoringReplaceInfo toRefactoringReplaceInfo(LineElement line) {
        AuroraSearchResult result = this.getSearchResult();
        AbstractMatch[] matches = line.getMatches(result);
        if (matches.length > 0) {
            AuroraMatch am = (AuroraMatch)matches[0];
            CompositeMap map = am.getMatchs().getMap();
            IFile file = (IFile)line.getParent();
            try {
                IDocument document = this.getDocument(file);
                ITypedRegion partition = document.getPartition(am.getOffset());
                IRegion tagRegion = Util.getDocumentRegion(partition.getOffset(), partition.getLength(), map.getRawName(), document, IColorConstants.TAG_NAME);
                RefactoringReplaceInfo info = new RefactoringReplaceInfo((IRegion)new Region(tagRegion.getOffset() + tagRegion.getLength(), 0), this.getReplaceWith());
                info.setFile(file);
                return info;
            }
            catch (CoreException document) {
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String getReplaceWith() {
        StringBuilder builder = new StringBuilder(" ");
        builder.append(this.s_name.trim());
        builder.append("=");
        builder.append("\"");
        builder.append(this.s_value.trim());
        builder.append("\"");
        return builder.toString();
    }
}

