/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.screen.wizard;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.helpers.AuroraConstant;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.SystemException;
import aurora.ide.screen.wizard.NewScreenTemplatesWizardPage;
import aurora.ide.screen.wizard.ServiceNewWizardPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class ServiceNewWizard
extends Wizard
implements INewWizard {
    private ServiceNewWizardPage page;
    private ISelection selection;
    private CompositeMap rootElement;
    private NewScreenTemplatesWizardPage templatesWizardPage;

    public ServiceNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new ServiceNewWizardPage(this.selection);
        this.templatesWizardPage = new NewScreenTemplatesWizardPage();
        this.addPage((IWizardPage)this.page);
        this.addPage((IWizardPage)this.templatesWizardPage);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        this.rootElement = this.createRootElement();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ServiceNewWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        if (fileName.indexOf(".") == -1) {
            fileName = String.valueOf(fileName) + ".screen";
        }
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            DialogUtil.showErrorMessageBox(String.valueOf(LocaleMessage.getString("container")) + " \"" + containerName + "\" " + LocaleMessage.getString("not.exist"));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() throws SystemException {
        String contents = "";
        if (this.templatesWizardPage.getTemplateContent() != null && !this.templatesWizardPage.getTemplateContent().equals("")) {
            contents = this.templatesWizardPage.getTemplateContent();
        } else {
            String xmlHint = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            contents = String.valueOf(xmlHint) + AuroraResourceUtil.LineSeparator + AuroraResourceUtil.getSign() + CommentXMLOutputter.defaultInstance().toXML(this.rootElement, true);
        }
        try {
            return new ByteArrayInputStream(contents.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
    }

    private CompositeMap createRootElement() {
        QualifiedName screenQN = AuroraConstant.ScreenQN;
        CommentCompositeMap rootElement = new CommentCompositeMap("a", screenQN.getNameSpace(), screenQN.getLocalName());
        return rootElement;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

