/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.screen.editor;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.preferencepages.BrowserPreferencePage;
import aurora.ide.screen.editor.BrowserShell;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BrowserPage
extends FormPage {
    protected static final String textPageId = "aurora.ide.editor.service.browser";
    protected static final String textPageTitle = LocaleMessage.getString("preview");
    int index;
    boolean busy;
    Image icon = null;
    boolean title = false;
    Composite parent;
    Text locationBar;
    Browser browser;
    ToolBar toolbar;
    Canvas canvas;
    ToolItem itemBack;
    ToolItem itemForward;
    Label status;
    ProgressBar progressBar;
    SWTError error = null;
    private boolean modify = false;

    public BrowserPage(FormEditor editor) {
        super(editor, textPageId, textPageTitle);
    }

    public BrowserPage() {
        super(textPageId, textPageTitle);
    }

    public BrowserPage(Composite parent) {
        super(textPageId, textPageTitle);
        this.parent = parent;
    }

    public void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite shell = form.getBody();
        this.createContent(shell, true);
        this.tryOpenThisPage();
    }

    private void tryOpenThisPage() {
        if (this.getLocalMainUrl() == null) {
            this.openProjectPage();
        }
        if (this.getLocalMainUrl() != null) {
            try {
                this.browser.setUrl(String.valueOf(this.getLocalMainUrl()) + this.getFileName());
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
        }
    }

    protected void createContent(Composite parent, boolean top) {
        this.parent = parent;
        try {
            this.browser = new Browser(parent, 2048);
        }
        catch (SWTError e) {
            this.error = e;
            parent.setLayout((Layout)new FillLayout());
            Label label = new Label(parent, 0x1000040);
            label.setText(LocaleMessage.getString("BrowserNotCreated"));
            parent.layout(true);
            return;
        }
        final Display display = this.browser.getShell().getDisplay();
        this.browser.setData(textPageId, (Object)this);
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell = new Shell(display);
                if (BrowserPage.this.icon != null) {
                    shell.setImage(BrowserPage.this.icon);
                }
                shell.setLayout((Layout)new FillLayout());
                BrowserShell app = new BrowserShell((Composite)shell, false);
                app.setShellDecoration(BrowserPage.this.icon, true);
                event.browser = app.getBrowser();
            }
        });
        if (top) {
            this.show(false, null, null, true, true, true, true);
        } else {
            this.browser.addVisibilityWindowListener(new VisibilityWindowListener(){

                public void hide(WindowEvent e) {
                }

                public void show(WindowEvent e) {
                    Browser browser = (Browser)e.widget;
                    BrowserPage app = (BrowserPage)((Object)browser.getData(BrowserPage.textPageId));
                    app.show(true, e.location, e.size, e.addressBar, e.menuBar, e.statusBar, e.toolBar);
                }
            });
            this.browser.addCloseWindowListener(new CloseWindowListener(){

                public void close(WindowEvent event) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.close();
                }
            });
        }
    }

    public void dispose() {
    }

    public SWTError getError() {
        return this.error;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setShellDecoration(Image icon, boolean title) {
        this.icon = icon;
        this.title = title;
    }

    void show(boolean owned, Point location, Point size, boolean addressBar, boolean menuBar, boolean statusBar, boolean toolBar) {
        final Shell shell = this.browser.getShell();
        if (owned) {
            if (location != null) {
                shell.setLocation(location);
            }
            if (size != null) {
                shell.setSize(shell.computeSize(size.x, size.y));
            }
        }
        FormData data = null;
        if (toolBar) {
            this.toolbar = new ToolBar(this.parent, 0);
            data = new FormData();
            data.top = new FormAttachment(0, 7);
            this.toolbar.setLayoutData((Object)data);
            this.itemBack = new ToolItem(this.toolbar, 8);
            this.itemBack.setText(LocaleMessage.getString("Back"));
            this.itemForward = new ToolItem(this.toolbar, 8);
            this.itemForward.setText(LocaleMessage.getString("Forward"));
            final ToolItem itemStop = new ToolItem(this.toolbar, 8);
            itemStop.setText(LocaleMessage.getString("Stop"));
            final ToolItem itemRefresh = new ToolItem(this.toolbar, 8);
            itemRefresh.setText(LocaleMessage.getString("Refresh"));
            final ToolItem itemGo = new ToolItem(this.toolbar, 8);
            itemGo.setText(LocaleMessage.getString("Go"));
            final ToolItem openThisPage = new ToolItem(this.toolbar, 8);
            openThisPage.setText("\u67e5\u770b\u672c\u9875\u9762");
            final ToolItem openRemotePage = new ToolItem(this.toolbar, 8);
            openRemotePage.setText("\u67e5\u770b\u670d\u52a1\u5668");
            try {
                String thisFile = this.getFileName();
                openThisPage.setToolTipText(String.valueOf(this.getLocalMainUrl()) + thisFile);
                openRemotePage.setToolTipText(String.valueOf(this.getRemoteMainUrl()) + thisFile);
            }
            catch (ApplicationException e) {
                DialogUtil.logErrorException(e);
            }
            this.itemBack.setEnabled(this.browser.isBackEnabled());
            this.itemForward.setEnabled(this.browser.isForwardEnabled());
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    ToolItem item = (ToolItem)event.widget;
                    if (item == BrowserPage.this.itemBack) {
                        BrowserPage.this.browser.back();
                    } else if (item == BrowserPage.this.itemForward) {
                        BrowserPage.this.browser.forward();
                    } else if (item == itemStop) {
                        BrowserPage.this.browser.stop();
                    } else if (item == itemRefresh) {
                        BrowserPage.this.browser.refresh();
                    } else if (item == itemGo) {
                        BrowserPage.this.browser.setUrl(BrowserPage.this.locationBar.getText());
                    } else if (item == openThisPage) {
                        if (BrowserPage.this.getLocalMainUrl() == null) {
                            BrowserPage.this.openProjectPage();
                        }
                        if (BrowserPage.this.getLocalMainUrl() != null) {
                            try {
                                BrowserPage.this.browser.setUrl(String.valueOf(BrowserPage.this.getLocalMainUrl()) + BrowserPage.this.getFileName());
                            }
                            catch (ApplicationException e) {
                                DialogUtil.showExceptionMessageBox(e);
                            }
                        }
                    } else if (item == openRemotePage) {
                        if (BrowserPage.this.getRemoteMainUrl() == null) {
                            BrowserPage.this.openPreferencePage();
                        }
                        if (BrowserPage.this.getRemoteMainUrl() != null) {
                            try {
                                BrowserPage.this.browser.setUrl(String.valueOf(BrowserPage.this.getRemoteMainUrl()) + BrowserPage.this.getFileName());
                            }
                            catch (ApplicationException e) {
                                DialogUtil.showExceptionMessageBox(e);
                            }
                        }
                    }
                }
            };
            this.itemBack.addListener(13, listener);
            this.itemForward.addListener(13, listener);
            itemStop.addListener(13, listener);
            itemRefresh.addListener(13, listener);
            itemGo.addListener(13, listener);
            openThisPage.addListener(13, listener);
            openRemotePage.addListener(13, listener);
            this.canvas = new Canvas(this.parent, 262144);
            data = new FormData();
            data.width = 24;
            data.height = 24;
            data.top = new FormAttachment(0, 7);
            data.right = new FormAttachment(100, -7);
            this.canvas.setLayoutData((Object)data);
            this.canvas.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    BrowserPage.this.browser.setUrl(LocaleMessage.getString("Startup"));
                }
            });
            final Display display = this.parent.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (BrowserPage.this.canvas.isDisposed()) {
                        return;
                    }
                    if (BrowserPage.this.busy) {
                        BrowserPage.this.canvas.redraw();
                    }
                    display.timerExec(150, (Runnable)this);
                }
            });
        }
        if (addressBar) {
            this.locationBar = new Text(this.parent, 2048);
            data = new FormData();
            if (this.toolbar != null) {
                data.top = new FormAttachment((Control)this.toolbar, 0, 128);
                data.left = new FormAttachment((Control)this.toolbar, 5, 131072);
                data.right = new FormAttachment((Control)this.canvas, -5, -1);
            } else {
                data.top = new FormAttachment(0, 0);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
            }
            this.locationBar.setLayoutData((Object)data);
            this.locationBar.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    BrowserPage.this.browser.setUrl(BrowserPage.this.locationBar.getText());
                }
            });
        }
        if (statusBar) {
            this.status = new Label(this.parent, 0);
            this.progressBar = new ProgressBar(this.parent, 0);
            data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.right = new FormAttachment((Control)this.progressBar, 0, -1);
            data.bottom = new FormAttachment(100, -5);
            this.status.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment(100, -5);
            data.bottom = new FormAttachment(100, -5);
            this.progressBar.setLayoutData((Object)data);
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    BrowserPage.this.status.setText(event.text);
                }
            });
        }
        this.parent.setLayout((Layout)new FormLayout());
        Canvas aboveBrowser = toolBar ? this.canvas : (addressBar ? this.locationBar : null);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = aboveBrowser != null ? new FormAttachment((Control)aboveBrowser, 5, -1) : new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = this.status != null ? new FormAttachment((Control)this.status, -5, -1) : new FormAttachment(100, 0);
        this.browser.setLayoutData((Object)data);
        if (statusBar || toolBar) {
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    if (BrowserPage.this.progressBar != null) {
                        BrowserPage.this.progressBar.setSelection(ratio);
                        BrowserPage.this.progressBar.setVisible(true);
                    }
                    boolean bl = BrowserPage.this.busy = event.current != event.total;
                    if (!BrowserPage.this.busy) {
                        BrowserPage.this.index = 0;
                        if (BrowserPage.this.canvas != null) {
                            BrowserPage.this.canvas.redraw();
                        }
                    }
                }

                public void completed(ProgressEvent event) {
                    if (BrowserPage.this.progressBar != null) {
                        BrowserPage.this.progressBar.setSelection(0);
                        BrowserPage.this.progressBar.setVisible(false);
                    }
                    BrowserPage.this.busy = false;
                    BrowserPage.this.index = 0;
                    if (BrowserPage.this.canvas != null) {
                        BrowserPage.this.itemBack.setEnabled(BrowserPage.this.browser.isBackEnabled());
                        BrowserPage.this.itemForward.setEnabled(BrowserPage.this.browser.isForwardEnabled());
                        BrowserPage.this.canvas.redraw();
                    }
                }
            });
        }
        if (addressBar || statusBar || toolBar) {
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    BrowserPage.this.busy = true;
                    if (event.top && BrowserPage.this.locationBar != null) {
                        BrowserPage.this.locationBar.setText(event.location);
                    }
                }

                public void changing(LocationEvent event) {
                }
            });
        }
        if (this.title) {
            this.browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    shell.setText(String.valueOf(event.title) + " - " + LocaleMessage.getString("window.title"));
                }
            });
        }
        this.parent.layout(true);
        if (owned) {
            shell.open();
        }
    }

    public void focus() {
        if (this.locationBar != null) {
            this.locationBar.setFocus();
        } else if (this.browser != null) {
            this.browser.setFocus();
        } else {
            this.parent.setFocus();
        }
    }

    protected String getFileName() throws ApplicationException {
        IFile ifile = ((IFileEditorInput)this.getEditor().getEditorInput()).getFile();
        String fileName = AuroraResourceUtil.getIfileLocalPath(ifile);
        String rootDir = ProjectUtil.getWebHomeLocalPath(ifile.getProject());
        int webLocation = fileName.indexOf(rootDir);
        String registerPath = fileName.substring(webLocation + rootDir.length());
        return registerPath;
    }

    private void openProjectPage() {
        ProjectUtil.openProjectPropertyPage(ProjectUtil.getIProjectFromActiveEditor());
    }

    private void openPreferencePage() {
        String pageId = "aurora.ide.preferencePage.BrowserPreferencePage";
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)pageId, (String[])new String[]{pageId}, null);
        dialog.open();
    }

    private String filterEmptyString(String str) {
        if ("".equals(str)) {
            return null;
        }
        return str;
    }

    private String getLocalMainUrl() {
        try {
            return this.filterEmptyString(ProjectUtil.getLocalWebUrl(ProjectUtil.getIProjectFromActiveEditor()));
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return null;
        }
    }

    private String getRemoteMainUrl() {
        return this.filterEmptyString(BrowserPreferencePage.getRemoteMainUrl());
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(LocaleMessage.getString("window.title"));
        BrowserPage app = new BrowserPage();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        app.dispose();
        display.dispose();
    }

    public void refresh() {
        if (this.browser != null && this.isModify()) {
            this.browser.refresh();
            this.modify = false;
        }
    }

    public void setModify(boolean modify) {
        this.modify = modify;
    }

    public boolean isModify() {
        return this.modify;
    }
}

