/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.schema;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.schema.ITypeDelegate;
import aurora.ide.syscode.Syscode;
import aurora.ide.syscode.SyscodeManager;
import java.util.List;
import org.eclipse.core.resources.IProject;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;

public class SysCodeTypeDelegate
implements ITypeDelegate {
    public static final QualifiedName LookUpCodeTypeName = new QualifiedName("http://www.aurora-framework.org/schema/bm", "Lookupcode");
    private Attribute attribute;
    private CompositeMap map;

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public CompositeMap getMap() {
        return this.map;
    }

    public void setMap(CompositeMap map) {
        this.map = map;
    }

    public SysCodeTypeDelegate(CompositeMap map, Attribute attribute) {
        this.map = map;
        this.attribute = attribute;
    }

    public String getValue(String key) {
        return this.getHtmlDocument(key);
    }

    public String getHtmlDocument(String code) {
        IProject project = ProjectUtil.getIProjectFromActiveEditor();
        if (project == null) {
            project = ProjectUtil.getIProjectFromSelection();
        }
        if (project == null) {
            return code;
        }
        StringBuilder sb = new StringBuilder(6144);
        try {
            List<Syscode> syscode = SyscodeManager.getSyscode(code, DBConnectionUtil.getDBConnectionSyncExec(project));
            if (syscode.size() == 0) {
                sb.append(String.format("SYS_CODE: [%s] <br/>", code));
            } else {
                sb.append(String.format("SYS_CODE: [ %s ]  :<br/><br/><table><tr><th>CODE_VALUE</th><th>CODE_VALUE_NAME</th><th>LANG</th><th>ENABLED_FLAG</th></tr>", code));
                for (Syscode c : syscode) {
                    sb.append(String.format("<tr><td>%s</td><td>%s</td><td>%s</td><td>%s</td></tr>", c.getCode_value(), c.getCode_value_name(), c.getLanguage(), c.getEnabled_flag()));
                }
                sb.append("</table><br/>");
            }
        }
        catch (ApplicationException e) {
            e.printStackTrace();
            sb.append(String.format("SYS_CODE: [%s] <br/>", code));
        }
        return sb.toString();
    }
}

