/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.schema;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.prompt.PromptManager;
import aurora.ide.schema.ITypeDelegate;
import org.eclipse.core.resources.IProject;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;

public class PromptsTypeDelegate
implements ITypeDelegate {
    private Attribute attribute;
    private CompositeMap map;
    public static final QualifiedName PromptsTypeName = new QualifiedName("http://www.aurora-framework.org/schema/bm", "Prompts");

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public CompositeMap getMap() {
        return this.map;
    }

    public void setMap(CompositeMap map) {
        this.map = map;
    }

    public PromptsTypeDelegate(CompositeMap map, Attribute attribute) {
        this.map = map;
        this.attribute = attribute;
    }

    public String getValue(String code) {
        if (!PromptManager.isPromptsCode(code)) {
            return code;
        }
        String r = "";
        IProject project = ProjectUtil.getIProjectFromActiveEditor();
        if (project == null) {
            project = ProjectUtil.getIProjectFromSelection();
        }
        if (project == null) {
            return code;
        }
        try {
            String[] prompts = PromptManager.getPrompts(code, DBConnectionUtil.getDBConnectionSyncExec(project));
            if (prompts[0] != null) {
                r = String.valueOf(r) + "\u4e2d\u6587: " + prompts[0];
            }
            if (prompts[1] != null) {
                r = String.valueOf(r) + "&nbsp;&nbsp;&nbsp;\u82f1\u6587: " + prompts[1];
            }
            return r;
        }
        catch (ApplicationException e) {
            e.printStackTrace();
            return code;
        }
    }
}

