/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring.ui.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.StringTextCellEditor;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.DocumentUtil;
import aurora.ide.search.cache.CacheManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.datatype.DataType;
import uncertain.datatype.DataTypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynDBAction
extends Action {
    private TextPage textPage;
    private List<String> bmFields;
    public GridViewer gridViewer;
    public CompositeMap selectedFields;
    private static final String COLUMN_SQL = "select  t.COLUMN_NAME,t.nullable,t.data_type,t.data_length  from user_tab_columns t where  t.table_name=?";
    private static final String COMMENT_SQL = "select  c.COLUMN_NAME,c.comments  from  user_col_comments c where  c.table_name=?";
    private static final String[] columnNames = new String[]{"COLUMN_NAME", "COMMENTS", "NULLABLE", "DATA_TYPE", "DATA_LENGTH"};
    private static final String[] excluedColumns = new String[]{"CREATED_BY", "CREATION_DATE", "LAST_UPDATED_BY", "LAST_UPDATE_DATE"};
    private static final String[] columnTitles = new String[]{"\u5217\u540d", "\u63cf\u8ff0", "\u53ef\u7a7a", "\u7c7b\u578b", "\u5927\u5c0f"};
    public static final Map<String, Integer> types = new HashMap<String, Integer>();

    static {
        types.put("LONG", -5);
        types.put("TIMESTAMP(6)", 93);
        types.put("NVARCHAR2", 12);
        types.put("NUMBER", 2);
        types.put("CLOB", 2005);
        types.put("CHAR", 1);
        types.put("DATE", 91);
        types.put("TIMESTAMP(9)", 93);
        types.put("VARCHAR2", 12);
    }

    public SynDBAction() {
        this.setText("\u6570\u636e\u5e93\u8868\u540c\u6b65");
        this.setToolTipText("\u6570\u636e\u5e93\u8868\u540c\u6b65");
        this.setId("aurora.ide.refactoring.ui.action.SynDBAction");
    }

    public SynDBAction(TextPage textPage) {
        this();
        this.textPage = textPage;
    }

    public boolean isEnabled() {
        String t = this.getBaseTable();
        if (t == null || "".equals(t)) {
            return false;
        }
        return !AuroraPlugin.getActivePage().getActiveEditor().isDirty();
    }

    public String getBaseTable() {
        String fileProperty = this.getFileProperty("baseTable");
        return fileProperty == null ? fileProperty : fileProperty.toUpperCase();
    }

    public String getDataSourceName() {
        String fileProperty = this.getFileProperty("dataSourceName");
        return "".equals(fileProperty) ? null : fileProperty;
    }

    public String getFileProperty(String key) {
        IFile file = this.textPage.getFile();
        if (file != null) {
            try {
                CompositeMap model = CacheManager.getCompositeMap(file);
                String table = CompositeMapUtil.getValueIgnoreCase(model, key);
                return table;
            }
            catch (CoreException model) {
            }
            catch (ApplicationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public CompositeMap getRootMap() {
        IFile file = this.textPage.getFile();
        if (file != null) {
            try {
                CompositeMap model = CacheManager.getCompositeMap(file);
                return model;
            }
            catch (CoreException model) {
            }
            catch (ApplicationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<String> getBmFields() {
        final ArrayList<String> fields = new ArrayList<String>();
        IFile file = this.textPage.getFile();
        if (file != null) {
            try {
                CompositeMap model = CacheManager.getCompositeMap(file);
                model.iterate(new IterationHandle(){

                    public int process(CompositeMap map) {
                        String string;
                        if ("field".equalsIgnoreCase(map.getName()) && !"".equals(string = map.getString((Object)"name", ""))) {
                            fields.add(string.toUpperCase());
                        }
                        return 0;
                    }
                }, false);
            }
            catch (CoreException model) {
            }
            catch (ApplicationException e) {
                e.printStackTrace();
            }
        }
        return fields;
    }

    private boolean isExcluedColumns(String c) {
        String[] stringArray = excluedColumns;
        int n = excluedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equalsIgnoreCase(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public CompositeMap queryColumns(String table, Connection conn) {
        CommentCompositeMap input;
        block22: {
            input = new CommentCompositeMap();
            PreparedStatement sta = null;
            if (conn != null) {
                try {
                    try {
                        sta = conn.prepareStatement(COLUMN_SQL);
                        sta.setString(1, table);
                        ResultSet resultSet = sta.executeQuery();
                        while (resultSet.next()) {
                            if (this.isExcluedColumns(resultSet.getString(columnNames[0])) || this.isExist(resultSet.getString(columnNames[0]))) continue;
                            CommentCompositeMap element = new CommentCompositeMap();
                            element.put(columnNames[0], resultSet.getString(columnNames[0]));
                            element.put(columnNames[2], resultSet.getString(columnNames[2]));
                            element.put(columnNames[3], resultSet.getString(columnNames[3]));
                            element.put(columnNames[4], new Integer(resultSet.getInt(columnNames[4])));
                            input.addChild(element);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (sta != null) {
                            try {
                                sta.close();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (conn == null) break block22;
                        try {
                            conn.close();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                finally {
                    if (sta != null) {
                        try {
                            sta.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return input;
    }

    private CompositeMap findColumn(CompositeMap columns, String name) {
        List childs = columns.getChilds();
        if (childs != null) {
            for (Object object : childs) {
                String string;
                if (!(object instanceof CompositeMap) || !(string = ((CompositeMap)object).getString((Object)columnNames[0], "")).equals(name)) continue;
                return (CompositeMap)object;
            }
        }
        return null;
    }

    public void queryComments(CompositeMap columns, String table, Connection conn) {
        block22: {
            PreparedStatement sta = null;
            if (conn != null) {
                try {
                    try {
                        sta = conn.prepareStatement(COMMENT_SQL);
                        sta.setString(1, table);
                        ResultSet resultSet = sta.executeQuery();
                        while (resultSet.next()) {
                            CompositeMap element = this.findColumn(columns, resultSet.getString(columnNames[0]));
                            if (element == null) continue;
                            element.put((Object)columnNames[1], (Object)resultSet.getString(columnNames[1]));
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (sta != null) {
                            try {
                                sta.close();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (conn == null) break block22;
                        try {
                            conn.close();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                finally {
                    if (sta != null) {
                        try {
                            sta.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private boolean isExist(String string) {
        return this.bmFields.contains(string.toUpperCase());
    }

    public void run() {
        Shell shell = this.textPage.getSite().getShell();
        IDocument document = this.textPage.getDocument();
        this.bmFields = this.getBmFields();
        this.selectedFields = null;
        ColumnsDialog dia = new ColumnsDialog(shell);
        if (dia.open() == 0 && this.selectedFields != null) {
            int offset = -1;
            CompositeMap rootMap = this.getRootMap();
            CompositeMap fields = rootMap.getChild("fields");
            String insertText = "";
            if (fields != null) {
                try {
                    offset = DocumentUtil.getMapLineOffset(document, fields, -1, false);
                    StringBuilder sb = new StringBuilder();
                    List childsNotNull = this.selectedFields.getChildsNotNull();
                    for (Object object : childsNotNull) {
                        if (!(object instanceof CompositeMap)) continue;
                        String xml = ((CompositeMap)object).toXML();
                        sb.append(xml);
                    }
                    insertText = sb.toString();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    offset = DocumentUtil.getMapLineOffset(document, rootMap, 0, true);
                    insertText = this.selectedFields.toXML();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            IRewriteTarget target = (IRewriteTarget)this.textPage.getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            if (offset != -1) {
                try {
                    document.replace(offset, 0, insertText);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    public CompositeMap getSelectedFields() {
        String pre = "bm";
        CompositeMap rootMap = this.getRootMap();
        if (rootMap != null) {
            pre = rootMap.getPrefix();
        }
        CommentCompositeMap fieldsArray = new CommentCompositeMap("fields");
        fieldsArray.setPrefix(pre);
        Object[] elements = this.gridViewer.getCheckedElements();
        int j = 0;
        while (j < elements.length) {
            CompositeMap record = (CompositeMap)elements[j];
            CommentCompositeMap field = new CommentCompositeMap("field");
            field.setPrefix(pre);
            String fieldName = record.getString((Object)"COLUMN_NAME").toLowerCase();
            field.put("name", fieldName);
            field.put("physicalName", record.getString((Object)"COLUMN_NAME"));
            String dataType = record.getString((Object)"DATA_TYPE");
            field.put("databaseType", dataType);
            Integer db_data_type = SynDBAction.getDataType(dataType);
            DataTypeRegistry dtr = DataTypeRegistry.getInstance();
            DataType dt = dtr.getType(db_data_type.intValue());
            field.put("datatype", dt.getJavaType().getName());
            String prompt = record.getString((Object)"COMMENTS");
            field.put("prompt", prompt);
            fieldsArray.addChild(field);
            ++j;
        }
        return fieldsArray;
    }

    public Connection getConnection() {
        IFile file = this.textPage.getFile();
        try {
            return DBConnectionUtil.getDBConnection(file.getProject(), this.getDataSourceName());
        }
        catch (ApplicationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDataType(String type) {
        Integer integer = types.get(type);
        return integer != null ? integer : 12;
    }

    private class ColumnsDialog
    extends Dialog {
        protected ColumnsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            CompositeMap input = SynDBAction.this.queryColumns(SynDBAction.this.getBaseTable(), SynDBAction.this.getConnection());
            SynDBAction.this.queryComments(input, SynDBAction.this.getBaseTable(), SynDBAction.this.getConnection());
            SynDBAction.this.gridViewer = new GridViewer(columnNames, 322);
            try {
                SynDBAction.this.gridViewer.setColumnTitles(columnTitles);
                SynDBAction.this.gridViewer.createViewer(dialogArea);
                CellEditor[] celleditors = new CellEditor[columnNames.length];
                CellInfo cellProperties = new CellInfo(SynDBAction.this.gridViewer, "REMARKS", false);
                StringTextCellEditor cellEditor = new StringTextCellEditor(cellProperties);
                celleditors[1] = cellEditor.getCellEditor();
                cellEditor.init();
                SynDBAction.this.gridViewer.addEditor("REMARKS", cellEditor);
                SynDBAction.this.gridViewer.setCellEditors(celleditors);
                SynDBAction.this.gridViewer.setData(input);
            }
            catch (ApplicationException e) {
                DialogUtil.logErrorException(e);
            }
            return dialogArea;
        }

        protected void initializeBounds() {
            super.initializeBounds();
            this.getShell().setSize(680, 350);
        }

        protected void okPressed() {
            SynDBAction.this.selectedFields = SynDBAction.this.getSelectedFields();
            super.okPressed();
        }

        public boolean close() {
            return super.close();
        }
    }
}

