/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.preferencepages.RefactorSettingPreferencePage;
import aurora.ide.refactoring.FolderRefactorParticipant;
import aurora.ide.refactoring.ScreenRefactoring;
import aurora.ide.refactoring.TextFileChangeManager;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.MultiSourceReferenceSearchService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FolderMoveParticipant
extends MoveParticipant {
    private FolderRefactorParticipant folderRefactorParticipant;
    private Map<String, String> pkgMap;
    private TextFileChangeManager changeManager;
    private IFolder moveTO;
    private boolean check;

    protected boolean initialize(Object element) {
        Object destination = this.getArguments().getDestination();
        if (element instanceof IFolder && destination instanceof IFolder) {
            this.folderRefactorParticipant = new FolderRefactorParticipant();
            this.changeManager = new TextFileChangeManager();
            this.moveTO = (IFolder)destination;
            if (((IFolder)element).getParent().equals((Object)this.moveTO) || !((IFolder)element).getProject().equals((Object)this.moveTO.getProject())) {
                return false;
            }
            return this.folderRefactorParticipant.initialize(element);
        }
        return false;
    }

    public String getName() {
        return "Folder Move Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        IPath path;
        String pkg;
        this.check = true;
        RefactoringStatus result = new RefactoringStatus();
        boolean refactorStatus = RefactorSettingPreferencePage.getRefactorStatus("refactor_setting_folder_move");
        if (!refactorStatus) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"IDE\u8bbe\u7f6e\u79fb\u52a8\u76ee\u5f55\u4e0d\u542f\u7528\u91cd\u6784."));
            return result;
        }
        Object destination = this.getArguments().getDestination();
        if (destination instanceof IResource && this.folderRefactorParticipant.isBMFolder() && (pkg = Util.toRelativeClassesPKG(path = ((IResource)destination).getProjectRelativePath())).length() == 0) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"\u76ee\u6807\u76ee\u5f55\u4e0d\u5c5e\u4e8eclasses,Aurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c,\u8bf7Cancel\u540e\u91cd\u65b0\u9009\u62e9."));
        }
        if (destination instanceof IResource && !this.folderRefactorParticipant.isBMFolder()) {
            IContainer webInf = Util.findWebInf((IResource)this.folderRefactorParticipant.getCurrentFolder());
            if (webInf == null) {
                this.check = false;
                result.merge(RefactoringStatus.createInfoStatus((String)"WEB-INF\u672a\u53d1\u73b0,Aurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c,\u8bf7Cancel\u540e\u91cd\u65b0\u9009\u62e9."));
            }
            if (webInf != null) {
                IPath path2 = ((IResource)destination).getProjectRelativePath();
                boolean inWeb = webInf.getParent().getProjectRelativePath().isPrefixOf(path2);
                boolean inWebInf = webInf.getProjectRelativePath().isPrefixOf(path2);
                if (!inWeb || inWebInf) {
                    this.check = false;
                    result.merge(RefactoringStatus.createInfoStatus((String)"\u76ee\u6807\u76ee\u5f55\u65e0\u6548,Aurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c,\u8bf7Cancel\u540e\u91cd\u65b0\u9009\u62e9."));
                }
            }
        }
        return result;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.check) {
            if (this.folderRefactorParticipant.isBMFolder()) {
                this.createPKGMap();
                Change createBMChange = this.createBMChange(pm);
                return createBMChange;
            }
            return this.createScreenChange(pm);
        }
        return null;
    }

    private List getRelations(IProgressMonitor pm) {
        List<IFile> result = this.folderRefactorParticipant.getFiles();
        IResource scope = Util.getScope((IResource)this.folderRefactorParticipant.getCurrentFolder());
        if (scope == null) {
            return null;
        }
        MultiSourceReferenceSearchService seachService = new MultiSourceReferenceSearchService(scope, result.toArray(new IFile[result.size()]), null, this.folderRefactorParticipant.isBMFolder());
        seachService.setPostException(false);
        seachService.setRunInUI(true);
        List<AbstractMatch> relations = seachService.service(pm);
        return relations;
    }

    private Change createScreenChange(IProgressMonitor pm) throws CoreException {
        List relations = this.getRelations(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            AbstractMatch object = (AbstractMatch)((Object)relations.get(i));
            IFile file = (IFile)object.getElement();
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            try {
                TextEdit edit = this.createScreenEdit(object);
                if (edit != null) {
                    textFileChange.addEdit(edit);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChangesHasEdit());
        return changes;
    }

    private TextEdit createScreenEdit(AbstractMatch match) throws CoreException, BadLocationException {
        int length;
        int offset;
        IFile file = (IFile)match.getElement();
        if (this.changeManager.isOverlapping(file, offset = match.getOriginalOffset(), length = match.getOriginalLength())) {
            return null;
        }
        String string = ScreenRefactoring.findAttributeValue(match);
        IFile findScreenFile = Util.findScreenFile(file, string);
        if (findScreenFile == null) {
            return null;
        }
        if (findScreenFile.getParent().equals((Object)file.getParent())) {
            return null;
        }
        IPath folderPath = this.folderRefactorParticipant.getCurrentFolder().getParent().getProjectRelativePath();
        IPath newPath = this.moveTO.getProjectRelativePath().append(findScreenFile.getProjectRelativePath().makeRelativeTo(folderPath));
        return ScreenRefactoring.createMoveTOScreenTextEdit(match, newPath);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private void createPKGMap() {
        this.pkgMap = new HashMap<String, String>();
        List<IFile> result = this.folderRefactorParticipant.getFiles();
        for (IFile file : result) {
            String oldPkg = Util.toBMPKG(file);
            IPath folderPath = this.folderRefactorParticipant.getCurrentFolder().getParent().getProjectRelativePath();
            IPath filePath = file.getProjectRelativePath();
            IPath raelativeTo = filePath.makeRelativeTo(folderPath).removeFileExtension();
            IPath toPath = this.moveTO.getProjectRelativePath();
            String newPkg = String.valueOf(Util.toPKG(toPath)) + "." + Util.toPKG(raelativeTo);
            this.pkgMap.put(oldPkg, newPkg);
        }
    }

    private Change createBMChange(IProgressMonitor pm) throws CoreException {
        List relations = this.getRelations(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            int length;
            int offset;
            AbstractMatch object = (AbstractMatch)((Object)relations.get(i));
            IFile file = (IFile)object.getElement();
            IDocument document = this.getDocument(file);
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            if (!this.changeManager.isOverlapping(file, offset = object.getOriginalOffset(), length = object.getOriginalLength())) {
                try {
                    String string = document.get(offset, length);
                    ReplaceEdit edit = new ReplaceEdit(offset, length, this.pkgMap.get(string));
                    textFileChange.addEdit((TextEdit)edit);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    public IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getDocument(file);
    }
}

