/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.preferencepages.RefactorSettingPreferencePage;
import aurora.ide.refactoring.TextFileChangeManager;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.ReferenceSearchService;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FileRenameParticipant
extends RenameParticipant {
    private IFile currentSourcefile;
    private String fileExtension;
    private TextFileChangeManager changeManager;
    private boolean check;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.currentSourcefile = (IFile)element;
            this.fileExtension = ((IFile)element).getFileExtension();
            this.changeManager = new TextFileChangeManager();
            return "bm".equalsIgnoreCase(this.fileExtension) || "screen".equalsIgnoreCase(this.fileExtension) || "svc".equalsIgnoreCase(this.fileExtension);
        }
        return false;
    }

    public String getName() {
        return "Aurora File Rename Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        this.check = true;
        RefactoringStatus result = new RefactoringStatus();
        boolean refactorStatus = RefactorSettingPreferencePage.getRefactorStatus("refactor_setting_file_rename");
        if (!refactorStatus) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"IDE\u8bbe\u7f6e\u4fee\u6539\u6587\u4ef6\u540d\u4e0d\u542f\u7528\u91cd\u6784."));
            return result;
        }
        String newName = this.getArguments().getNewName();
        if (!newName.toLowerCase().endsWith(this.fileExtension.toLowerCase())) {
            this.check = false;
            result.merge(RefactoringStatus.createErrorStatus((String)("\u6587\u4ef6\u6269\u5c55\u540d\u9519\u8bef : " + newName)));
        }
        return result;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.check) {
            if ("bm".equalsIgnoreCase(this.fileExtension)) {
                return this.createBMChange(pm);
            }
            if ("screen".equalsIgnoreCase(this.fileExtension) || "svc".equalsIgnoreCase(this.fileExtension)) {
                return this.createScreenChange(pm);
            }
        }
        return null;
    }

    private Change createScreenChange(IProgressMonitor pm) throws CoreException {
        IResource scope = Util.getScope((IResource)this.currentSourcefile);
        if (scope == null) {
            return null;
        }
        ReferenceSearchService seachService = new ReferenceSearchService(scope, (Object)this.currentSourcefile, null);
        seachService.setPostException(false);
        List<AbstractMatch> relations = seachService.service(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            AbstractMatch object = relations.get(i);
            IFile file = (IFile)object.getElement();
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            int offset = object.getOriginalOffset();
            int length = object.getOriginalLength();
            String newName = this.getArguments().getNewName();
            boolean overlapping = this.changeManager.isOverlapping(file, offset, length);
            if (!overlapping) {
                ReplaceEdit edit = new ReplaceEdit(offset, length, newName);
                textFileChange.addEdit((TextEdit)edit);
            }
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private Change createBMChange(IProgressMonitor pm) throws CoreException {
        IResource scope = Util.getScope((IResource)this.currentSourcefile);
        if (scope == null) {
            return null;
        }
        ReferenceSearchService seachService = new ReferenceSearchService(scope, (Object)this.currentSourcefile, null);
        seachService.setPostException(false);
        List<AbstractMatch> relations = seachService.service(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            AbstractMatch object = relations.get(i);
            IFile file = (IFile)object.getElement();
            IDocument document = this.getDocument(file);
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            int offset = object.getOriginalOffset();
            int length = object.getOriginalLength();
            try {
                String text = document.get(offset, length);
                String oldName = this.currentSourcefile.getProjectRelativePath().removeFileExtension().lastSegment();
                String _inputName = this.getArguments().getNewName();
                String newName = _inputName.substring(0, _inputName.length() - 3);
                newName = String.valueOf(text.substring(0, text.length() - oldName.length())) + newName;
                boolean overlapping = this.changeManager.isOverlapping(file, offset, length);
                if (!overlapping) {
                    ReplaceEdit edit = new ReplaceEdit(offset, length, newName);
                    textFileChange.addEdit((TextEdit)edit);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    public IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getDocument(file);
    }
}

