/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.preferencepages.RefactorSettingPreferencePage;
import aurora.ide.refactoring.ScreenRefactoring;
import aurora.ide.refactoring.TextFileChangeManager;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.ReferenceSearchService;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class FileMoveParticipant
extends MoveParticipant {
    private IFile currentSourcefile;
    private String fileExtension;
    private TextFileChangeManager changeManager;
    private IFolder moveTO;
    private boolean check;

    protected boolean initialize(Object element) {
        Object destination = this.getArguments().getDestination();
        if (element instanceof IFile && destination instanceof IFolder) {
            this.currentSourcefile = (IFile)element;
            this.fileExtension = ((IFile)element).getFileExtension();
            this.changeManager = new TextFileChangeManager();
            this.moveTO = (IFolder)destination;
            if (this.currentSourcefile.getParent().equals((Object)this.moveTO) || !this.currentSourcefile.getProject().equals((Object)this.moveTO.getProject())) {
                return false;
            }
            return "bm".equalsIgnoreCase(this.fileExtension) || "screen".equalsIgnoreCase(this.fileExtension) || "svc".equalsIgnoreCase(this.fileExtension);
        }
        return false;
    }

    public String getName() {
        return "Aurora File Move Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        IPath path;
        String pkg;
        this.check = true;
        RefactoringStatus result = new RefactoringStatus();
        boolean refactorStatus = RefactorSettingPreferencePage.getRefactorStatus("refactor_setting_file_move");
        if (!refactorStatus) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"IDE\u8bbe\u7f6e\u79fb\u52a8\u6587\u4ef6\u4e0d\u542f\u7528\u91cd\u6784."));
            return result;
        }
        Object destination = this.getArguments().getDestination();
        if (destination instanceof IResource && "bm".equalsIgnoreCase(this.fileExtension) && (pkg = Util.toRelativeClassesPKG(path = ((IResource)destination).getProjectRelativePath())).length() == 0) {
            this.check = false;
            result.merge(RefactoringStatus.createInfoStatus((String)"\u76ee\u6807\u76ee\u5f55\u4e0d\u5c5e\u4e8eclasses,Aurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c,\u8bf7Cancel\u540e\u91cd\u65b0\u9009\u62e9\u3002"));
        }
        if (destination instanceof IResource && ("screen".equalsIgnoreCase(this.fileExtension) || "svc".equalsIgnoreCase(this.fileExtension))) {
            IContainer webInf = Util.findWebInf((IResource)this.currentSourcefile);
            if (webInf == null) {
                this.check = false;
                result.merge(RefactoringStatus.createInfoStatus((String)"WEB-INF\u672a\u53d1\u73b0,Aurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c,\u8bf7Cancel\u540e\u91cd\u65b0\u9009\u62e9\u3002"));
            }
            if (webInf != null) {
                IPath path2 = ((IResource)destination).getProjectRelativePath();
                boolean inWeb = webInf.getParent().getProjectRelativePath().isPrefixOf(path2);
                boolean inWebInf = webInf.getProjectRelativePath().isPrefixOf(path2);
                if (!inWeb || inWebInf) {
                    this.check = false;
                    result.merge(RefactoringStatus.createInfoStatus((String)"\u76ee\u6807\u76ee\u5f55\u65e0\u6548,Aurora\u91cd\u6784\u4e0d\u4f1a\u8fdb\u884c,\u8bf7Cancel\u540e\u91cd\u65b0\u9009\u62e9\u3002"));
                }
            }
        }
        return result;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.check) {
            if ("bm".equalsIgnoreCase(this.fileExtension)) {
                return this.createBMChange(pm);
            }
            if ("screen".equalsIgnoreCase(this.fileExtension) || "svc".equalsIgnoreCase(this.fileExtension)) {
                return this.createScreenChange(pm);
            }
        }
        return null;
    }

    private Change createScreenChange(IProgressMonitor pm) throws CoreException {
        List relations = this.getRelations(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            AbstractMatch object = (AbstractMatch)((Object)relations.get(i));
            IFile file = (IFile)object.getElement();
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            try {
                textFileChange.addEdit(this.createScreenTextEdit(object));
            }
            catch (MalformedTreeException e) {
                e.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    private TextEdit createScreenTextEdit(AbstractMatch match) throws CoreException, BadLocationException {
        IPath newPath = this.moveTO.getProjectRelativePath().append(this.currentSourcefile.getName());
        return ScreenRefactoring.createMoveTOScreenTextEdit(match, newPath);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private Change createBMChange(IProgressMonitor pm) throws CoreException {
        List relations = this.getRelations(pm);
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        int i = 0;
        while (i < relations.size()) {
            AbstractMatch object = (AbstractMatch)((Object)relations.get(i));
            IFile file = (IFile)object.getElement();
            TextFileChange textFileChange = this.changeManager.getTextFileChangeInProcessor(this.getProcessor(), file);
            if (textFileChange == null) {
                textFileChange = this.changeManager.getTextFileChange(file);
            }
            textFileChange.addEdit(this.createBMTextEdit(object));
            ++i;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    private List getRelations(IProgressMonitor pm) {
        IResource scope = Util.getScope((IResource)this.currentSourcefile);
        if (scope == null) {
            return null;
        }
        ReferenceSearchService seachService = new ReferenceSearchService(scope, (Object)this.currentSourcefile, null);
        seachService.setRunInUI(true);
        seachService.setPostException(false);
        List<AbstractMatch> relations = seachService.service(pm);
        return relations;
    }

    public TextEdit createBMTextEdit(AbstractMatch match) throws CoreException {
        int offset = match.getOriginalOffset();
        int length = match.getOriginalLength();
        String fileName = this.currentSourcefile.getProjectRelativePath().removeFileExtension().lastSegment();
        IPath newPath = this.moveTO.getProjectRelativePath().append(fileName);
        String newPkg = Util.toRelativeClassesPKG(newPath);
        ReplaceEdit edit = new ReplaceEdit(offset, length, newPkg);
        return edit;
    }

    public IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getDocument(file);
    }
}

