/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prompt;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBConnectionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromptManager {
    private static final String SQL = "select  language, description  from sys_prompts t where t.prompt_code=?";
    private static final String IN_CODES_PARA = "%PROMPT_CODES%";
    private static final String IN_SQL = "select t.language, t.description,t.prompt_code from sys_prompts t where t.prompt_code in (%PROMPT_CODES%)";
    private static final String COMMENT_SQL = "select  c.COLUMN_NAME,c.comments  from  user_col_comments c where  c.table_name=?";

    public static String[] getPrompts(String code, Connection conn) {
        String[] result;
        block23: {
            result = new String[2];
            PreparedStatement sta = null;
            if (conn != null) {
                try {
                    try {
                        sta = conn.prepareStatement(SQL);
                        sta.setString(1, code);
                        ResultSet resultSet = sta.executeQuery();
                        while (resultSet.next()) {
                            String language = resultSet.getString("language");
                            String description = resultSet.getString("description");
                            if ("ZHS".equalsIgnoreCase(language)) {
                                result[0] = description;
                            }
                            if (!"US".equalsIgnoreCase(language)) continue;
                            result[1] = description;
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (sta != null) {
                            try {
                                sta.close();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (conn == null) break block23;
                        try {
                            conn.close();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                finally {
                    if (sta != null) {
                        try {
                            sta.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return result;
    }

    public static CompositeMap getPrompts(List<String> codes, IFile file) {
        CommentCompositeMap result;
        block26: {
            Connection conn = null;
            try {
                conn = DBConnectionUtil.getDBConnection(file.getProject());
            }
            catch (ApplicationException e1) {
                e1.printStackTrace();
            }
            result = new CommentCompositeMap();
            String sql = PromptManager.createInSql(codes);
            if (sql == null) {
                return result;
            }
            PreparedStatement sta = null;
            if (conn != null) {
                try {
                    try {
                        sta = conn.prepareStatement(sql);
                        ResultSet resultSet = sta.executeQuery();
                        while (resultSet.next()) {
                            String language = resultSet.getString("language");
                            String description = resultSet.getString("description");
                            String prompt_code = resultSet.getString("prompt_code");
                            CompositeMap child = result.getChildByAttrib("prompt_code", prompt_code);
                            if (child == null) {
                                child = result.createChild(prompt_code);
                            }
                            child.put((Object)"prompt_code", (Object)prompt_code);
                            child.put((Object)language, (Object)description);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (sta != null) {
                            try {
                                sta.close();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (conn == null) break block26;
                        try {
                            conn.close();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                finally {
                    if (sta != null) {
                        try {
                            sta.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return result;
    }

    private static String createInSql(List<String> codes) {
        StringBuilder sb = new StringBuilder();
        for (String c : codes) {
            sb.append(" '");
            sb.append(c);
            sb.append("' ");
            sb.append(",");
        }
        if (sb.length() == 0) {
            return null;
        }
        return IN_SQL.replaceAll(IN_CODES_PARA, sb.substring(0, sb.length() - 2));
    }

    public static CompositeMap getColumnComments(String baseTable, IFile file) {
        CommentCompositeMap result;
        block24: {
            Connection conn = null;
            try {
                conn = DBConnectionUtil.getDBConnection(file.getProject());
            }
            catch (ApplicationException e1) {
                e1.printStackTrace();
            }
            result = new CommentCompositeMap();
            PreparedStatement sta = null;
            if (conn != null) {
                try {
                    try {
                        sta = conn.prepareStatement(COMMENT_SQL);
                        sta.setString(1, baseTable.toUpperCase());
                        ResultSet resultSet = sta.executeQuery();
                        while (resultSet.next()) {
                            CompositeMap c = result.createChild(baseTable.toUpperCase());
                            c.put((Object)"column_name", (Object)resultSet.getString("column_name"));
                            c.put((Object)"comments", (Object)resultSet.getString("comments"));
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        if (sta != null) {
                            try {
                                sta.close();
                            }
                            catch (SQLException e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (conn == null) break block24;
                        try {
                            conn.close();
                        }
                        catch (SQLException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
                finally {
                    if (sta != null) {
                        try {
                            sta.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return result;
    }

    public static boolean isPromptsCode(String key) {
        return key.matches("[A-Z\\d_]+(\\.[A-Z\\d_]+)*");
    }
}

