/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.project.wizard;

import aurora.ide.AuroraPlugin;
import aurora.ide.AuroraProjectNature;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ProjectWizard
extends BasicNewProjectResourceWizard
implements Runnable,
IRunnableWithProgress {
    public static final String copyright = "(c) Copyright HAND Enterprise Solutions Company Ltd.";

    public void addPages() {
        super.addPages();
    }

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        IProject proj = this.getNewProject();
        if (proj == null) {
            return true;
        }
        try {
            proj.setDefaultCharset("UTF-8", null);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        IFolder web_inf = ResourceUtil.searchWebInf((IResource)proj);
        if (web_inf == null) {
            this.createBasicFolders(proj);
        } else {
            this.setPersistentProperty(proj, web_inf.getParent().getFullPath().toString(), web_inf.getFolder("classes").getFullPath().toString());
        }
        try {
            AuroraProjectNature.addAuroraNature(proj);
            if (web_inf != null) {
                this.startBuild();
            }
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    private void createBasicFolders(IProject proj) {
        String[] segs = new String[]{"webRoot", "WEB-INF", "classes"};
        IPath path = proj.getFullPath();
        try {
            String[] stringArray = segs;
            int n = segs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                path = path.append(s);
                IFolder f = proj.getParent().getFolder(path);
                f.create(false, true, null);
                ++n2;
            }
            this.setPersistentProperty(proj, proj.getFullPath().append(segs[0]).toString(), path.toString());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void setPersistentProperty(IProject proj, String webHome, String bmHome) {
        try {
            proj.setPersistentProperty(ProjectPropertyPage.WebQN, webHome);
            proj.setPersistentProperty(ProjectPropertyPage.BMQN, bmHome);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void startBuild() {
        Display.getCurrent().asyncExec((Runnable)this);
    }

    public void run() {
        try {
            AuroraPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.getNewProject().build(6, monitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

