/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.project.propertypage;

import aurora.ide.AuroraPlugin;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBConnectionUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ExceptionUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.helpers.SystemException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProjectPropertyPage
extends PropertyPage
implements Runnable,
IRunnableWithProgress {
    public static final String PropertyId = "aurora.ide.projectproperty";
    private static final String LOCAL_WEB_URL = "LOCAL_WEB_URL";
    private static final String WEB_HOME = "WEB_HOME";
    private static final String BM_HOME = "BM_HOME";
    private static final String DebugMode = "DEBUG_MODE";
    private static final String BUILD_RIGHT_NOW = "BUILD_RIGHT_NOW";
    public static final QualifiedName LoclaUrlHomeQN = new QualifiedName("aurora.ide", "LOCAL_WEB_URL");
    public static final QualifiedName WebQN = new QualifiedName("aurora.ide", "WEB_HOME");
    public static final QualifiedName BMQN = new QualifiedName("aurora.ide", "BM_HOME");
    public static final QualifiedName buildNow = new QualifiedName("aurora.ide", "BUILD_RIGHT_NOW");
    public static final QualifiedName DebugModeQN = new QualifiedName("aurora.ide", "DEBUG_MODE");
    private Text localWebUrlText;
    private Text webHomeText;
    private Text bmHomeText;
    private Button cb_isBuild;

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        content.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        Label localWebLabel = new Label(content, 0);
        localWebLabel.setText(LocaleMessage.getString("preview.url"));
        this.localWebUrlText = new Text(content, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.localWebUrlText.setLayoutData((Object)gridData);
        try {
            String localWebUrl = this.getProject().getPersistentProperty(LoclaUrlHomeQN);
            if (ProjectPropertyPage.filtEmpty(localWebUrl) != null) {
                this.localWebUrlText.setText(localWebUrl);
            } else {
                localWebUrl = ProjectUtil.autoGetLocalWebUrl(this.getProject());
                if (ProjectPropertyPage.filtEmpty(localWebUrl) != null) {
                    this.localWebUrlText.setText(localWebUrl);
                }
            }
        }
        catch (Throwable e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        Label webDirGroup = new Label(content, 0);
        webDirGroup.setText(LocaleMessage.getString("web.home"));
        this.webHomeText = new Text(content, 2048);
        this.webHomeText.setEditable(false);
        gridData = new GridData(768);
        this.webHomeText.setLayoutData((Object)gridData);
        String webDir = null;
        try {
            webDir = this.getProject().getPersistentProperty(WebQN);
            if (ProjectPropertyPage.filtEmpty(webDir) != null) {
                this.webHomeText.setText(webDir);
            } else {
                webDir = ProjectUtil.autoGetWebHome(this.getProject());
                if (ProjectPropertyPage.filtEmpty(webDir) != null) {
                    this.webHomeText.setText(webDir);
                }
            }
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
        }
        catch (SystemException e) {
            DialogUtil.logErrorException(e);
        }
        Button webBrowseButton = new Button(content, 8);
        webBrowseButton.setText(LocaleMessage.getString("openBrowse"));
        webBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] result;
                ContainerSelectionDialog dialog;
                IProject initSelection = ProjectPropertyPage.this.getProject();
                IFolder folder = ResourceUtil.getWebHomeFolder(ProjectPropertyPage.this.getProject());
                if (folder != null) {
                    initSelection = folder;
                }
                if ((dialog = new ContainerSelectionDialog(Display.getCurrent().getActiveShell(), (IContainer)initSelection, false, LocaleMessage.getString("please.select.the.path"))).open() == 0 && (result = dialog.getResult()).length == 1) {
                    IPath selectionPath = (IPath)result[0];
                    String errorMessage = ProjectPropertyPage.validWebHome(ProjectPropertyPage.this.getProject(), selectionPath);
                    if (errorMessage != null) {
                        DialogUtil.showErrorMessageBox(LocaleMessage.getString("check.failed"), errorMessage);
                        return;
                    }
                    ProjectPropertyPage.this.webHomeText.setText(selectionPath.toString());
                    ProjectPropertyPage.this.bmHomeText.setText(selectionPath.append("WEB-INF").append("classes").toString());
                }
            }
        });
        Label bmDirLabel = new Label(content, 0);
        bmDirLabel.setText(LocaleMessage.getString("bm.home"));
        this.bmHomeText = new Text(content, 2048);
        this.bmHomeText.setEditable(false);
        gridData = new GridData(768);
        this.bmHomeText.setLayoutData((Object)gridData);
        String bmDir = null;
        try {
            bmDir = this.getProject().getPersistentProperty(BMQN);
            if (ProjectPropertyPage.filtEmpty(bmDir) != null) {
                this.bmHomeText.setText(bmDir);
            } else {
                bmDir = ProjectUtil.autoGetBMHome(this.getProject());
                if (ProjectPropertyPage.filtEmpty(bmDir) != null) {
                    this.bmHomeText.setText(bmDir);
                }
            }
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
        }
        catch (SystemException e) {
            DialogUtil.logErrorException(e);
        }
        Button bmBrowseButton = new Button(content, 8);
        bmBrowseButton.setText(LocaleMessage.getString("openBrowse"));
        bmBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] result;
                ContainerSelectionDialog dialog;
                IProject initSelection = ProjectPropertyPage.this.getProject();
                IFolder folder = ResourceUtil.getBMHomeFolder(ProjectPropertyPage.this.getProject());
                if (folder != null) {
                    initSelection = folder;
                }
                if ((dialog = new ContainerSelectionDialog(Display.getCurrent().getActiveShell(), (IContainer)initSelection, false, LocaleMessage.getString("please.select.the.path"))).open() == 0 && (result = dialog.getResult()).length == 1) {
                    IPath selectionPath = (IPath)result[0];
                    String errorMessage = ProjectPropertyPage.validBMHome(ProjectPropertyPage.this.getProject(), selectionPath);
                    if (errorMessage != null) {
                        DialogUtil.showErrorMessageBox(LocaleMessage.getString("check.failed"), errorMessage);
                        return;
                    }
                    ProjectPropertyPage.this.bmHomeText.setText(selectionPath.toString());
                }
            }
        });
        Button testConn = new Button(content, 8);
        testConn.setText(LocaleMessage.getString("test.database"));
        gridData = new GridData(1);
        gridData.horizontalSpan = 3;
        testConn.setLayoutData((Object)gridData);
        testConn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProjectPropertyPage.this.checkInput()) {
                    if (ProjectPropertyPage.this.getErrorMessage() != null) {
                        DialogUtil.showErrorMessageBox(ProjectPropertyPage.this.getErrorMessage());
                    }
                    return;
                }
                ProjectPropertyPage.this.saveInput();
                try {
                    DBConnectionUtil.testDBConnection(ProjectPropertyPage.this.getProject(), ProjectPropertyPage.this.webHomeText.getText());
                }
                catch (ApplicationException ae) {
                    DialogUtil.showErrorMessageBox(LocaleMessage.getString("check.failed"), ExceptionUtil.getExceptionTraceMessage(ae));
                    return;
                }
                DialogUtil.showMessageBox(2, "OK", LocaleMessage.getString("test.database.ok"));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.cb_isBuild = new Button(content, 32);
        this.cb_isBuild.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.cb_isBuild.setText(LocaleMessage.getString("build.now"));
        this.cb_isBuild.setSelection(this.getStoredBuildOption());
        new Label(content, 0);
        return content;
    }

    private boolean checkInput() {
        IProject project = this.getProject();
        if (this.webHomeText.getText() == null || "".equals(this.webHomeText.getText())) {
            this.setErrorMessage(LocaleMessage.getString("require.webhome"));
            return false;
        }
        String msg = ProjectPropertyPage.validWebHome(project, (IPath)new Path(this.webHomeText.getText()));
        if (msg != null) {
            this.setErrorMessage(msg);
            return false;
        }
        msg = ProjectPropertyPage.validWebHome(project, (IPath)new Path(this.bmHomeText.getText()));
        if (msg != null) {
            this.setErrorMessage(msg);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void saveInput() {
        try {
            IProject project = this.getProject();
            project.setPersistentProperty(LoclaUrlHomeQN, this.localWebUrlText.getText());
            project.setPersistentProperty(WebQN, this.webHomeText.getText());
            project.setPersistentProperty(BMQN, this.bmHomeText.getText());
            project.setPersistentProperty(buildNow, Boolean.toString(this.cb_isBuild.getSelection()));
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public boolean performOk() {
        if (this.checkInput()) {
            this.saveInput();
            if (this.cb_isBuild.getSelection()) {
                Display.getCurrent().asyncExec((Runnable)this);
            }
            return true;
        }
        return false;
    }

    private IProject getProject() {
        return (IProject)this.getElement();
    }

    public static String filtEmpty(String str) {
        if ("".equals(str)) {
            return null;
        }
        return str;
    }

    public static String validWebHome(IProject project, IPath path) {
        IResource selectionResource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (selectionResource == null) {
            return LocaleMessage.getString("check.folder.not.exists");
        }
        if (!project.equals((Object)selectionResource.getProject())) {
            return LocaleMessage.getString("check.folder.not.in.project");
        }
        String locationPath = selectionResource.getLocation().toOSString();
        if (locationPath == null) {
            return LocaleMessage.getString("check.folder.not.in.os");
        }
        return null;
    }

    public static String validBMHome(IProject project, IPath path) {
        String classesDir = "classes";
        IResource selectionResource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (selectionResource == null) {
            return LocaleMessage.getString("check.folder.not.exists");
        }
        if (!project.equals((Object)selectionResource.getProject())) {
            return LocaleMessage.getString("check.folder.not.in.project");
        }
        String locationPath = selectionResource.getLocation().toOSString();
        if (locationPath == null) {
            return LocaleMessage.getString("check.folder.not.in.os");
        }
        if (!classesDir.equals(selectionResource.getName().toLowerCase())) {
            return String.format(LocaleMessage.getString("must.be.classes"), classesDir);
        }
        return null;
    }

    protected void performDefaults() {
        IProject proj = this.getProject();
        IFolder folder = ResourceUtil.searchWebInf((IResource)this.getProject());
        if (folder == null) {
            return;
        }
        IResource clsFolder = folder.findMember("classes");
        if (clsFolder instanceof IFolder) {
            try {
                this.localWebUrlText.setText(ProjectUtil.autoGetLocalWebUrl(proj));
                this.webHomeText.setText(ProjectUtil.autoGetWebHome(proj));
                this.bmHomeText.setText(ProjectUtil.autoGetBMHome(proj));
                this.cb_isBuild.setSelection(false);
            }
            catch (ApplicationException e) {
                e.printStackTrace();
            }
        }
        super.performDefaults();
    }

    private boolean getStoredBuildOption() {
        String str = null;
        try {
            str = this.getProject().getPersistentProperty(buildNow);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (str == null) {
            return false;
        }
        return Boolean.parseBoolean(str);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.getProject().build(6, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            AuroraPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)this);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }
}

