/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.project;

import aurora.ide.helpers.StringUtil;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AuroraProject {
    private IProject project;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IFolder getWeb_inf() {
        IContainer web_home = this.getWeb_home();
        if (StringUtil.isBlank(web_home)) {
            return null;
        }
        return web_home.getFolder((IPath)new Path("WEB-INF"));
    }

    public IContainer getWeb_home() {
        String web = "";
        try {
            web = this.project.getPersistentProperty(ProjectPropertyPage.WebQN);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (StringUtil.isBlank(web)) {
            return null;
        }
        Path path = new Path(web);
        if (path.segmentCount() == 1) {
            return this.project;
        }
        IFolder webHome = this.project.getParent().getFolder((IPath)path);
        return webHome;
    }

    public IFolder getWeb_classes() {
        String bm = "";
        try {
            bm = this.project.getPersistentProperty(ProjectPropertyPage.BMQN);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (StringUtil.isBlank(bm)) {
            return null;
        }
        Path path = new Path(bm);
        if (path.segmentCount() == 1) {
            return null;
        }
        IFolder bmHome = this.project.getParent().getFolder((IPath)new Path(bm));
        return bmHome;
    }

    public AuroraProject(IProject project) {
        this.project = project;
    }
}

