/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.preferencepages;

import aurora.ide.AuroraPlugin;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.navigator.action.SxsdValidVisablePropertyTester;
import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SxsdDirPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String SXSD_DIRECTORY = "SXSD_DIRECTORY";
    private List pathList;
    private Button removeButton;
    private Button editButton;
    private static final String delimiter = ",";

    public SxsdDirPreferencePage() {
        IPreferenceStore store = AuroraPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 16384);
        top.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        top.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        Label listLabel = new Label(top, 0);
        listLabel.setText(LocaleMessage.getString("sxsd.builtin-package.list"));
        gridData.horizontalSpan = 2;
        listLabel.setLayoutData((Object)gridData);
        this.pathList = new List(top, 2048);
        this.pathList.setItems(SxsdDirPreferencePage.getSxsdPaths());
        gridData = new GridData(4, 4, true, true);
        this.pathList.setLayoutData((Object)gridData);
        this.pathList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SxsdDirPreferencePage.this.selectionChanged();
            }
        });
        Composite buttonGroup = new Composite(top, 0);
        gridData = new GridData(4, 4, true, true);
        buttonGroup.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.pack = false;
        buttonGroup.setLayout((Layout)rowLayout);
        Button addButton = new Button(buttonGroup, 8);
        addButton.setText(LocaleMessage.getString("add.path"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SxsdDirPreferencePage.this.addButton();
            }
        });
        this.editButton = new Button(buttonGroup, 8);
        this.editButton.setText(LocaleMessage.getString("edit.path"));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SxsdDirPreferencePage.this.editButton();
            }
        });
        this.removeButton = new Button(buttonGroup, 8);
        this.removeButton.setText(LocaleMessage.getString("remove.path"));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SxsdDirPreferencePage.this.pathList.remove(SxsdDirPreferencePage.this.pathList.getSelectionIndex());
                SxsdDirPreferencePage.this.selectionChanged();
            }
        });
        return top;
    }

    public void init(IWorkbench wb) {
    }

    public boolean performOk() {
        if (!this.refreshSxsdPaths(this.pathList.getItems())) {
            return false;
        }
        return super.performOk();
    }

    private void addButton() {
        String path;
        SxsdBuiltinPackagePathDialog dir = new SxsdBuiltinPackagePathDialog(new Shell());
        if (dir.open() == 0 && (path = dir.getPath()) != null && path.length() > 0) {
            this.pathList.add(path);
        }
    }

    private void editButton() {
        SxsdBuiltinPackagePathDialog dir = new SxsdBuiltinPackagePathDialog(new Shell(), this.pathList.getSelection()[0]);
        if (dir.open() == 0) {
            this.pathList.remove(this.pathList.getSelectionIndex());
            String path = dir.getPath();
            if (path != null && path.length() > 0) {
                this.pathList.add(path);
            }
        }
    }

    private void selectionChanged() {
        int index = this.pathList.getSelectionIndex();
        this.removeButton.setEnabled(index >= 0);
        this.editButton.setEnabled(index >= 0);
    }

    public boolean refreshSxsdPaths(String[] elements) {
        if (!LoadSchemaManager.refeshSchemaManager(elements)) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            buffer.append(elements[i]);
            buffer.append(delimiter);
            ++i;
        }
        AuroraPlugin.getDefault().getPreferenceStore().setValue(SXSD_DIRECTORY, buffer.toString());
        return true;
    }

    public static String[] getSxsdPaths() {
        String preferenceValue = AuroraPlugin.getDefault().getPreferenceStore().getString(SXSD_DIRECTORY);
        StringTokenizer tokenizer = new StringTokenizer(preferenceValue, delimiter);
        int tokenCount = tokenizer.countTokens();
        String[] elements = new String[tokenCount];
        int i = 0;
        while (i < tokenCount) {
            elements[i] = tokenizer.nextToken();
            ++i;
        }
        return elements;
    }

    class SxsdBuiltinPackagePathDialog
    extends TitleAreaDialog {
        Text pathText;
        String textPath;

        public SxsdBuiltinPackagePathDialog(Shell shell) {
            super(shell);
        }

        public SxsdBuiltinPackagePathDialog(Shell shell, String defaultPath) {
            super(shell);
            this.textPath = defaultPath;
        }

        protected Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            this.setTitle(LocaleMessage.getString("add.sxsd.builtin-package.path"));
            return contents;
        }

        protected Control createDialogArea(Composite parent) {
            Composite control = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(control, 0);
            GridData gridData = new GridData(4, 0x1000000, true, true);
            composite.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite.setLayout((Layout)gridLayout);
            Label propertyLabe = new Label(composite, 0);
            propertyLabe.setText(LocaleMessage.getString("sxsd.builtin-package.path"));
            this.pathText = new Text(composite, 2048);
            this.pathText.setEditable(false);
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.heightHint = 17;
            this.pathText.setLayoutData((Object)gridData);
            if (this.textPath != null) {
                this.pathText.setText(this.textPath);
            }
            Button brower = new Button(composite, 8);
            this.setButtonLayoutData(brower);
            brower.setText(LocaleMessage.getString("openBrowse"));
            brower.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(new Shell());
                    if (SxsdBuiltinPackagePathDialog.this.pathText.getText() != null) {
                        directoryDialog.setFilterPath(SxsdBuiltinPackagePathDialog.this.pathText.getText());
                    }
                    String path = directoryDialog.open();
                    SxsdBuiltinPackagePathDialog.this.pathText.setText(path);
                    SxsdBuiltinPackagePathDialog.this.textPath = path;
                    Button OK = SxsdBuiltinPackagePathDialog.this.getButton(0);
                    if (SxsdBuiltinPackagePathDialog.this.validSxsdDir(path)) {
                        OK.setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            brower.setFocus();
            return composite;
        }

        public boolean validSxsdDir(String sxsdDir) {
            boolean isValid = SxsdValidVisablePropertyTester.isValidDir(new File(sxsdDir));
            if (!isValid) {
                DialogUtil.showErrorMessageBox("this.path.is.not.valid");
                return false;
            }
            return true;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button OK = this.getButton(0);
            OK.setEnabled(false);
        }

        protected boolean isResizable() {
            return true;
        }

        public String getPath() {
            return this.textPath;
        }
    }
}

