/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.preferencepages;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.statistics.map.PreferencesTag;
import aurora.ide.dialog.AddTagDialog;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.preferencepages.TagTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import uncertain.schema.AbstractQualifiedNamed;
import uncertain.schema.ISchemaManager;

public class StatisticianPropertyPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Map<String, List<String>> customMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> baseMap = new HashMap<String, List<String>>();
    private TagTree baseMapTree = new TagTree(null, "root", "root");
    private ContainerCheckedTreeViewer treeViewer = null;
    private IPreferenceStore store = AuroraPlugin.getDefault().getPreferenceStore();
    private final String[] noNamespace = new String[]{"query-fields", "columns", "center", "event", "features", "data-filter", "form", "table", "UL", "view", "IMG", "model-delete", "service-output", "model-update", "param", "A", "events", "mapping", "map", "model-load", "model-query", "a", "field", "H2", "tr", "img", "ref-field", "td", "br", "TABLE", "model-insert", "parameters", "font", "label", "script", "input", "iframe", "column", "query-field", "span", "model-execute", "model", "TD", "batch-apply", "div", "TR", "datas", "pk-field", "parameter", "style", "tbody", "DIV", "service", "LI"};
    private String selectNamespace = "";
    private String selectTag = "";
    private boolean modify = false;
    private String checked = "";

    public StatisticianPropertyPage() {
        ISchemaManager schemaManager = LoadSchemaManager.getSchemaManager();
        for (Object object : schemaManager.getAllTypes()) {
            this.initBaseTree((AbstractQualifiedNamed)object);
        }
        String[] stringArray = this.noNamespace;
        int n = this.noNamespace.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            this.baseMapTree.Add("No namespace", tag);
            ++n2;
        }
        this.baseMap = this.baseMapTree.getMap();
        String[] ss = this.store.getString("statistician.custom").split("!");
        String namespace = "";
        String[] stringArray2 = ss;
        int n3 = ss.length;
        int n4 = 0;
        while (n4 < n3) {
            String s = stringArray2[n4];
            if (!"".equals(s.trim())) {
                if (s.indexOf("*") == 0) {
                    namespace = s = s.substring(1);
                    this.customMap.put(s, new ArrayList());
                } else {
                    this.customMap.get(namespace).add(s);
                    this.baseMapTree.Add(namespace, s);
                }
            }
            ++n4;
        }
        this.baseMapTree.sort(false);
    }

    private void initBaseTree(AbstractQualifiedNamed aqn) {
        if (aqn.getQName() != null) {
            String namespace;
            String string = namespace = aqn.getQName().getNameSpace() == null ? "No namespace" : aqn.getQName().getNameSpace();
            if (!"http://www.uncertain-framework.org/schema/simple-schema".equalsIgnoreCase(namespace)) {
                this.baseMapTree.Add(namespace, aqn.getQName().getLocalName());
            }
        }
        if (aqn.getChilds() == null) {
            return;
        }
        for (Object obj : aqn.getChilds()) {
            if (!(obj instanceof AbstractQualifiedNamed)) continue;
            this.initBaseTree((AbstractQualifiedNamed)obj);
        }
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        GridData gdTreeViewer = new GridData(1808);
        gdTreeViewer.verticalSpan = 4;
        this.treeViewer = new ContainerCheckedTreeViewer(container);
        TextCellEditor cellEditor = new TextCellEditor((Composite)this.treeViewer.getTree());
        this.treeViewer.setCellEditors(new CellEditor[]{cellEditor});
        this.treeViewer.setCellModifier((ICellModifier)new CellModifier((TreeViewer)this.treeViewer));
        this.treeViewer.setColumnProperties(new String[]{"item"});
        GridData gdBtnAdd = new GridData();
        gdBtnAdd.verticalAlignment = 128;
        gdBtnAdd.widthHint = 100;
        Button btnAdd = new Button(container, 0);
        btnAdd.setText("Add");
        btnAdd.setLayoutData((Object)gdBtnAdd);
        btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String[] namespaces = new String[StatisticianPropertyPage.this.baseMapTree.getChildren().size()];
                int i = 0;
                while (i < StatisticianPropertyPage.this.baseMapTree.getChildren().size()) {
                    namespaces[i] = StatisticianPropertyPage.this.baseMapTree.getChildren().get(i).getNamespace();
                    ++i;
                }
                AddTagDialog dialog = new AddTagDialog(StatisticianPropertyPage.this.getShell(), namespaces, StatisticianPropertyPage.this.baseMapTree.getMap(), StatisticianPropertyPage.this.selectNamespace);
                if (dialog.open() == 0) {
                    Map<String, List<String>> map = dialog.getCustomMap();
                    for (String namespace : map.keySet()) {
                        if (!StatisticianPropertyPage.this.customMap.containsKey(namespace)) {
                            StatisticianPropertyPage.this.customMap.put(namespace, new ArrayList());
                        }
                        for (String tag : map.get(namespace)) {
                            StatisticianPropertyPage.this.baseMapTree.Add(namespace, tag);
                            if (((List)StatisticianPropertyPage.this.customMap.get(namespace)).contains(tag)) continue;
                            ((List)StatisticianPropertyPage.this.customMap.get(namespace)).add(tag);
                        }
                    }
                }
                StatisticianPropertyPage.this.baseMapTree.sort(false);
                StatisticianPropertyPage.this.modify = true;
                StatisticianPropertyPage.this.treeViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gdBtnRemove = new GridData();
        gdBtnRemove.verticalAlignment = 128;
        gdBtnRemove.widthHint = 100;
        final Button btnRemove = new Button(container, 0);
        btnRemove.setText("Remove");
        btnRemove.setLayoutData((Object)gdBtnRemove);
        btnRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TagTree t = StatisticianPropertyPage.this.baseMapTree.remove(StatisticianPropertyPage.this.selectNamespace, StatisticianPropertyPage.this.selectTag);
                StatisticianPropertyPage.this.treeViewer.refresh((Object)t.getParent());
                if (!StatisticianPropertyPage.this.customMap.containsKey(t.getTag())) {
                    ((List)StatisticianPropertyPage.this.customMap.get(t.getNamespace())).remove(t.getTag());
                } else {
                    StatisticianPropertyPage.this.customMap.remove(t.getTag());
                }
                StatisticianPropertyPage.this.modify = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        btnRemove.setEnabled(false);
        GridData gdBtnSelectAll = new GridData();
        gdBtnSelectAll.verticalAlignment = 128;
        gdBtnSelectAll.widthHint = 100;
        Button btnSelectAll = new Button(container, 0);
        btnSelectAll.setText("Select All");
        btnSelectAll.setLayoutData((Object)gdBtnSelectAll);
        btnSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (TagTree t : StatisticianPropertyPage.this.baseMapTree.getChildren()) {
                    StatisticianPropertyPage.this.treeViewer.setChecked((Object)t, true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gdBtnDeselectAll = new GridData();
        gdBtnDeselectAll.verticalAlignment = 128;
        gdBtnDeselectAll.widthHint = 100;
        Button btnDeselectAll = new Button(container, 0);
        btnDeselectAll.setText("Deselect All");
        btnDeselectAll.setLayoutData((Object)gdBtnDeselectAll);
        btnDeselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (TagTree t : StatisticianPropertyPage.this.baseMapTree.getChildren()) {
                    StatisticianPropertyPage.this.treeViewer.setChecked((Object)t, false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setLayoutData((Object)gdTreeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((TagTree)inputElement).getChildren().toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((TagTree)parentElement).getChildren().toArray();
            }

            public Object getParent(Object element) {
                return ((TagTree)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((TagTree)element).getChildren().size() > 0;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                TagTree tt = (TagTree)element;
                if (StatisticianPropertyPage.this.baseMap.containsKey(tt.getNamespace())) {
                    if (tt.getNamespace().equals(tt.getTag())) {
                        return element.toString();
                    }
                    if (((List)StatisticianPropertyPage.this.baseMap.get(tt.getNamespace())).contains(tt.getTag())) {
                        return element.toString();
                    }
                }
                return String.valueOf(element.toString()) + "*";
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection ts = (TreeSelection)event.getSelection();
                TagTree tree = (TagTree)ts.getFirstElement();
                if (tree == null) {
                    btnRemove.setEnabled(false);
                    return;
                }
                StatisticianPropertyPage.this.selectNamespace = tree.getNamespace();
                StatisticianPropertyPage.this.selectTag = tree.getTag();
                if (StatisticianPropertyPage.this.baseMap.containsKey(StatisticianPropertyPage.this.selectNamespace)) {
                    if (StatisticianPropertyPage.this.selectNamespace.equals(StatisticianPropertyPage.this.selectTag)) {
                        btnRemove.setEnabled(false);
                    } else if (((List)StatisticianPropertyPage.this.baseMap.get(StatisticianPropertyPage.this.selectNamespace)).contains(StatisticianPropertyPage.this.selectTag)) {
                        btnRemove.setEnabled(false);
                    } else {
                        btnRemove.setEnabled(true);
                    }
                } else {
                    btnRemove.setEnabled(true);
                }
            }
        });
        this.treeViewer.setInput((Object)this.baseMapTree);
        this.load(false);
        return container;
    }

    protected void performDefaults() {
        this.updateApplyButton();
        this.load(true);
    }

    public boolean performOk() {
        this.save();
        if (this.modify) {
            StringBuffer sb = new StringBuffer();
            for (String n : this.customMap.keySet()) {
                sb.append("*" + n);
                for (String t : this.customMap.get(n)) {
                    sb.append("!" + t);
                }
                sb.append("!");
            }
            this.store.setValue("statistician.custom", sb.toString());
        }
        this.store.setValue("statistician.checked", this.checked);
        try {
            ((ScopedPreferenceStore)this.store).save();
            return super.performOk();
        }
        catch (IOException e) {
            return false;
        }
    }

    private void save() {
        StringBuffer sb = new StringBuffer();
        Object[] objectArray = this.treeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (this.baseMapTree.contains(o)) {
                sb.append("*");
            }
            sb.append(o.toString());
            sb.append("!");
            ++n2;
        }
        this.checked = sb.toString();
    }

    public void init(IWorkbench workbench) {
    }

    private void load(final boolean defaultValue) {
        for (TagTree t : this.baseMapTree.getChildren()) {
            this.treeViewer.setChecked((Object)t, false);
        }
        if (this.store.getDefaultString("statistician.checked").trim().equals("")) {
            StringBuffer defaultStore = new StringBuffer();
            Map defaultMap = PreferencesTag.INSTANCE().getDefaultMap();
            for (String n : defaultMap.keySet()) {
                defaultStore.append("*");
                defaultStore.append(n);
                defaultStore.append("!");
                for (String t : (List)defaultMap.get(n)) {
                    defaultStore.append(t);
                    defaultStore.append("!");
                }
            }
            this.store.setDefault("statistician.checked", defaultStore.toString());
            this.store.setValue("statistician.checked", defaultStore.toString());
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String[] storeTag = null;
                storeTag = defaultValue ? StatisticianPropertyPage.this.store.getDefaultString("statistician.checked").split("!") : StatisticianPropertyPage.this.store.getString("statistician.checked").split("!");
                String namespace = "";
                String[] stringArray = storeTag;
                int n = storeTag.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!"".equals(s.trim())) {
                        if (s.startsWith("*")) {
                            namespace = s = s.substring(1);
                        } else {
                            TagTree find = StatisticianPropertyPage.this.baseMapTree.find(namespace, s);
                            if (find != null) {
                                StatisticianPropertyPage.this.treeViewer.setChecked((Object)find, true);
                            }
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    class CellModifier
    implements ICellModifier {
        boolean isDoubleClick = false;
        private Object element = null;
        private TreeViewer treeViewer;

        public CellModifier(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
            this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    CellModifier.this.isDoubleClick = true;
                    if (CellModifier.this.element != null) {
                        CellModifier.this.treeViewer.editElement(CellModifier.this.element, 0);
                    }
                    CellModifier.this.isDoubleClick = false;
                }
            });
        }

        public boolean canModify(Object element, String property) {
            this.element = element;
            if (this.isDoubleClick && this.modify(element)) {
                this.isDoubleClick = false;
                return true;
            }
            return false;
        }

        private boolean modify(Object element) {
            if (!(element instanceof TagTree)) {
                return false;
            }
            TagTree t = (TagTree)element;
            if (StatisticianPropertyPage.this.baseMap.containsKey(t.getNamespace())) {
                if (((List)StatisticianPropertyPage.this.baseMap.get(t.getNamespace())).contains(t.getTag())) {
                    return false;
                }
                if (t.getNamespace().equals(t.getTag())) {
                    return false;
                }
            }
            return true;
        }

        public Object getValue(Object element, String property) {
            return ((TagTree)element).getTag();
        }

        public void modify(Object element, String property, Object value) {
            TagTree tagTree = null;
            if (element instanceof Item) {
                tagTree = (TagTree)((Item)element).getData();
            } else if (element instanceof TagTree) {
                tagTree = (TagTree)element;
            }
            for (TagTree t : tagTree.getParent().getChildren()) {
                if (!t.getTag().equals(value)) continue;
                return;
            }
            if (tagTree.getNamespace().equals(tagTree.getTag())) {
                StatisticianPropertyPage.this.customMap.remove(tagTree.getNamespace());
                tagTree.setNamespace((String)value);
                tagTree.setTag((String)value);
                StatisticianPropertyPage.this.customMap.put(tagTree.getNamespace(), new ArrayList());
                for (TagTree t : tagTree.getChildren()) {
                    t.setNamespace((String)value);
                    ((List)StatisticianPropertyPage.this.customMap.get(tagTree.getNamespace())).add(t.getTag());
                }
            } else {
                ((List)StatisticianPropertyPage.this.customMap.get(tagTree.getNamespace())).remove(tagTree.getTag());
                tagTree.setTag((String)value);
                ((List)StatisticianPropertyPage.this.customMap.get(tagTree.getNamespace())).add(tagTree.getTag());
            }
            StatisticianPropertyPage.this.baseMapTree.sort(false);
            this.treeViewer.refresh((Object)tagTree.getParent());
            StatisticianPropertyPage.this.modify = true;
        }
    }
}

