/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.preferencepages;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.preferencepages.BaseTemplatePreferencePage;
import aurora.ide.preferencepages.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditTemplateDialog
extends Dialog {
    private Text text_name;
    private Text text_desc;
    private Text text_tpl;
    private Label lbl_status;
    private BaseTemplatePreferencePage.Template tpl;
    private Button okBtn;
    private BaseTemplatePreferencePage.Config config;
    private BaseTemplatePreferencePage preferencePage;

    public EditTemplateDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(1152);
    }

    public EditTemplateDialog(Shell parentShell, BaseTemplatePreferencePage.Template tpl) {
        this(parentShell);
        this.tpl = tpl;
    }

    public void setPreferencePage(BaseTemplatePreferencePage page) {
        this.preferencePage = page;
        this.config = page.getConfig();
    }

    public BaseTemplatePreferencePage.Template getTemplate() {
        return this.tpl;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        if (this.tpl == null) {
            this.getShell().setText(Messages.EditTemplateDialog_0);
            CommentCompositeMap data = new CommentCompositeMap("template");
            this.tpl = new BaseTemplatePreferencePage.Template(data);
            this.tpl.isNew = true;
        } else {
            this.getShell().setText(Messages.EditTemplateDialog_2);
        }
        container.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(Messages.EditTemplateDialog_3);
        this.text_name = new Text(container, 2048);
        GridData gd_text_name = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_text_name.widthHint = 76;
        this.text_name.setLayoutData((Object)gd_text_name);
        Label label_1 = new Label(container, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText(Messages.EditTemplateDialog_4);
        this.text_desc = new Text(container, 2048);
        this.text_desc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblNewLabel.setText(Messages.EditTemplateDialog_5);
        this.text_tpl = new Text(container, 2818);
        this.text_tpl.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        new Label(container, 0);
        this.lbl_status = new Label(container, 0);
        this.lbl_status.setForeground(Display.getDefault().getSystemColor(3));
        this.lbl_status.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.init();
        return container;
    }

    void init() {
        String name = this.tpl.getName();
        if (name == null) {
            name = "";
        }
        this.text_name.setText(name);
        String desc = this.tpl.getDescription();
        if (desc == null) {
            desc = "";
        }
        this.text_desc.setText(desc);
        String str = this.tpl.getTemplateString();
        if (str == null) {
            str = "";
        }
        this.text_tpl.setText(str);
        if (this.text_name.getText().length() == 0) {
            this.text_name.forceFocus();
        } else {
            this.text_tpl.forceFocus();
        }
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.validateInput();
            }
        };
        this.text_name.addModifyListener(ml);
        this.text_desc.addModifyListener(ml);
        this.text_tpl.addModifyListener(ml);
    }

    void validateInput() {
        String name = this.text_name.getText();
        if (name.length() == 0) {
            this.updateStatus(Messages.EditTemplateDialog_9);
            return;
        }
        for (BaseTemplatePreferencePage.Template t : this.config.list) {
            if (this.tpl == t || t.markDelete || !t.getName().equals(name)) continue;
            this.updateStatus(Messages.EditTemplateDialog_10);
            return;
        }
        this.updateStatus(this.preferencePage.validateTemplate(this.text_tpl.getText()));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okBtn = this.createButton(parent, 9, IDialogConstants.OK_LABEL, true);
        if (this.tpl.isNew) {
            this.okBtn.setEnabled(false);
        } else {
            this.validateInput();
        }
        this.okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.tpl.setName(EditTemplateDialog.this.text_name.getText());
                EditTemplateDialog.this.tpl.setDescription(EditTemplateDialog.this.text_desc.getText());
                EditTemplateDialog.this.tpl.setTemplateString(EditTemplateDialog.this.text_tpl.getText());
                EditTemplateDialog.this.setReturnCode(0);
                EditTemplateDialog.this.close();
            }
        });
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void updateStatus(String str) {
        this.lbl_status.setText(str == null ? "" : str);
        this.okBtn.setEnabled(str == null);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }
}

