/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.preferencepages;

import aurora.ide.AuroraPlugin;
import aurora.ide.freemarker.FreeMarkerGenerator;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.FileCopyer;
import aurora.ide.helpers.FileDeleter;
import aurora.ide.helpers.StatusUtil;
import aurora.ide.preferencepages.EditTemplateDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String config_file_name = "config.xml";
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fExportButton;
    private Button fRemoveButton;
    private Button fRestoreButton;
    private Button fRevertButton;
    private SourceViewer fPatternViewer;
    private File templateDir;
    private Config config;

    public void init(IWorkbench workbench) {
        this.templateDir = BaseTemplatePreferencePage.getTemplateDir(this.getTemplateDirName());
        if (!this.templateDir.exists()) {
            BaseTemplatePreferencePage.reset(this.templateDir);
        }
        this.initConfig();
    }

    static File getTemplateDir(String dirName) {
        IPath path = AuroraPlugin.getDefault().getStateLocation().append("templates").append(dirName);
        return new File(path.toString());
    }

    static File getConfigFile(File dir) {
        return new File(dir, config_file_name);
    }

    static Config loadConfig(File cfgFile) throws IOException, SAXException {
        CompositeMap map = new CompositeLoader().loadByFullFilePath(cfgFile.getAbsolutePath());
        Config cfg = new Config(map);
        return cfg;
    }

    public static InputStream getTemplateContent(String dirname) throws IOException, SAXException {
        File tplFile = BaseTemplatePreferencePage.getTemplateFile(dirname);
        if (tplFile != null) {
            return new FileInputStream(tplFile);
        }
        return null;
    }

    public static File getTemplateFile(String dirname) throws IOException, SAXException {
        File dir = BaseTemplatePreferencePage.getTemplateDir(dirname);
        if (!dir.exists()) {
            BaseTemplatePreferencePage.reset(dir);
        }
        File cfgFile = BaseTemplatePreferencePage.getConfigFile(dir);
        Config cfg = BaseTemplatePreferencePage.loadConfig(cfgFile);
        String def = cfg.map.getString((Object)"default");
        CompositeMap root = cfg.getTemplatesRoot();
        List list = root.getChildsNotNull();
        String fn = null;
        if (def != null) {
            for (CompositeMap m : list) {
                if (!def.equals(m.getString((Object)"name"))) continue;
                fn = m.getString((Object)"file");
                break;
            }
        }
        if (fn != null) {
            return new File(dir, fn);
        }
        return null;
    }

    protected abstract String getTemplateDirName();

    private void initConfig() {
        File configFile = BaseTemplatePreferencePage.getConfigFile(this.templateDir);
        try {
            this.config = BaseTemplatePreferencePage.loadConfig(configFile);
        }
        catch (Exception e) {
            this.config = new Config(new CompositeMap());
            StatusUtil.showExceptionDialog(null, "Error", "Failed to load " + config_file_name, false, e);
            return;
        }
        Template[] templateArray = this.config.getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template tpl = templateArray[n2];
            File f = new File(this.templateDir, tpl.getFile());
            tpl.templateStr = this.getFileContent(f);
            ++n2;
        }
    }

    protected abstract Map<?, ?> getSimpleModel();

    private String getFileContent(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] bs = new byte[(int)(file.length() + 10L)];
            int len = fis.read(bs);
            fis.close();
            return new String(bs, 0, len, "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    private void setFileContent(File f, String content) {
        if (content == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(content.getBytes("UTF-8"));
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void reset(File templateDir) {
        URL ts = FileLocator.find((Bundle)Platform.getBundle((String)"aurora.ide"), (IPath)new Path("templates/" + templateDir.getName()), null);
        try {
            ts = FileLocator.toFileURL((URL)ts);
            File initTplDir = new Path(ts.getPath()).toFile();
            FileCopyer.copyDirectory(initTplDir, templateDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        Composite tableComposite = new Composite(innerParent, 0);
        tableComposite.setLayout((Layout)new FillLayout(256));
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        Table table = new Table(tableComposite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setWidth(128);
        column1.setText("Name");
        TableColumn column2 = new TableColumn(table, 0);
        column2.setWidth(193);
        column2.setText("Description");
        gc.dispose();
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)new ConfigContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setInput((Object)this.config);
        this.selectDefault();
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                BaseTemplatePreferencePage.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] objs;
                Object data = event.getElement();
                Object[] objectArray = objs = BaseTemplatePreferencePage.this.fTableViewer.getCheckedElements();
                int n = objs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o != data) {
                        BaseTemplatePreferencePage.this.fTableViewer.setChecked(o, false);
                    }
                    ++n2;
                }
                objs = BaseTemplatePreferencePage.this.fTableViewer.getCheckedElements();
                if (objs.length == 1) {
                    BaseTemplatePreferencePage.this.config.setDefault((Template)objs[0]);
                }
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = new Button(buttons, 8);
        this.fAddButton.setText("New...");
        this.fAddButton.setLayoutData((Object)BaseTemplatePreferencePage.getButtonGridData(this.fAddButton));
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BaseTemplatePreferencePage.this.add();
            }
        });
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText("Edit...");
        this.fEditButton.setEnabled(false);
        this.fEditButton.setLayoutData((Object)BaseTemplatePreferencePage.getButtonGridData(this.fEditButton));
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BaseTemplatePreferencePage.this.edit();
            }
        });
        this.fRemoveButton = new Button(buttons, 8);
        this.fRemoveButton.setText("Remove");
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.setLayoutData((Object)BaseTemplatePreferencePage.getButtonGridData(this.fRemoveButton));
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                BaseTemplatePreferencePage.this.remove();
            }
        });
        this.createSeparator(buttons);
        this.fPatternViewer = this.doCreateViewer(parent);
        Dialog.applyDialogFont((Control)parent);
        new Label(parent, 0);
        innerParent.layout();
        return parent;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    protected boolean isShowFormatterSetting() {
        return true;
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Preview:");
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        Cursor arrowCursor = viewer.getTextWidget().getDisplay().getSystemCursor(0);
        viewer.getTextWidget().setCursor(arrowCursor);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        StyledText styledText = viewer.getTextWidget();
        styledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        viewer.setEditable(false);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        viewer.configure(configuration);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    private void selectionChanged1() {
        this.updateViewerInput();
        this.updateButtons();
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            Template data = (Template)selection.getFirstElement();
            String template = data.getTemplateString();
            this.fPatternViewer.getDocument().set(template);
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount);
    }

    boolean checkValid() {
        if (this.config == null || this.config.map == null || this.config.map.getName() == null) {
            DialogUtil.showErrorMessageBox("\u5f53\u524d\u914d\u7f6e\u5bf9\u8c61\u65e0\u6548");
            return false;
        }
        return true;
    }

    private void add() {
        if (!this.checkValid()) {
            return;
        }
        EditTemplateDialog ctd = new EditTemplateDialog(this.getShell());
        ctd.setPreferencePage(this);
        if (ctd.open() == 0) {
            Template tpl = ctd.getTemplate();
            this.config.add(tpl);
            this.fTableViewer.refresh();
        }
    }

    private void edit() {
        if (!this.checkValid()) {
            return;
        }
        EditTemplateDialog ctd = new EditTemplateDialog(this.getShell(), this.getCurrentTemplate());
        ctd.setPreferencePage(this);
        if (ctd.open() == 0) {
            Template tpl = ctd.getTemplate();
            this.fTableViewer.refresh((Object)tpl);
            this.updateViewerInput();
        }
    }

    private void remove() {
        Object[] objs;
        if (!this.checkValid()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objectArray = objs = selection.toArray();
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Template t = (Template)o;
            if (t.isNew) {
                this.config.remove(t);
            } else {
                t.markDelete = true;
            }
            ++n2;
        }
        this.fTableViewer.refresh();
    }

    private Template getCurrentTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        return (Template)selection.getFirstElement();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    protected void performDefaults() {
        int showConfirmDialogBox = DialogUtil.showConfirmDialogBox("default", "\u662f\u5426\u91cd\u7f6e\uff1f");
        if (showConfirmDialogBox == 0) {
            FileDeleter.deleteDirectory(this.templateDir);
            BaseTemplatePreferencePage.reset(this.templateDir);
            this.initConfig();
            this.fTableViewer.setInput((Object)this.config);
            this.fTableViewer.refresh();
            this.selectDefault();
        }
    }

    private void selectDefault() {
        Template t = this.config.getDefaultTemplate();
        if (t != null) {
            this.fTableViewer.setChecked((Object)t, true);
        }
    }

    public boolean performOk() {
        File f;
        if (!this.checkValid()) {
            return false;
        }
        boolean has_change = false;
        int i = 0;
        while (i < this.config.list.size()) {
            Template tpl = this.config.list.get(i);
            if (!tpl.isNew && tpl.markDelete) {
                this.debug("delete:" + tpl.getName());
                has_change = true;
                f = new File(this.templateDir, tpl.getFile());
                f.delete();
                this.config.list.remove(i--);
                this.config.getTemplatesRoot().removeChild(tpl.map);
            }
            ++i;
        }
        for (Template tpl : this.config.list) {
            if (tpl.isNew) {
                this.debug("create:" + tpl.getName());
                has_change = true;
                tpl.setFile(String.valueOf(this.getNewFileName(tpl)) + ".tpl");
                f = new File(this.templateDir, tpl.getFile());
                this.setFileContent(f, tpl.getTemplateString());
                this.config.getTemplatesRoot().addChild(tpl.map);
                continue;
            }
            if (!tpl.dirty) continue;
            this.debug("update:" + tpl.getName());
            has_change = true;
            f = new File(this.templateDir, tpl.getFile());
            this.setFileContent(f, tpl.getTemplateString());
        }
        if (has_change || this.config.dirty) {
            this.debug("update " + config_file_name);
            File f2 = new File(this.templateDir, config_file_name);
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + this.config.map.toXML();
            this.setFileContent(f2, xml);
        }
        this.config.dirty = false;
        for (Template t : this.config.list) {
            t.resetFlag();
        }
        return super.performOk();
    }

    void debug(Object obj) {
    }

    protected String getNewFileName(Template tpl) {
        return tpl.getName();
    }

    protected String validateTemplate(String content) {
        Map<?, ?> model = this.getSimpleModel();
        if (model == null) {
            return null;
        }
        try {
            freemarker.template.Template template = new freemarker.template.Template("test", (Reader)new StringReader(content));
            FreeMarkerGenerator fg = new FreeMarkerGenerator();
            fg.gen(template, model);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    Config getConfig() {
        return this.config;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected SourceViewer getViewer() {
        return this.fPatternViewer;
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    static class Config {
        CompositeMap map;
        ArrayList<Template> list = new ArrayList();
        boolean dirty = false;

        Config(CompositeMap configMap) {
            this.map = configMap;
            CompositeMap tplRoot = this.getTemplatesRoot();
            if (tplRoot != null) {
                List childs = tplRoot.getChildsNotNull();
                for (CompositeMap m : childs) {
                    this.list.add(new Template(m));
                }
            }
        }

        Template getDefaultTemplate() {
            String def = this.map.getString((Object)"default");
            Template[] templateArray = this.getTemplates();
            int n = templateArray.length;
            int n2 = 0;
            while (n2 < n) {
                Template tpl = templateArray[n2];
                if (def.equalsIgnoreCase(tpl.getName())) {
                    return tpl;
                }
                ++n2;
            }
            return null;
        }

        void setDefault(Template tpl) {
            if (!tpl.eq(this.map.getString((Object)"default"), tpl.getName())) {
                this.dirty = true;
                this.map.put((Object)"default", (Object)tpl.getName());
            }
        }

        Template[] getTemplates() {
            ArrayList<Template> tmpList = new ArrayList<Template>();
            for (Template tpl : this.list) {
                if (tpl.markDelete) continue;
                tmpList.add(tpl);
            }
            Template[] ts = new Template[tmpList.size()];
            return tmpList.toArray(ts);
        }

        void add(Template tpl) {
            this.list.add(tpl);
        }

        void remove(Template tpl) {
            this.list.remove(tpl);
        }

        CompositeMap getTemplatesRoot() {
            return this.map.getChild("templates");
        }
    }

    class ConfigContentProvider
    implements IStructuredContentProvider {
        ConfigContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Config) {
                return ((Config)inputElement).getTemplates();
            }
            return null;
        }
    }

    static class Template {
        CompositeMap map;
        boolean isNew = false;
        boolean dirty = false;
        boolean markDelete = false;
        String templateStr = "";

        Template(CompositeMap map) {
            this.map = map;
        }

        void resetFlag() {
            this.isNew = false;
            this.dirty = false;
            this.markDelete = false;
        }

        String getName() {
            return this.map.getString((Object)"name");
        }

        void setName(String name) {
            if (!this.eq(this.getName(), name)) {
                this.dirty = true;
                this.map.put((Object)"name", (Object)name);
            }
        }

        String getFile() {
            return this.map.getString((Object)"file");
        }

        void setFile(String string) {
            this.map.put((Object)"file", (Object)string);
        }

        String getDescription() {
            return this.map.getString((Object)"description");
        }

        void setDescription(String desc) {
            if (!this.eq(this.getDescription(), desc)) {
                this.dirty = true;
                this.map.put((Object)"description", (Object)desc);
            }
        }

        String getTemplateString() {
            return this.templateStr;
        }

        void setTemplateString(String tpl) {
            if (!this.eq(this.getTemplateString(), tpl)) {
                this.dirty = true;
                this.templateStr = tpl;
            }
        }

        boolean eq(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }
    }

    class TemplateLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        TemplateLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Template) {
                Template tpl = (Template)element;
                if (columnIndex == 0) {
                    return tpl.getName();
                }
                if (columnIndex == 1) {
                    return tpl.getDescription();
                }
            }
            return null;
        }
    }
}

