/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.pkg.wizard;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.pkg.wizard.AuroraPkgWizardPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import uncertain.composite.CompositeMap;

public class CreateAuroraPkgWizard
extends Wizard {
    AuroraPkgWizardPage page;
    private IFolder initFolder;

    public CreateAuroraPkgWizard(IFolder folder) {
        this.initFolder = folder;
        this.setWindowTitle("Aurora Package \u5411\u5bfc");
        this.page = new AuroraPkgWizardPage();
        this.page.setInitFolder(folder);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String pkgName = this.page.getPkgName();
        IFolder pkgFolder = this.initFolder.getFolder(pkgName);
        IFolder configOFolder = pkgFolder.getFolder("config");
        for (String fn : this.page.getSelection()) {
            IFile file = configOFolder.getFile(String.valueOf(fn) + ".xml");
            CompositeMap map = this.createContent(fn);
            this.writeToFile(file, map);
        }
        return true;
    }

    protected CompositeMap createContent(String name) {
        CommentCompositeMap map = new CommentCompositeMap(name);
        if ("instance".equals(name)) {
            map.setName("instance-config");
            map.setNameSpace("u", "uncertain.pkg");
        } else if ("package".equals(name)) {
            map.put("name", this.page.getPkgName());
        }
        return map;
    }

    private void writeToFile(IFile file, CompositeMap map) {
        String str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + map.toXML();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes("UTF-8"));
            CreateFileOperation cfo = new CreateFileOperation(file, null, (InputStream)is, "create " + file.getName());
            cfo.execute(null, null);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

