/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.pkg.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuroraPkgWizardPage
extends WizardPage
implements ModifyListener {
    private Text text;
    private String[] baseFileNames = new String[]{"class-registry", "package", "instance"};
    private boolean[] selectionStats;
    private Button[] chkBtns;
    private IFolder folder;

    public AuroraPkgWizardPage() {
        super("wizardPage");
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        this.selectionStats = blArray;
        this.chkBtns = new Button[this.baseFileNames.length];
        this.setTitle("Create Aurora Package");
        this.setDescription("This wizard will help you create a simple aurora package.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("Package:");
        this.text = new Text(container, 2048);
        this.text.addModifyListener((ModifyListener)this);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpAutoCreate = new Group(container, 0);
        grpAutoCreate.setText("auto create");
        grpAutoCreate.setLayout((Layout)new GridLayout(1, false));
        grpAutoCreate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                Integer index = (Integer)b.getData("index");
                ((AuroraPkgWizardPage)AuroraPkgWizardPage.this).selectionStats[index.intValue()] = b.getSelection();
            }
        };
        int i = 0;
        while (i < this.chkBtns.length) {
            Button b = this.chkBtns[i] = new Button((Composite)grpAutoCreate, 32);
            b.setSelection(this.selectionStats[i]);
            b.setText(this.baseFileNames[i]);
            b.setData("index", (Object)i);
            b.addSelectionListener((SelectionListener)sa);
            ++i;
        }
    }

    public void modifyText(ModifyEvent e) {
        String pkgName = this.text.getText();
        this.validatePkgName(pkgName);
    }

    private void validatePkgName(String name) {
        String error = null;
        if (name.length() == 0) {
            error = "Please Input Package Name.";
        } else if (this.folder.findMember(name) != null) {
            error = "Package '" + name + "' already exisis.";
        } else if (!this.isLegal(name)) {
            error = "'" + name + "' is not valid.(a valid name like 'aa.bb')";
        }
        this.setErrorMessage(error);
        this.setPageComplete(error == null);
    }

    protected boolean isLegal(String str) {
        if (str.length() == 0) {
            return false;
        }
        int dotIdx = -1;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            int i = 1;
            while (i < str.length()) {
                if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                    if (str.charAt(i) == '.') {
                        dotIdx = i;
                    } else {
                        return false;
                    }
                }
                ++i;
            }
        }
        return dotIdx > 0 && dotIdx < str.length() - 1;
    }

    public void setInitFolder(IFolder folder) {
        this.folder = folder;
    }

    public String getPkgName() {
        return this.text.getText();
    }

    public ArrayList<String> getSelection() {
        ArrayList<String> als = new ArrayList<String>();
        int i = 0;
        while (i < this.baseFileNames.length) {
            if (this.selectionStats[i]) {
                als.add(this.baseFileNames[i]);
            }
            ++i;
        }
        return als;
    }
}

