/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.node.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.editor.PropertyViewer;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.ActionListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import uncertain.composite.CompositeMap;

public class AddPropertyAction
extends ActionListener {
    PropertyViewer viewer;

    public AddPropertyAction(PropertyViewer viewer, int actionStyle) {
        this.setActionStyle(actionStyle);
        this.viewer = viewer;
    }

    public void run() {
        this.showInputDialog();
    }

    public ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("add.icon"));
    }

    private void showInputDialog() {
        CompositeMap data = this.viewer.getInput();
        Shell shell = new Shell();
        shell.setSize(400, 200);
        Label propertyLabe = new Label((Composite)shell, 0);
        propertyLabe.setText(LocaleMessage.getString("property.name"));
        propertyLabe.setBounds(20, 20, 50, 30);
        Text propertyText = new Text((Composite)shell, 2048);
        propertyText.setBounds(80, 20, 300, 20);
        Label valueLabel = new Label((Composite)shell, 0);
        valueLabel.setText(LocaleMessage.getString("value"));
        valueLabel.setBounds(20, 50, 50, 30);
        Text valueText = new Text((Composite)shell, 2048);
        valueText.setBounds(80, 50, 300, 20);
        Button ok = new Button((Composite)shell, 8);
        ok.setText(LocaleMessage.getString("OK"));
        ok.setBounds(220, 120, 70, 25);
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText(LocaleMessage.getString("Cancel"));
        cancel.setBounds(300, 120, 70, 25);
        SelectionListener listener = this.getListener(data, shell, propertyText, valueText, ok, cancel);
        ok.addSelectionListener(listener);
        cancel.addSelectionListener(listener);
        shell.open();
    }

    private SelectionListener getListener(final CompositeMap data, final Shell shell, final Text propertyText, final Text valueText, final Button ok, final Button cancel) {
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Widget w = e.widget;
                if (w == ok) {
                    data.put((Object)propertyText.getText(), (Object)valueText.getText());
                    AddPropertyAction.this.viewer.refresh(true);
                    shell.dispose();
                } else if (w == cancel) {
                    shell.dispose();
                }
            }
        };
        return listener;
    }

    public Image getDefaultImage() {
        return ImagesUtils.getImage("add.gif");
    }
}

