/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.node.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.editor.core.IViewer;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.ActionListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;

public class AddElementAction
extends ActionListener {
    protected IViewer viewer;
    protected CompositeMap currentNode;
    protected QualifiedName childQN;
    private String text = null;

    public AddElementAction(IViewer viewer, CompositeMap currentNode, QualifiedName childQN, int actionStyle) {
        this.viewer = viewer;
        this.currentNode = currentNode;
        this.childQN = childQN;
        this.setActionStyle(actionStyle);
    }

    public AddElementAction(IViewer viewer, CompositeMap currentNode, QualifiedName childQN, String text, int actionStyle) {
        this.viewer = viewer;
        this.currentNode = currentNode;
        this.childQN = childQN;
        this.text = text;
        this.setActionStyle(actionStyle);
    }

    public void run() {
        CompositeMapUtil.addElement(this.currentNode, this.childQN);
        if (this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    public void handleEvent(Event event) {
        this.run();
    }

    public ImageDescriptor getDefaultImageDescriptor() {
        return AuroraPlugin.getImageDescriptor(LocaleMessage.getString("element.icon"));
    }

    public String getDefaultText() {
        if (this.text == null) {
            if (this.currentNode == null || this.childQN == null) {
                return "";
            }
            String prefix = CompositeMapUtil.getContextPrefix(this.currentNode, this.childQN);
            this.childQN.setPrefix(prefix);
            this.text = this.childQN.getFullName();
        }
        return this.text;
    }

    public Image getDefaultImage() {
        return ImagesUtils.getImage("element.gif");
    }
}

