/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.navigator.action;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.bm.BMUtil;
import aurora.ide.bm.editor.GridDialog;
import aurora.ide.celleditor.CellInfo;
import aurora.ide.celleditor.ComboxCellEditor;
import aurora.ide.editor.widgets.GridViewer;
import aurora.ide.editor.widgets.WizardPageRefreshable;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.helpers.SystemException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.ide.IDE;
import uncertain.composite.CompositeMap;

public class CreateBMByExtendAction
implements IObjectActionDelegate {
    ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            DialogUtil.showErrorMessageBox(this.selection + "is not a IStructuredSelection!");
            return;
        }
        IStructuredSelection structured = (IStructuredSelection)this.selection;
        Object firstElment = structured.getFirstElement();
        if (!(firstElment instanceof IResource)) {
            DialogUtil.showErrorMessageBox(firstElment + "is not a IResource!");
            return;
        }
        IResource resource = (IResource)firstElment;
        if (!resource.getName().toLowerCase().endsWith(".bm")) {
            DialogUtil.showErrorMessageBox(resource + "\u4e0d\u662fbm\u6587\u4ef6!");
            return;
        }
        CompositeMap bm = null;
        try {
            bm = AuroraResourceUtil.loadFromResource(resource);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        if (bm == null) {
            return;
        }
        CreateBMByExtendWizard wizard = new CreateBMByExtendWizard(this.selection);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public CompositeMap getSimpleFields(CompositeMap bm) {
        CompositeMap fields = bm.getChild("fields");
        CommentCompositeMap simplefiels = new CommentCompositeMap(fields.getPrefix(), fields.getNamespaceURI(), "fields");
        Iterator it = fields.getChildIterator();
        while (it.hasNext()) {
            CompositeMap field = (CompositeMap)it.next();
            CommentCompositeMap simplefiel = new CommentCompositeMap(field.getPrefix(), field.getNamespaceURI(), "field");
            simplefiel.put("name", field.getString((Object)"name"));
            simplefiels.addChild(simplefiel);
        }
        return simplefiels;
    }

    class CreateBMByExtendWizard
    extends Wizard {
        private ParentBMPage parentBMPage;
        private SelectFieldPage selectFieldPage;
        private FilterFieldPage filterFieldPage;
        private ISelection selection;

        public CreateBMByExtendWizard(ISelection selection) {
            this.selection = selection;
        }

        public void addPages() {
            this.parentBMPage = new ParentBMPage(this.selection);
            this.selectFieldPage = new SelectFieldPage(this);
            this.filterFieldPage = new FilterFieldPage(this);
            this.selectFieldPage.setPageComplete(false);
            this.addPage((IWizardPage)this.parentBMPage);
            this.addPage((IWizardPage)this.selectFieldPage);
            this.addPage((IWizardPage)this.filterFieldPage);
        }

        public IWizardPage getNextPage(IWizardPage page) {
            CompositeMap data;
            if (((Object)((Object)this.selectFieldPage)).equals(page) && ((data = this.selectFieldPage.getSelection()) == null || data.getChildsNotNull().size() < 1)) {
                this.selectFieldPage.setErrorMessage("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5");
                this.selectFieldPage.setPageComplete(false);
                return null;
            }
            IWizardPage nextPage = super.getNextPage(page);
            if (nextPage instanceof WizardPageRefreshable) {
                ((WizardPageRefreshable)nextPage).refreshPage();
            }
            return nextPage;
        }

        public boolean performFinish() {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException {
                    CreateBMByExtendWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            try {
                                try {
                                    CreateBMByExtendWizard.this.doFinish(monitor);
                                }
                                catch (CoreException e) {
                                    DialogUtil.logErrorException(e);
                                    monitor.done();
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
            };
            try {
                this.getContainer().run(true, false, op);
            }
            catch (InterruptedException e) {
                DialogUtil.logErrorException(e);
                return false;
            }
            catch (InvocationTargetException e) {
                DialogUtil.logErrorException(e);
                return false;
            }
            return true;
        }

        private void doFinish(IProgressMonitor monitor) throws CoreException {
            String fileName = this.parentBMPage.getFileName();
            if (fileName.indexOf(".") == -1) {
                fileName = String.valueOf(fileName) + ".bm";
            }
            monitor.beginTask("Creating " + fileName, 2);
            String containerName = this.parentBMPage.getContainerName();
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(containerName);
            if (!resource.exists() || !(resource instanceof IContainer)) {
                DialogUtil.showErrorMessageBox(String.valueOf(LocaleMessage.getString("container")) + " \"" + containerName + "\"" + LocaleMessage.getString("not.exist"));
                return;
            }
            IContainer container = (IContainer)resource;
            final IFile file = container.getFile((IPath)new Path(fileName));
            try {
                InputStream stream = this.createFileStream();
                if (file.exists()) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.create(stream, true, monitor);
                }
                stream.close();
            }
            catch (Throwable e) {
                DialogUtil.logErrorException(e);
            }
            monitor.worked(1);
            monitor.setTaskName("Opening file for editing...");
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        DialogUtil.logErrorException(e);
                    }
                }
            });
            monitor.worked(1);
        }

        private InputStream createFileStream() throws SystemException {
            CompositeMap descIdField;
            CompositeMap fields = this.selectFieldPage.getSelection();
            String prefix = fields.getPrefix();
            CommentCompositeMap model = new CommentCompositeMap(prefix, "http://www.aurora-framework.org/schema/bm", "model");
            model.put("alias", "t1");
            model.put("extendMode", "reference");
            model.put("extend", this.parentBMPage.getParentBMName());
            fields.setNameSpace(prefix, "http://www.aurora-framework.org/schema/bm");
            fields.setName("fields");
            model.addChild(fields);
            CompositeMap filterfields = this.filterFieldPage.getSelection();
            if (filterfields != null && filterfields.getChilds() != null) {
                filterfields.setNameSpace(prefix, "http://www.aurora-framework.org/schema/bm");
                filterfields.setName("query-fields");
                model.addChild(filterfields);
                Iterator it = filterfields.getChildIterator();
                while (it.hasNext()) {
                    CompositeMap filterfield = (CompositeMap)it.next();
                    filterfield.setName("query-field");
                    String type = filterfield.getString((Object)"type");
                    filterfield.remove((Object)"type");
                    if (fields.getChildByAttrib((Object)"name", (Object)filterfield.getString((Object)"name")) == null) {
                        CommentCompositeMap field = new CommentCompositeMap(prefix, "http://www.aurora-framework.org/schema/bm", "field");
                        field.put("name", filterfield.getString((Object)"name"));
                        fields.addChild((CompositeMap)field);
                    }
                    if ("=".equals(type)) {
                        filterfield.put((Object)"queryOperator", (Object)"=");
                    } else if ("description".equals(type)) {
                        String queryExpression = "(select 1 from fnd_descriptions fd where t1.description_id=fd.description_id and fd.description_text like ${@" + filterfield.getString((Object)"name") + "} and fd.language = ${/session/@lang})";
                        filterfield.put((Object)"queryExpression", (Object)queryExpression);
                    } else {
                        filterfield.put((Object)"queryOperator", (Object)"like");
                    }
                    filterfield.put((Object)"field", (Object)filterfield.getString((Object)"name"));
                    filterfield.remove((Object)"name");
                }
            }
            if ((descIdField = fields.getChildByAttrib((Object)"name", (Object)"description_id")) != null) {
                CommentCompositeMap features = new CommentCompositeMap("bm", "http://www.aurora-framework.org/schema/bm", "features");
                CommentCompositeMap multiLanguage = new CommentCompositeMap("f", "aurora.database.features", "multi-language-storage");
                features.addChild(multiLanguage);
                model.addChild(features);
            }
            String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + AuroraResourceUtil.LineSeparator + AuroraResourceUtil.getSign() + CommentXMLOutputter.defaultInstance().toXML((CompositeMap)model, true);
            try {
                return new ByteArrayInputStream(contents.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SystemException(e);
            }
        }

        public IResource getParentBM() throws ApplicationException {
            return this.parentBMPage.getParentBM();
        }

        public void createPageControls(Composite pageContainer) {
        }
    }

    class FilterFieldPage
    extends WizardPageRefreshable {
        private GridViewer grid;
        private CreateBMByExtendWizard wizard;

        protected FilterFieldPage(CreateBMByExtendWizard wizard) {
            super("wizardPage");
            this.setTitle("\u521b\u5efaBM\u5411\u5bfc");
            this.setDescription("\u9009\u62e9\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6\u7684\u5b57\u6bb5");
            this.wizard = wizard;
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout());
            String[] columnProperties = new String[]{"name", "type"};
            String[] columnTitles = new String[]{"\u5b57\u6bb5\u540d", "\u8fc7\u6ee4\u64cd\u4f5c"};
            this.grid = new GridViewer(columnProperties, 322);
            this.grid.setColumnTitles(columnTitles);
            try {
                this.grid.createViewer(content);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            CellEditor[] celleditors = new CellEditor[columnProperties.length];
            CellInfo cellProperties = new CellInfo(this.grid, "type", false);
            cellProperties.setItems(new String[]{"=", "like", "description"});
            ComboxCellEditor cellEditor = new ComboxCellEditor(cellProperties);
            cellEditor.init();
            celleditors[columnProperties.length - 1] = cellEditor.getCellEditor();
            this.grid.addEditor("type", cellEditor);
            this.grid.setCellEditors(celleditors);
            try {
                IResource resource = this.wizard.getParentBM();
                CompositeMap data = AuroraResourceUtil.loadFromResource(resource);
                if (data == null) {
                    DialogUtil.showErrorMessageBox("\u6b64BM\u4e0d\u5b58\u5728!");
                }
                this.grid.setData(CreateBMByExtendAction.this.getSimpleFields(data));
            }
            catch (ApplicationException e) {
                DialogUtil.logErrorException(e);
            }
            this.setControl((Control)content);
        }

        public void refreshPage() {
            if (this.getControl() == null) {
                return;
            }
            try {
                IResource resource = this.wizard.getParentBM();
                CompositeMap data = AuroraResourceUtil.loadFromResource(resource);
                if (data == null) {
                    DialogUtil.showErrorMessageBox("\u6b64BM\u4e0d\u5b58\u5728!");
                }
                CompositeMap field = data.getChild("fields");
                this.grid.setData(CreateBMByExtendAction.this.getSimpleFields(field));
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            super.refreshPage();
        }

        public CompositeMap getSelection() {
            if (this.grid == null) {
                return null;
            }
            return this.grid.getSelection();
        }

        public void checkPageValues() {
        }

        public void initPageValues() {
        }
    }

    class ParentBMPage
    extends WizardPageRefreshable {
        public static final String FILE_EXT = "bm";
        private ISelection selection;
        private Text containerText;
        private Text parentBMText;
        private Text fileText;

        public ParentBMPage(ISelection selection) {
            super("wizardPage");
            this.setTitle("\u521b\u5efaBM\u5411\u5bfc");
            this.setDescription("\u9009\u62e9\u7236\u76ee\u5f55\u548c\u7236BM");
            this.selection = selection;
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            container.setLayout((Layout)layout);
            layout.numColumns = 3;
            layout.verticalSpacing = 9;
            Label label = new Label(container, 0);
            label.setText(LocaleMessage.getString("container"));
            this.containerText = new Text(container, 2052);
            GridData gd = new GridData(768);
            this.containerText.setLayoutData((Object)gd);
            this.containerText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParentBMPage.this.checkPageValues();
                }
            });
            Button button = new Button(container, 8);
            button.setText(LocaleMessage.getString("openBrowse"));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.handleBrowse();
                }

                private void handleBrowse() {
                    Object[] result;
                    ContainerSelectionDialog dialog = new ContainerSelectionDialog(ParentBMPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LocaleMessage.getString("select.new.file.container"));
                    if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
                        ParentBMPage.this.containerText.setText(((Path)result[0]).toString());
                    }
                }
            });
            label = new Label(container, 0);
            label.setText("\u9009\u62e9\u7236BM");
            this.parentBMText = new Text(container, 0);
            this.parentBMText.setLayoutData((Object)new GridData(768));
            this.parentBMText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParentBMPage.this.checkPageValues();
                }
            });
            Button uncertainProDirButton = new Button(container, 8);
            uncertainProDirButton.setText(LocaleMessage.getString("openBrowse"));
            uncertainProDirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        this.pickParentBM();
                    }
                    catch (Exception e) {
                        DialogUtil.showExceptionMessageBox(e);
                    }
                }

                private void pickParentBM() throws ApplicationException {
                    String value;
                    IProject project = ProjectUtil.getIProjectFromSelection();
                    List bmList = ProjectUtil.getBMSFromProject(project);
                    CommentCompositeMap bms = new CommentCompositeMap("bms");
                    String[] columnProperties = new String[]{"name", "fullpath"};
                    for (IResource bmFile : bmList) {
                        CommentCompositeMap child = new CommentCompositeMap("record");
                        child.put("name", bmFile.getName());
                        child.put("fullpath", AuroraResourceUtil.getRegisterPath((IFile)bmFile));
                        bms.addChild(child);
                    }
                    GridViewer grid = new GridViewer(null, 48);
                    grid.setData(bms);
                    grid.setFilterColumn("name");
                    grid.setColumnNames(columnProperties);
                    GridDialog dialog = new GridDialog(new Shell(), grid);
                    if (dialog.open() == 0 && (value = dialog.getSelected().getString((Object)"fullpath")) != null) {
                        ParentBMPage.this.parentBMText.setText(value);
                    }
                }
            });
            label = new Label(container, 0);
            label.setText(LocaleMessage.getString("file.name"));
            this.fileText = new Text(container, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.fileText.setLayoutData((Object)gd);
            this.fileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParentBMPage.this.checkPageValues();
                }
            });
            this.initPageValues();
            this.checkPageValues();
            this.setControl((Control)container);
        }

        public void initPageValues() {
            if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)this.selection;
                if (ssel.size() > 1) {
                    return;
                }
                Object obj = ssel.getFirstElement();
                if (obj instanceof IResource) {
                    String registerPath;
                    IResource bm = (IResource)obj;
                    IContainer container = bm.getParent();
                    this.containerText.setText(container.getFullPath().toOSString());
                    try {
                        registerPath = AuroraResourceUtil.getRegisterPath((IFile)bm);
                    }
                    catch (ApplicationException e) {
                        DialogUtil.showExceptionMessageBox(e);
                        return;
                    }
                    this.parentBMText.setText(registerPath);
                }
            }
        }

        public void checkPageValues() {
            String ext;
            IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(this.containerText.getText());
            String containerPath = this.containerText.getText();
            if (containerPath == null || "".equals(containerPath)) {
                this.updatePageStatus(LocaleMessage.getString("file.container.must.be.specified"));
                return;
            }
            if (container == null || (container.getType() & 6) == 0) {
                this.updatePageStatus(LocaleMessage.getString("file.container.must.exist"));
                return;
            }
            String parentBMPath = this.parentBMText.getText();
            if (parentBMPath == null || "".equals(parentBMPath)) {
                this.updatePageStatus("\u5fc5\u987b\u6307\u5b9a\u7236BM!");
                return;
            }
            IResource bmFile = null;
            try {
                bmFile = BMUtil.getBMResourceFromClassPath(parentBMPath);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            if (bmFile == null) {
                this.updatePageStatus("\u6b64BM\u6587\u4ef6\u4e0d\u5b58\u5728!");
                return;
            }
            String fileName = this.getFileName();
            if (fileName != null && !fileName.equals("") && ((IContainer)container).getFile((IPath)new Path(fileName)).exists()) {
                this.updatePageStatus(LocaleMessage.getString("filename.used"));
                return;
            }
            if (!container.isAccessible()) {
                this.updatePageStatus(LocaleMessage.getString("project.must.be.writable"));
                return;
            }
            if (fileName.length() == 0) {
                this.updatePageStatus(LocaleMessage.getString("file.name.must.be.specified"));
                return;
            }
            if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
                this.updatePageStatus(LocaleMessage.getString("file.name.must.be.valid"));
                return;
            }
            int dotLoc = fileName.lastIndexOf(46);
            if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(FILE_EXT)) {
                this.updatePageStatus(LocaleMessage.getString("file.extension.must.be.bm"));
                return;
            }
            this.updatePageStatus(null);
        }

        public IResource getParentBM() throws ApplicationException {
            String parentBMPath = this.parentBMText.getText();
            return BMUtil.getBMResourceFromClassPath(parentBMPath);
        }

        public String getParentBMName() {
            return this.parentBMText.getText();
        }

        public String getFileName() {
            String fileName = this.fileText.getText();
            if (fileName.indexOf(".") == -1) {
                fileName = String.valueOf(fileName) + "." + FILE_EXT;
            }
            return fileName;
        }

        public String getContainerName() {
            return this.containerText.getText();
        }
    }

    class SelectFieldPage
    extends WizardPageRefreshable {
        private GridViewer grid;
        private CreateBMByExtendWizard wizard;

        protected SelectFieldPage(CreateBMByExtendWizard wizard) {
            super("wizardPage");
            this.setTitle("\u521b\u5efaBM\u5411\u5bfc");
            this.setDescription("\u9009\u62e9\u67e5\u8be2\u5b57\u6bb5");
            this.wizard = wizard;
        }

        public void createControl(Composite parent) {
            Composite content = new Composite(parent, 0);
            content.setLayout((Layout)new GridLayout());
            String[] columnProperties = new String[]{"name"};
            this.grid = new GridViewer(columnProperties, 66);
            try {
                this.grid.createViewer(content);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            try {
                IResource resource = this.wizard.getParentBM();
                CompositeMap data = AuroraResourceUtil.loadFromResource(resource);
                if (data == null) {
                    DialogUtil.showErrorMessageBox("\u6b64BM\u4e0d\u5b58\u5728!");
                }
                this.grid.setData(CreateBMByExtendAction.this.getSimpleFields(data));
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            this.setPageComplete(true);
            this.setControl((Control)content);
        }

        public void refreshPage() {
            if (!this.isInit()) {
                return;
            }
            try {
                IResource resource = this.wizard.getParentBM();
                CompositeMap data = AuroraResourceUtil.loadFromResource(resource);
                if (data == null) {
                    DialogUtil.showErrorMessageBox("\u6b64BM\u4e0d\u5b58\u5728!");
                    return;
                }
                CompositeMap field = data.getChild("fields");
                this.grid.setData(field);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            super.refreshPage();
        }

        public CompositeMap getSelection() {
            return this.grid.getSelection();
        }

        public void checkPageValues() {
        }

        public void initPageValues() {
        }
    }
}

