/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.navigator;

import aurora.ide.AuroraProjectNature;
import aurora.ide.bm.BMUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.helpers.SystemException;
import aurora.ide.navigator.BMFile;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BMHierarchyCache {
    private Map projectBMFileMap = new HashMap();
    private static BMHierarchyCache instance;

    private BMHierarchyCache() {
    }

    public static synchronized BMHierarchyCache getInstance() {
        if (instance == null) {
            instance = new BMHierarchyCache();
        }
        return instance;
    }

    public void initCache(IProject project) throws ApplicationException {
        if (project == null) {
            throw new ApplicationException("paramter:project can not be null");
        }
        try {
            if (!AuroraProjectNature.hasAuroraNature(project)) {
                return;
            }
        }
        catch (CoreException e) {
            throw new SystemException(e);
        }
        String bmBaseDir = ProjectUtil.getBMHome(project);
        if (bmBaseDir == null) {
            throw new ApplicationException("\u8bf7\u68c0\u67e5BM\u76ee\u5f55\u8bbe\u7f6e\uff01");
        }
        IResource bmDir = ResourcesPlugin.getWorkspace().getRoot().findMember(bmBaseDir);
        if (bmDir == null) {
            throw new ApplicationException(String.valueOf(bmBaseDir) + "\u8d44\u6e90\u4e0d\u5b58\u5728");
        }
        if (!(bmDir instanceof IContainer)) {
            throw new ApplicationException(String.valueOf(bmBaseDir) + "\u4e0d\u662f\u76ee\u5f55");
        }
        IContainer bmContainer = (IContainer)bmDir;
        this.iteratorResource(bmContainer);
    }

    private void iteratorResource(IContainer parent) throws ApplicationException {
        try {
            IResource[] members = parent.members();
            int i = 0;
            while (i < members.length) {
                IResource child = members[i];
                if (child.getName().toLowerCase().endsWith(".bm")) {
                    this.createThisBMFileHierachy(child);
                }
                if (child instanceof IContainer) {
                    this.iteratorResource((IContainer)child);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new SystemException(e);
        }
    }

    public BMFile createThisBMFileHierachy(IPath bmFile) throws ApplicationException {
        return this.createThisBMFileHierachy(ResourcesPlugin.getWorkspace().getRoot().findMember(bmFile));
    }

    public BMFile createThisBMFileHierachy(IResource bmFile) throws ApplicationException {
        IPath thisKey;
        if (bmFile == null) {
            return null;
        }
        Map ifileMap = this.getBMFileMapNotNull(bmFile.getProject());
        Object obj = ifileMap.get(thisKey = bmFile.getFullPath());
        if (obj != null) {
            return (BMFile)((Object)obj);
        }
        BMFile thisFile = BMFile.createBMFileFromResource(bmFile);
        if (thisFile == null) {
            return null;
        }
        ifileMap.put(thisKey, thisFile);
        if (thisFile.getParentBMPath() == null) {
            return thisFile;
        }
        IResource parent = ResourcesPlugin.getWorkspace().getRoot().findMember(thisFile.getParentBMPath());
        BMFile parentFile = this.createThisBMFileHierachy(parent);
        if (parentFile != null) {
            parentFile.addSubBMFile(thisFile);
        }
        return thisFile;
    }

    public void removeProject(IProject project) {
        this.projectBMFileMap.remove(project);
    }

    public Map getBMFileMapNotNull(IProject project) {
        Object obj = this.projectBMFileMap.get(project);
        if (obj == null) {
            obj = new HashMap();
        }
        this.projectBMFileMap.put(project, obj);
        return (Map)obj;
    }

    public boolean isCached(IProject project) {
        return this.projectBMFileMap.containsKey(project);
    }

    public void updateBMFile(IResource resource) throws ApplicationException {
        IPath thisKey;
        if (resource == null) {
            return;
        }
        Map ifileMap = this.getBMFileMapNotNull(resource.getProject());
        BMFile oldBMFile = (BMFile)((Object)ifileMap.get(thisKey = resource.getFullPath()));
        if (oldBMFile != null) {
            IResource parentBMFile = BMUtil.getBMResourceFromClassPath(resource.getProject(), BMUtil.getExtendValue(resource));
            if (oldBMFile.getParentBMPath() == null && parentBMFile == null) {
                return;
            }
            if (parentBMFile.getFullPath() != null && parentBMFile.equals((Object)oldBMFile.getParentBMPath())) {
                return;
            }
            this.removeBMFile((IResource)oldBMFile);
        }
        this.createThisBMFileHierachy(resource);
    }

    public void addBMFile(IResource resource) throws ApplicationException {
        if (resource == null) {
            return;
        }
        this.createThisBMFileHierachy(resource);
    }

    public void removeBMFile(IResource resource) {
        BMFile parentBM;
        IPath thisKey;
        if (resource == null) {
            return;
        }
        Map ifileMap = this.getBMFileMapNotNull(resource.getProject());
        BMFile oldBMFile = (BMFile)((Object)ifileMap.get(thisKey = resource.getFullPath()));
        if (oldBMFile == null) {
            return;
        }
        ifileMap.remove(oldBMFile.getPath());
        if (oldBMFile.getParentBMPath() != null && (parentBM = this.getBMFile(oldBMFile.getParentBMPath())) != null) {
            parentBM.removeSubBMFile(oldBMFile);
        }
    }

    public BMFile getBMFile(IPath path) {
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (resource == null) {
            return null;
        }
        Map ifileMap = this.getBMFileMapNotNull(resource.getProject());
        return (BMFile)((Object)ifileMap.get(resource.getFullPath()));
    }
}

