/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.navigator;

import aurora.ide.AuroraPlugin;
import aurora.ide.AuroraProjectNature;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.navigator.BMFile;
import aurora.ide.navigator.BMHierarchyCache;
import aurora.ide.navigator.BMHierarchyViewerTester;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class BMFileContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    private StructuredViewer viewer;
    private static final Object[] NO_CHILD = new Object[0];

    public BMFileContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            try {
                Object[] bmFiles = this.getBMFilesFromResources(((IContainer)parentElement).members());
                return bmFiles;
            }
            catch (CoreException e) {
                DialogUtil.logErrorException(e);
                return NO_CHILD;
            }
            catch (ApplicationException e) {
                DialogUtil.logErrorException(e);
                return NO_CHILD;
            }
        }
        BMFile bmLinkFile = null;
        try {
            bmLinkFile = this.getBMLinkFile(parentElement);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return NO_CHILD;
        }
        if (bmLinkFile == null) {
            return NO_CHILD;
        }
        return bmLinkFile.getSubBMFiles().toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof BMFile) {
            BMFile file = (BMFile)((Object)element);
            try {
                IPath parentPath = file.getParentBMPath();
                if (parentPath != null) {
                    return this.getBMLinkFile(parentPath);
                }
                return ResourcesPlugin.getWorkspace().getRoot().findMember(parentPath);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
                return null;
            }
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IContainer) {
            try {
                return ((IContainer)element).members().length > 0;
            }
            catch (CoreException e) {
                DialogUtil.logErrorException(e);
                return false;
            }
        }
        BMFile bmLinkFile = null;
        try {
            bmLinkFile = this.getBMLinkFile(element);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return false;
        }
        if (bmLinkFile == null) {
            return false;
        }
        return bmLinkFile.getSubBMFiles().size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IContainer) {
            try {
                return ((IContainer)inputElement).members();
            }
            catch (CoreException e) {
                DialogUtil.logErrorException(e);
                return NO_CHILD;
            }
        }
        BMFile bmLinkFile = null;
        try {
            bmLinkFile = this.getBMLinkFile(inputElement);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return null;
        }
        if (bmLinkFile == null) {
            return NO_CHILD;
        }
        return bmLinkFile.getSubBMFiles().toArray();
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        this.viewer = (StructuredViewer)aViewer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResourceDelta bms;
        block5: {
            IProject project = ProjectUtil.getIProjectFromSelection();
            if (project == null) {
                return false;
            }
            if (!AuroraProjectNature.hasAuroraNature(project)) {
                return false;
            }
            bms = delta.findMember((IPath)new Path(ProjectUtil.getBMHome(project)));
            if (bms != null) break block5;
            return false;
        }
        try {
            this.handleBMFileDelta(bms);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                BMFileContentProvider.this.viewer.refresh();
            }
        });
        return false;
    }

    private void handleBMFileDelta(IResourceDelta delta) {
        if (delta == null) {
            return;
        }
        IResourceDelta[] childs = delta.getAffectedChildren();
        if (childs == null || childs.length == 0) {
            IResource resource = delta.getResource();
            if (resource instanceof IFile && "bm".equalsIgnoreCase(resource.getFileExtension())) {
                try {
                    if (2 == delta.getKind()) {
                        BMHierarchyCache.getInstance().removeBMFile(delta.getResource());
                    } else if (1 == delta.getKind()) {
                        BMHierarchyCache.getInstance().addBMFile(delta.getResource());
                    } else if (4 == delta.getKind()) {
                        BMHierarchyCache.getInstance().updateBMFile(delta.getResource());
                    }
                }
                catch (ApplicationException e) {
                    DialogUtil.logErrorException(e);
                }
            }
            return;
        }
        int i = 0;
        while (i < childs.length) {
            this.handleBMFileDelta(childs[i]);
            ++i;
        }
    }

    private Object[] getBMFilesFromResources(IResource[] resources) throws ApplicationException {
        LinkedList<Object> fileList = new LinkedList<Object>();
        BMHierarchyViewerTester test = new BMHierarchyViewerTester();
        int i = 0;
        while (i < resources.length) {
            IResource child = resources[i];
            if (!test.test(child, null, null, null)) {
                fileList.add(resources[i]);
            } else {
                BMFile bmFile = BMFileContentProvider.searchBMLinkFile(child);
                if (bmFile != null) {
                    fileList.add((Object)bmFile);
                } else {
                    fileList.add(child);
                }
            }
            ++i;
        }
        return fileList.toArray();
    }

    private BMFile getBMLinkFile(Object file) throws ApplicationException {
        if (file instanceof IFile) {
            IFile resource = (IFile)file;
            return BMFileContentProvider.searchBMLinkFile((IResource)resource);
        }
        if (file instanceof BMFile) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(((BMFile)((Object)file)).getPath());
            return BMFileContentProvider.searchBMLinkFile(resource);
        }
        if (file instanceof IPath) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)file);
            return BMFileContentProvider.searchBMLinkFile(resource);
        }
        if (file instanceof IResource) {
            return BMFileContentProvider.searchBMLinkFile((IResource)file);
        }
        throw new ApplicationException("\u8bf7\u68c0\u67e5\u5bf9\u8c61\u662fIFile\u6216\u8005BMFile\u7c7b\u578b!");
    }

    public static BMFile searchBMLinkFile(final IResource resource) throws ApplicationException {
        Map ifileMap;
        Object obj;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (!BMHierarchyCache.getInstance().isCached(resource.getProject())) {
            try {
                AuroraPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            BMHierarchyCache.getInstance().initCache(resource.getProject());
                        }
                        catch (ApplicationException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException("", e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if ((obj = (ifileMap = BMHierarchyCache.getInstance().getBMFileMapNotNull(resource.getProject())).get(resource.getFullPath())) == null) {
            return null;
        }
        return (BMFile)((Object)obj);
    }
}

