/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.javascript.search;

import aurora.ide.javascript.Javascript4Rhino;
import aurora.ide.javascript.search.JavascriptSearchService;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AuroraMatch;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.MapFinderResult;
import aurora.ide.search.reference.NamedMapFinder;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.mozilla.javascript.ast.StringLiteral;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Javascript4RhinoSearchService
extends JavascriptSearchService {
    private List<LineElement> lines = new LinkedList<LineElement>();
    private List<IFile> sources;

    public void setSources(List<IFile> sources) {
        this.sources = sources;
    }

    @Override
    public List<IFile> getSources() {
        return this.sources == null ? (this.sources = new ArrayList<IFile>()) : this.sources;
    }

    @Override
    public void addSource(IFile source) {
        this.getSources().add(source);
    }

    @Override
    public CompositeMapIteator createIterationHandle(IFile file) {
        return new NamedMapFinder("script");
    }

    @Override
    public Collection<? extends AbstractMatch> buildMatchLines(IFile file, List<MapFinderResult> r, Object pattern) {
        return this.buildMatchLines(file, r);
    }

    private Collection<? extends AbstractMatch> buildMatchLines(IFile file, List<MapFinderResult> r) {
        ArrayList<Javascript4Rhino> js = new ArrayList<Javascript4Rhino>();
        for (MapFinderResult result : r) {
            CompositeMap map = result.getMap();
            if (!"script".equalsIgnoreCase(map.getName()) || map.getText() == null) continue;
            js.add(new Javascript4Rhino(file, map));
        }
        return this.buildMatchLines(file, js.toArray(new Javascript4Rhino[js.size()]));
    }

    private Collection<? extends AbstractMatch> buildMatchLines(IFile file, Javascript4Rhino[] js) {
        ArrayList<AbstractMatch> matchs = new ArrayList<AbstractMatch>();
        Javascript4Rhino[] javascript4RhinoArray = js;
        int n = js.length;
        int n2 = 0;
        while (n2 < n) {
            Javascript4Rhino j = javascript4RhinoArray[n2];
            matchs.addAll(this.buildMatchLines(file, j));
            ++n2;
        }
        return matchs;
    }

    private List<AbstractMatch> buildMatchLines(IFile file, Javascript4Rhino j) {
        ArrayList<AbstractMatch> matchs = new ArrayList<AbstractMatch>();
        List<StringLiteral> stringLiteralNodes = j.getStringLiteralNodes(null);
        for (StringLiteral sl : stringLiteralNodes) {
            String literalString = j.getLiteralValue(sl);
            String pattern = this.isMatch(file, literalString);
            if (pattern == null) continue;
            int mapStartLine = j.getMap().getLocation().getStartLine();
            int ln = sl.getLineno() + mapStartLine - 1;
            String content = "";
            IRegion lineInformation = null;
            IDocument document = null;
            ITypedRegion jsRegion = null;
            try {
                document = CacheManager.getDocument(file);
                jsRegion = this.findJavascriptPartitioning(document, j.getMap());
                if (jsRegion == null) continue;
                lineInformation = document.getLineInformation(ln - 1);
                content = document.get(lineInformation.getOffset(), lineInformation.getLength());
                LineElement l = this.getLineElement(file, ln, lineInformation.getOffset(), content);
                int valueOffset = jsRegion.getOffset() + sl.getAbsolutePosition() + "<![CDATA[".length() + 1 + literalString.indexOf(pattern);
                AuroraMatch match = new AuroraMatch(file, valueOffset, pattern.length(), l);
                matchs.add(match);
            }
            catch (CoreException e) {
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return matchs;
    }

    private ITypedRegion findJavascriptPartitioning(IDocument document, CompositeMap map) throws BadLocationException {
        int mapStartLine = map.getLocation().getStartLine();
        int mapEndLine = map.getLocation().getEndLine();
        ITypedRegion[] computePartitioning = document.computePartitioning(document.getLineOffset(mapStartLine - 1), document.getLineOffset(mapEndLine - 1) - document.getLineOffset(mapStartLine - 1));
        if (computePartitioning != null) {
            ITypedRegion[] iTypedRegionArray = computePartitioning;
            int n = computePartitioning.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion r = iTypedRegionArray[n2];
                if ("XML_CDATA".equals(r.getType())) {
                    return r;
                }
                ++n2;
            }
        }
        return null;
    }

    private String isMatch(IFile file, String subString) {
        IFile findScreenFile = Util.findScreenFile(file, subString);
        boolean isScreen = this.getSources().contains(findScreenFile);
        if (isScreen) {
            return (String)this.createPattern(null, findScreenFile);
        }
        for (IFile f : this.getSources()) {
            Object createPattern;
            boolean bmRefMatch;
            if (!"bm".equalsIgnoreCase(f.getFileExtension()) || !(bmRefMatch = Util.bmRefMatch(createPattern = this.createPattern(null, f), subString))) continue;
            return createPattern.toString();
        }
        return null;
    }

    private LineElement getLineElement(IFile file, int ln, int offset, String content) {
        for (LineElement l : this.lines) {
            if (!file.equals((Object)l.getParent()) || l.getLine() != ln) continue;
            return l;
        }
        LineElement le = new LineElement((IResource)file, ln, offset, content);
        this.lines.add(le);
        return le;
    }

    protected Object createPattern(IResource scope, Object source) {
        if (source instanceof IFile) {
            IFile file = (IFile)source;
            String fileExtension = file.getFileExtension();
            if ("bm".equalsIgnoreCase(fileExtension)) {
                return this.getBMPKG(scope, file);
            }
            if ("screen".equalsIgnoreCase(fileExtension) || "svc".equalsIgnoreCase(fileExtension)) {
                return this.getScreenPKG(scope, file);
            }
        }
        return null;
    }

    private Object getScreenPKG(IResource scope, IFile file) {
        return file.getName();
    }

    private Object getBMPKG(IResource scope, IFile file) {
        return Util.toBMPKG(file);
    }
}

