/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.javascript;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.search.core.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.StringLiteral;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Javascript4Rhino {
    private String source;
    private AstRoot cu;
    private CompositeMap map;
    private IFile file;

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = Util.convertJS(source);
    }

    public String convertJS(String source) {
        Document document = new Document(source);
        XMLTagScanner scanner = Util.getXMLTagScanner();
        StringBuilder sb = new StringBuilder();
        try {
            IToken token = null;
            scanner.setRange((IDocument)document, 0, document.getLength());
            while ((token = scanner.nextToken()) != Token.EOF) {
                TextAttribute text;
                int tokenOffset = scanner.getTokenOffset();
                int tokenLength = scanner.getTokenLength();
                String string = document.get(tokenOffset, tokenLength);
                if (token.getData() instanceof TextAttribute && !(text = (TextAttribute)token.getData()).getForeground().getRGB().equals((Object)IColorConstants.STRING)) {
                    sb.append(Util.convertJS(string));
                    continue;
                }
                sb.append(string);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public CompositeMap getMap() {
        return this.map;
    }

    public void setMap(CompositeMap map) {
        this.map = map;
    }

    public Javascript4Rhino(IFile file, CompositeMap map) {
        this.file = file;
        this.map = map;
        this.setSource(map.getText());
    }

    public AstRoot createAST(IProgressMonitor monitor) {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setReservedKeywordAsIdentifier(true);
        Parser p = new Parser(compilerEnvirons);
        try {
            AstRoot parse = p.parse(this.source == null ? "" : this.source, "Aurora", 1);
            return parse;
        }
        catch (Exception e) {
            DialogUtil.logErrorException(e);
            return null;
        }
    }

    public List<StringLiteral> getStringLiteralNodes(IProgressMonitor monitor) {
        final ArrayList<StringLiteral> nodes = new ArrayList<StringLiteral>();
        AstRoot cu = this.getJavaScriptUnit(monitor);
        if (cu == null) {
            return nodes;
        }
        cu.visitAll(new NodeVisitor(){

            public boolean visit(AstNode node) {
                if (node instanceof StringLiteral) {
                    nodes.add((StringLiteral)node);
                }
                return true;
            }
        });
        return nodes;
    }

    public AstRoot getJavaScriptUnit(IProgressMonitor monitor) {
        if (this.cu == null) {
            try {
                this.cu = this.createAST(monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.cu;
    }

    public String getLiteralValue(StringLiteral sl) {
        return sl.getValue();
    }
}

