/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.helpers.StatusDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class StatusUtil {
    static String defaultPluginId = "aurora.ide";

    public static IStatus createStatus(Throwable thr, String pluginID) {
        return new Status(4, StatusUtil.getPluginID(pluginID), thr.getLocalizedMessage(), thr);
    }

    static String getPluginID(String id) {
        if (id == null) {
            return defaultPluginId;
        }
        return id;
    }

    public static void showStatusDialog(final Shell shell, final String title, final String shortDesc, boolean showInCurrentThread, final IStatus status) {
        if (showInCurrentThread) {
            StatusDialog.openError(shell, title, shortDesc, status);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    StatusDialog.openError(shell, title, shortDesc, status);
                }
            });
        }
    }

    public static void showExceptionDialog(Shell shell, String title, String shortDesc, boolean showInCurrentThread, Throwable thr) {
        IStatus detail = StatusUtil.createStatus(thr, null);
        StatusUtil.showStatusDialog(shell, title, shortDesc, showInCurrentThread, detail);
    }

    public static MultiStatus createMultiStatus(String pluginID, String msg, Throwable thr, IStatus[] status) {
        return new MultiStatus(StatusUtil.getPluginID(pluginID), 4, status, msg, thr);
    }
}

