/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StatusDialog
extends IconAndMessageDialog {
    public static boolean AUTOMATED_MODE = false;
    private Button detailsButton;
    private String title;
    private Text text;
    private boolean textCreated = false;
    private int displayMask = 65535;
    private IStatus status;
    private Clipboard clipboard;
    private boolean shouldIncludeTopLevelErrorInDetails = false;

    public StatusDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
        super(parentShell);
        this.title = dialogTitle == null ? JFaceResources.getString((String)"Problem_Occurred") : dialogTitle;
        this.message = message == null ? status.getMessage() : JFaceResources.format((String)"Reason", (Object[])new Object[]{message, status.getMessage()});
        this.status = status;
        this.displayMask = displayMask;
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createDetailsButton(parent);
    }

    private void createSupportArea(Composite parent) {
        ErrorSupportProvider provider = Policy.getErrorSupportProvider();
        if (provider == null) {
            return;
        }
        if (!provider.validFor(this.status)) {
            return;
        }
        Composite supportArea = new Composite(parent, 0);
        provider.createSupportArea(supportArea, this.status);
        GridData supportData = new GridData(4, 4, true, true);
        supportData.verticalSpan = 3;
        supportArea.setLayoutData((Object)supportData);
        if (supportArea.getLayout() == null) {
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            supportArea.setLayout((Layout)layout);
        }
    }

    protected void createDetailsButton(Composite parent) {
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createMessageArea(composite);
        this.createSupportArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = false;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createDialogAndButtonArea(Composite parent) {
        Composite dialogComposite;
        super.createDialogAndButtonArea(parent);
        if (this.dialogArea instanceof Composite && (dialogComposite = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(dialogComposite, 0);
        }
    }

    protected Image getImage() {
        if (this.status != null) {
            if (this.status.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.status.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected Text createDropDownText(Composite parent) {
        this.text = new Text(parent, 2818);
        this.populateText(this.text);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.horizontalSpan = 2;
        this.text.setLayoutData((Object)data);
        this.text.setFont(parent.getFont());
        this.textCreated = true;
        return this.text;
    }

    public int open() {
        if (!AUTOMATED_MODE && StatusDialog.shouldDisplay(this.status, this.displayMask)) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    public static int openError(Shell parent, String dialogTitle, String message, IStatus status) {
        return StatusDialog.openError(parent, dialogTitle, message, status, 7);
    }

    public static int openError(Shell parentShell, String title, String message, IStatus status, int displayMask) {
        StatusDialog dialog = new StatusDialog(parentShell, title, message, status, displayMask);
        return dialog.open();
    }

    private void populateText(Text textToPopulate) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable thr = this.status.getException();
        if (thr != null) {
            thr.printStackTrace(pw);
        }
        textToPopulate.setText(sw.toString());
    }

    private boolean textContentExists() {
        return this.textContentExists(this.status, this.shouldIncludeTopLevelErrorInDetails);
    }

    private boolean textContentExists(IStatus buildingStatus, boolean includeStatus) {
        if (!buildingStatus.matches(this.displayMask)) {
            return false;
        }
        Throwable t = buildingStatus.getException();
        boolean isCoreException = t instanceof CoreException;
        if (includeStatus) {
            return true;
        }
        if (!isCoreException && t != null) {
            return true;
        }
        boolean result = false;
        if (isCoreException) {
            CoreException ce = (CoreException)t;
            IStatus eStatus = ce.getStatus();
            if (this.message == null || this.message.indexOf(eStatus.getMessage()) == -1) {
                result |= this.textContentExists(eStatus, true);
            }
        }
        IStatus[] children = buildingStatus.getChildren();
        int i = 0;
        while (i < children.length) {
            result |= this.textContentExists(children[i], true);
            ++i;
        }
        return result;
    }

    protected static boolean shouldDisplay(IStatus status, int mask) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status.matches(mask);
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].matches(mask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.textCreated) {
            this.text.dispose();
            this.textCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.text = this.createDropDownText((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            this.getContents().getShell().layout();
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.textCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.textContentExists();
    }

    protected final void setStatus(IStatus status) {
        if (this.status != status) {
            this.status = status;
        }
        this.shouldIncludeTopLevelErrorInDetails = true;
        if (this.textCreated) {
            this.repopulateText();
        }
    }

    private void repopulateText() {
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText("");
            this.populateText(this.text);
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

