/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.api.composite.map.Comment;
import aurora.ide.api.composite.map.CommentCompositeLoader;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.api.composite.map.CommentReader;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.builder.BuildContext;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapLocatorParser;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.helpers.LogUtil;
import aurora.ide.helpers.SystemException;
import aurora.ide.search.cache.CacheManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.QualifiedName;
import uncertain.schema.Array;
import uncertain.schema.Attribute;
import uncertain.schema.ComplexType;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.Namespace;
import uncertain.schema.Schema;
import uncertain.schema.SchemaManager;

public class CompositeMapUtil {
    private CompositeMapUtil instance;

    private CompositeMapUtil() {
    }

    public CompositeMapUtil getInstance() {
        if (this.instance != null) {
            return this.instance;
        }
        this.instance = new CompositeMapUtil();
        return this.instance;
    }

    public static String getContextFullName(CompositeMap context, QualifiedName qn) {
        String text = null;
        String prefix = CompositeMapUtil.getContextPrefix(context, qn);
        String localName = qn.getLocalName();
        text = prefix != null ? String.valueOf(prefix) + ":" + localName : localName;
        return text;
    }

    public static String getContextPrefix(CompositeMap context, QualifiedName qn) {
        if (qn == null) {
            return null;
        }
        String prefix = CompositeMapUtil.getContextPrefix(context, qn.getNameSpace());
        if (prefix == null) {
            prefix = qn.getPrefix();
        }
        return prefix;
    }

    public static String getContextPrefix(CompositeMap context, String uri) {
        if (uri == null || context == null) {
            return null;
        }
        Map prefix_mapping = CompositeUtil.getPrefixMapping((CompositeMap)context);
        Object uri_ot = prefix_mapping.get(uri);
        if (uri_ot != null) {
            return (String)uri_ot;
        }
        return null;
    }

    public static CompositeMap addElement(CompositeMap parent, QualifiedName childQN) {
        if (parent == null || childQN == null) {
            return null;
        }
        String prefix = CompositeMapUtil.getContextPrefix(parent, childQN);
        CommentCompositeMap child = new CommentCompositeMap(prefix, childQN.getNameSpace(), childQN.getLocalName());
        parent.addChild((CompositeMap)child);
        CompositeMapUtil.addArrayNode(parent);
        return child;
    }

    public static boolean addElement(CompositeMap node, CompositeMap childNode) {
        if (node == null || childNode == null) {
            return false;
        }
        node.addChild(childNode);
        CompositeMapUtil.addArrayNode(node);
        return true;
    }

    public static void addArrayNode(CompositeMap parent) {
        Element element = CompositeMapUtil.getElement(parent);
        if (element != null && element.isArray()) {
            QualifiedName qName = parent.getQName();
            if (CompositeUtil.findChild((CompositeMap)parent.getParent(), (QualifiedName)qName) == null) {
                parent.getParent().addChild(parent);
            }
        }
    }

    public static void addElementArray(CompositeMap parentCM) {
        List arrays;
        Element element = CompositeMapUtil.getElement(parentCM);
        if (element != null && (arrays = element.getAllArrays()) != null) {
            for (Array array : arrays) {
                String name = array.getLocalName();
                CommentCompositeMap newCM = new CommentCompositeMap(parentCM.getPrefix(), parentCM.getNamespaceURI(), name);
                parentCM.addChild((CompositeMap)newCM);
            }
        }
    }

    public static List getAvailableChildElements(CompositeMap parent) {
        Element element = CompositeMapUtil.getElement(parent);
        if (element == null) {
            return null;
        }
        List<Element> childElements = new LinkedList();
        if (element.isArray()) {
            IType type = element.getElementType();
            if (type instanceof Element) {
                Element arrayType = LoadSchemaManager.getSchemaManager().getElement(type.getQName());
                childElements.add(arrayType);
            } else if (type instanceof ComplexType) {
                childElements.addAll(LoadSchemaManager.getSchemaManager().getElementsOfType(type));
            }
        } else {
            childElements = CompositeMapUtil.getChildElements(parent);
        }
        if (childElements != null) {
            Collections.sort(childElements);
        }
        return childElements;
    }

    private static List getChildElements(CompositeMap parent) {
        Element element = CompositeMapUtil.getElement(parent);
        Set schemaChilds = CompositeMapUtil.getSchemaChilds(element, LoadSchemaManager.getSchemaManager());
        ArrayList<Element> availableChilds = new ArrayList<Element>();
        if (schemaChilds != null) {
            for (Object object : schemaChilds) {
                if (!(object instanceof Element)) continue;
                Element ele = (Element)object;
                QualifiedName childQN = ele.getQName();
                if (ele.getMaxOccurs() == null) {
                    availableChilds.add(ele);
                    continue;
                }
                int maxOccurs = Integer.valueOf(ele.getMaxOccurs());
                int nowOccurs = CompositeMapUtil.getCountOfChildElement(parent, childQN);
                if (nowOccurs >= maxOccurs) continue;
                availableChilds.add(ele);
            }
        }
        return availableChilds;
    }

    public static Set getSchemaChilds(Element element, ISchemaManager manager) {
        HashSet<Element> childs = new HashSet<Element>();
        Set childElements = element.getChilds();
        if (childElements == null) {
            return childs;
        }
        Iterator cit = childElements.iterator();
        while (cit != null && cit.hasNext()) {
            Object node = cit.next();
            if (!(node instanceof ComplexType)) continue;
            ComplexType context = (ComplexType)node;
            ComplexType original = manager.getComplexType(context.getQName());
            if (original instanceof Element) {
                Element new_name = (Element)context;
                childs.add(new_name);
                continue;
            }
            childs.addAll(manager.getElementsOfType((IType)original));
        }
        List complexTypes = element.getAllExtendedTypes();
        if (complexTypes == null) {
            return childs;
        }
        Iterator cit2 = complexTypes.iterator();
        while (cit2 != null && cit2.hasNext()) {
            ComplexType ct = (ComplexType)cit2.next();
            if (!(ct instanceof Element)) continue;
            Element new_name = (Element)ct;
            childs.addAll(CompositeMapUtil.getSchemaChilds(new_name, manager));
        }
        return childs;
    }

    public static int getCountOfChildElement(CompositeMap parent, QualifiedName childQN) {
        List childs = parent.getChildsNotNull();
        int count = 0;
        for (CompositeMap node : childs) {
            if (!node.getQName().equals((Object)childQN)) continue;
            ++count;
        }
        return count;
    }

    public static boolean validNextNodeLegalWithAction(CompositeMap parent, CompositeMap child) {
        if (!CompositeMapUtil.validNextNodeLegal(parent, child)) {
            String warning = "";
            warning = parent == null ? LocaleMessage.getString("parent.element.is.null") : (child == null ? LocaleMessage.getString("child.element.is.null") : " " + parent.getQName().getLocalName() + " " + LocaleMessage.getString("undefined") + child.getQName().getLocalName() + " " + LocaleMessage.getString("child.element"));
            DialogUtil.showWarningMessageBox(warning);
            return false;
        }
        return true;
    }

    public static boolean validNextNodeLegal(CompositeMap parent, CompositeMap child) {
        if (parent == null || child == null) {
            return false;
        }
        Element parentElement = CompositeMapUtil.getElement(parent);
        return CompositeMapUtil.validNextNodeLegal(parentElement, child.getQName());
    }

    public static boolean validNextNodeLegal(Element parent, QualifiedName childQN) {
        List arrays;
        QualifiedName array;
        if (parent == null || childQN == null) {
            return false;
        }
        if (parent.isArray() && childQN.equals((Object)(array = parent.getElementType().getQName()))) {
            return true;
        }
        List childElements = parent.getChildElements(LoadSchemaManager.getSchemaManager());
        if (childElements != null) {
            for (Object object : childElements) {
                Element ele;
                if (!(object instanceof Element) || !childQN.equals((Object)(ele = (Element)object).getQName())) continue;
                return true;
            }
        }
        if ((arrays = parent.getAllArrays()) != null) {
            for (Array array2 : arrays) {
                if (!childQN.equals((Object)array2.getQName())) continue;
                return true;
            }
        }
        return false;
    }

    public Set getMaxOcuss(Element element, SchemaManager manager) {
        Element new_name;
        ComplexType ct;
        HashSet<Element> allChildElements = new HashSet<Element>();
        Set childElements = element.getChilds();
        Iterator cit = childElements.iterator();
        while (cit != null && cit.hasNext()) {
            Object node = cit.next();
            if (!(node instanceof ComplexType)) continue;
            ct = (ComplexType)node;
            if (ct instanceof Element) {
                new_name = (Element)ct;
                allChildElements.add(new_name);
                continue;
            }
            allChildElements.addAll(manager.getElementsOfType((IType)ct));
        }
        List complexTypes = element.getAllExtendedTypes();
        if (complexTypes == null) {
            return allChildElements;
        }
        Iterator cit2 = complexTypes.iterator();
        while (cit2 != null && cit2.hasNext()) {
            ct = (ComplexType)cit2.next();
            if (!(ct instanceof Element)) continue;
            new_name = (Element)ct;
            allChildElements.addAll(this.getMaxOcuss(new_name, manager));
        }
        return allChildElements;
    }

    public static String getValueIgnoreCase(CompositeMap cMap, String name) {
        Set keySet = cMap.keySet();
        for (Object object : keySet) {
            if (!(object instanceof String) || !((String)object).equalsIgnoreCase(name)) continue;
            return cMap.getString(object);
        }
        return null;
    }

    public static String getValueIgnoreCase(Attribute a, CompositeMap cMap) {
        String name = a.getName();
        return CompositeMapUtil.getValueIgnoreCase(cMap, name);
    }

    public static String getValueIgnoreCase(Attribute a, BuildContext bc) {
        return CompositeMapUtil.getValueIgnoreCase(a, bc.map);
    }

    public static Namespace getQualifiedName(CompositeMap root, String prefix) {
        Map namespace_mapping = CompositeUtil.getPrefixMapping((CompositeMap)root);
        Schema schema = new Schema();
        Namespace[] ns = CompositeMapUtil.getNameSpaces(namespace_mapping);
        schema.addNameSpaces(ns);
        Namespace nameSpace = schema.getNamespace(prefix);
        return nameSpace;
    }

    private static Namespace[] getNameSpaces(Map namespaceToPrefix) {
        if (namespaceToPrefix == null) {
            return null;
        }
        Namespace[] namespaces = new Namespace[namespaceToPrefix.keySet().size()];
        Iterator elements = namespaceToPrefix.keySet().iterator();
        int i = 0;
        while (elements.hasNext()) {
            Object element = elements.next();
            Namespace namespace = new Namespace();
            namespace.setPrefix(namespaceToPrefix.get(element).toString());
            namespace.setUrl(element.toString());
            namespaces[i] = namespace;
        }
        return namespaces;
    }

    public static void collectAttribueValues(Set set, String attribueName, CompositeMap root) {
        List childList;
        String attribueValue = root.getString((Object)attribueName);
        if (attribueValue != null) {
            set.add(attribueValue);
        }
        if ((childList = root.getChilds()) != null) {
            for (CompositeMap child : childList) {
                CompositeMapUtil.collectAttribueValues(set, attribueName, child);
            }
        }
    }

    public static List getArrayAttrs(CompositeMap arrayData) throws ApplicationException {
        if (arrayData == null) {
            throw new ApplicationException("CompositeMap data can not be null!");
        }
        Element element = CompositeMapUtil.getElement(arrayData);
        if (element == null) {
            throw new ApplicationException("Can't get element schema from " + arrayData.toXML());
        }
        if (!(element instanceof Array)) {
            throw new ApplicationException("Type " + element.getQName() + " is not array");
        }
        Array array = (Array)element;
        IType type = array.getElementType();
        if (type == null) {
            throw new ApplicationException("Can't get array type from " + array.getQName());
        }
        if (!(type instanceof ComplexType)) {
            throw new ApplicationException("Type " + type.getQName() + " is not ComplexType");
        }
        ComplexType type_element = (ComplexType)type;
        List attrib_list = type_element.getAllAttributes();
        return attrib_list;
    }

    public static String[] getArrayAttrNames(CompositeMap arrayData) throws ApplicationException {
        List attrib_list = CompositeMapUtil.getArrayAttrs(arrayData);
        if (attrib_list == null) {
            return null;
        }
        String[] column_index = new String[attrib_list.size()];
        int id = 0;
        for (Attribute attrib : attrib_list) {
            column_index[id++] = attrib.getLocalName();
        }
        return column_index;
    }

    public static int locateNode(String content, CompositeMap node) throws ApplicationException {
        int line = -1;
        if (node == null || content == null) {
            return -1;
        }
        CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
        InputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(content.getBytes("UTF-8"));
                line = parser.LocateCompositeMapLine(is, node);
            }
            catch (UnsupportedEncodingException e) {
                throw new SystemException(e);
            }
            catch (SAXException e) {
                throw new ApplicationException("\u8bf7\u68c0\u67e5\u5185\u5bb9\u683c\u5f0f" + content + "\u662f\u5426\u6b63\u786e.", e);
            }
            catch (IOException e) {
                throw new ApplicationException("\u8bf7\u68c0\u67e5\u5185\u5bb9\u683c\u5f0f" + content + "\u662f\u5426\u6b63\u786e.", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    DialogUtil.logErrorException(e);
                }
            }
        }
        return line;
    }

    public static CompositeMap loaderFromString(String content) throws ApplicationException {
        if (content == null) {
            return null;
        }
        CompositeMap root = null;
        CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
        InputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(content.getBytes("UTF-8"));
                root = parser.parseStream(is);
            }
            catch (UnsupportedEncodingException e) {
                throw new SystemException(e);
            }
            catch (SAXException e) {
                throw new ApplicationException("\u8bf7\u68c0\u67e5\u5185\u5bb9\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
            }
            catch (IOException e) {
                throw new ApplicationException("\u8bf7\u68c0\u67e5\u5185\u5bb9\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    DialogUtil.logErrorException(e);
                }
            }
        }
        return root;
    }

    public static String getFullContent(CompositeMap data) {
        if (data == null) {
            return null;
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + CommentXMLOutputter.defaultInstance().toXML(data, true);
    }

    public static Element getElement(CompositeMap map) {
        ISchemaManager schemaManager = LoadSchemaManager.getSchemaManager();
        try {
            return schemaManager.getElement(map);
        }
        catch (IllegalArgumentException e) {
            LogUtil.getInstance().logError(e.getMessage(), e);
            return null;
        }
    }

    public static Comment getFileComment(IFile file) {
        try {
            CompositeMap hostMap = CacheManager.getCompositeMap(file);
            if (hostMap instanceof CommentCompositeMap) {
                String comment = ((CommentCompositeMap)hostMap).getComment();
                CommentReader cr = new CommentReader(comment);
                Comment read = cr.read();
                return read;
            }
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
            e.printStackTrace();
        }
        catch (ApplicationException e) {
            DialogUtil.logErrorException(e);
            e.printStackTrace();
        }
        return null;
    }

    public static CompositeMap loadFile(File file) {
        FileInputStream is = null;
        try {
            CompositeMap rootMap;
            is = new FileInputStream(file);
            CommentCompositeLoader parser = new CommentCompositeLoader();
            CompositeMap compositeMap = rootMap = parser.loadFromStream(is);
            return compositeMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static CompositeMap loadFile(IFile file) {
        InputStream is = null;
        try {
            CompositeMap rootMap;
            is = file.getContents(false);
            CommentCompositeLoader parser = new CommentCompositeLoader();
            CompositeMap compositeMap = rootMap = parser.loadFromStream(is);
            return compositeMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static CompositeMap loadFromStream(InputStream is) {
        try {
            CompositeMap rootMap;
            CommentCompositeLoader parser = new CommentCompositeLoader();
            CompositeMap compositeMap = rootMap = parser.loadFromStream(is);
            return compositeMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

