/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.api.composite.map.CommentCompositeMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import uncertain.composite.CompositeMap;
import uncertain.composite.NameProcessor;

public class CompositeMapLocatorParser
extends DefaultHandler
implements LexicalHandler {
    private final int lineToCompositeMap = 0;
    private final int compositeMapToLine = 1;
    private int function;
    private CompositeMap targetCompositeMap;
    private int line;
    private boolean serchfinished = false;
    public static final String INCLUDE_INSTRUCTION = "include";
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";
    public static final String KEY_HREF = "href";
    CompositeMap current_node = null;
    LinkedList parentNode_stack = new LinkedList();
    Map uri_mapping = new HashMap();
    Map saved_uri_mapping;
    Map namespace_mapping = new HashMap();
    NameProcessor name_processor;
    Locator locator;
    String comment;
    private HashMap compositeMapPositions;
    static SAXParserFactory parser_factory = SAXParserFactory.newInstance();

    static {
        try {
            parser_factory.setNamespaceAware(true);
            parser_factory.setValidating(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void push(CompositeMap node) {
        this.parentNode_stack.addFirst(node);
    }

    CompositeMap pop() {
        CompositeMap node = (CompositeMap)this.parentNode_stack.getFirst();
        this.parentNode_stack.removeFirst();
        return node;
    }

    void addAttribs(CompositeMap node, Attributes attribs) {
        int i = 0;
        while (i < attribs.getLength()) {
            String attrib_name = attribs.getQName(i);
            if (this.name_processor != null) {
                attrib_name = this.name_processor.getAttributeName(attrib_name);
            }
            node.put((Object)attrib_name, (Object)attribs.getValue(i));
            ++i;
        }
    }

    public void startDocument() {
        this.current_node = null;
        this.parentNode_stack.clear();
        this.uri_mapping.clear();
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        int lineNumber = this.locator.getLineNumber() - 1;
        if (this.name_processor != null) {
            localName = this.name_processor.getElementName(localName);
        }
        CommentCompositeMap node = new CommentCompositeMap((String)this.uri_mapping.get(namespaceURI), namespaceURI, localName);
        node.setStartPoint(this.locator.getLineNumber(), this.locator.getColumnNumber());
        this.addAttribs(node, atts);
        if (this.comment != null) {
            node.setComment(this.comment);
            this.comment = null;
        }
        if (!this.serchfinished && this.function == 0) {
            if (lineNumber == this.line) {
                this.targetCompositeMap = node;
                this.serchfinished = true;
            } else if (lineNumber > this.line) {
                this.targetCompositeMap = this.current_node;
                this.serchfinished = true;
            }
        }
        if (this.current_node != null) {
            this.push(this.current_node);
            this.current_node.addChild((CompositeMap)node);
        }
        this.current_node = node;
        if (this.function == 1) {
            this.compositeMapPositions.put(this.current_node, new Integer(lineNumber));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.comment != null) {
            ((CommentCompositeMap)this.current_node).setEndElementComment(this.comment);
            this.comment = null;
        }
        ((CommentCompositeMap)this.current_node).setEndPoint(this.locator.getLineNumber(), this.locator.getColumnNumber());
        int lineNumber = this.locator.getLineNumber() - 1;
        if (!this.serchfinished && this.function == 0 && lineNumber >= this.line) {
            this.targetCompositeMap = this.current_node;
            this.serchfinished = true;
        }
        if (this.parentNode_stack.size() > 0) {
            this.current_node = this.pop();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            return;
        }
        if (prefix.length() == 0) {
            return;
        }
        this.uri_mapping.put(uri, prefix);
        this.namespace_mapping.put(prefix, uri);
        if (this.saved_uri_mapping == null) {
            this.saved_uri_mapping = new HashMap();
        }
        this.saved_uri_mapping.put(uri, prefix);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.uri_mapping.remove(prefix);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (ch == null) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (this.current_node != null) {
            String t = this.current_node.getText();
            t = t != null ? String.valueOf(t) + new String(ch, start, length) : new String(ch, start, length);
            t = this.handleNewLine(t);
            this.current_node.setText(t);
        }
    }

    public CompositeMap getRoot() {
        return this.current_node;
    }

    public CompositeMap parseStream(InputStream stream) throws SAXException, IOException {
        SAXParser parser = null;
        try {
            parser = parser_factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("error when creating SAXParser", ex);
        }
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        parser.parse(stream, (DefaultHandler)this);
        CompositeMap root = this.getRoot();
        root.setNamespaceMapping(this.saved_uri_mapping);
        return root;
    }

    public int LocateCompositeMapLine(InputStream stream, CompositeMap targetCompositeMap) throws SAXException, IOException {
        this.function = 1;
        this.targetCompositeMap = targetCompositeMap;
        this.compositeMapPositions = new HashMap();
        this.parseStream(stream);
        Object lineOBject = this.getLineObject(this.compositeMapPositions, targetCompositeMap);
        if (lineOBject != null) {
            this.line = (Integer)lineOBject;
        }
        return this.line;
    }

    private Object getLineObject(HashMap map, CompositeMap object) {
        if (map == null || object == null) {
            return null;
        }
        Set enterSet = map.keySet();
        if (enterSet == null) {
            return null;
        }
        for (Object childObject : enterSet) {
            Object childValue = map.get(childObject);
            CompositeMap child = (CompositeMap)childObject;
            if (!object.equals((Object)child)) continue;
            return childValue;
        }
        return null;
    }

    public CompositeMap getCompositeMapFromLine(InputStream stream, int line) throws SAXException, IOException {
        this.function = 0;
        this.line = line;
        this.parseStream(stream);
        CommentCompositeMap root = new CommentCompositeMap("root");
        root.addChild(this.getRoot());
        return this.targetCompositeMap;
    }

    public void clear() {
        this.current_node = null;
        if (this.parentNode_stack != null) {
            this.parentNode_stack.clear();
        }
        if (this.uri_mapping != null) {
            this.uri_mapping.clear();
        }
        this.name_processor = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (ch == null) {
            return;
        }
        String separator = "-->";
        String now = new String(ch, start, length);
        this.comment = this.comment != null ? String.valueOf(this.comment) + separator + now : now;
    }

    private String handleNewLine(String src) {
        if (src == null) {
            return null;
        }
        String result = src.replaceAll("\r", "");
        result = result.replaceAll("\n", "\r\n");
        return result;
    }

    public void endCDATA() throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String arg0) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    public void startEntity(String arg0) throws SAXException {
    }

    public void setUri_mapping(Map uri_mapping) {
        this.uri_mapping = uri_mapping;
    }
}

