/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.fake.uncertain.engine;

import aurora.ide.fake.uncertain.engine.FakeUncertainEngine;
import aurora.ide.fake.uncertain.engine.InternalPackageManager;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.preferencepages.SxsdDirPreferencePage;
import java.io.IOException;
import uncertain.pkg.PackageManager;
import uncertain.schema.ISchemaManager;

public class InstanceFactory {
    private static PackageManager packageManager;

    public static PackageManager getPackageManager() {
        if (packageManager == null) {
            packageManager = InstanceFactory.createInternalPackageManager();
            InstanceFactory.refeshPreferenceSchemaSetting();
        }
        return packageManager;
    }

    private static InternalPackageManager createInternalPackageManager() {
        FakeUncertainEngine fakeUncertainEngine = new FakeUncertainEngine();
        return fakeUncertainEngine.getInternalPackageManager();
    }

    public static ISchemaManager getSchemaManager() {
        return InstanceFactory.getPackageManager().getSchemaManager();
    }

    public static void refeshPreferenceSchemaSetting() {
        String[] sxsdPaths = SxsdDirPreferencePage.getSxsdPaths();
        try {
            InstanceFactory.refeshPreferenceSchemaSetting(sxsdPaths);
        }
        catch (IOException e) {
            e.printStackTrace();
            DialogUtil.logErrorException(e);
        }
    }

    public static void refeshPreferenceSchemaSetting(String[] sxsdPaths) throws IOException {
        if (sxsdPaths != null) {
            int i = 0;
            while (i < sxsdPaths.length) {
                InstanceFactory.getPackageManager().loadPackgeDirectory(sxsdPaths[i]);
                ++i;
            }
        }
    }
}

