/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.component.wizard.ActionsFactory;
import aurora.ide.editor.AbstractCMViewer;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.node.action.ActionInfo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import uncertain.composite.CompositeMap;

public class ToolBarAddElementListener
implements Listener {
    private ToolBar toolBar;
    private Menu menu;
    private ToolItem item;
    private AbstractCMViewer viewer;

    public ToolBarAddElementListener(ToolBar toolBar, Menu menu, ToolItem item, AbstractCMViewer container) {
        this.toolBar = toolBar;
        this.menu = menu;
        this.item = item;
        this.viewer = container;
    }

    public void handleEvent(Event event) {
        if (event.detail == 4) {
            CompositeMap currentNode = this.viewer.getFocus();
            if (currentNode == null) {
                return;
            }
            MenuItem[] mi = this.menu.getItems();
            int i = 0;
            while (i < mi.length) {
                mi[i].dispose();
                ++i;
            }
            ActionInfo actionInfo = new ActionInfo(this.viewer, currentNode);
            try {
                ActionsFactory.getInstance().addActionsToMenu(this.menu, actionInfo);
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
            }
            Rectangle rect = this.item.getBounds();
            Point pt = new Point(rect.x, rect.y + rect.height);
            pt = this.toolBar.toDisplay(pt);
            this.menu.setLocation(pt.x, pt.y);
            this.menu.setVisible(true);
        }
    }
}

