/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.celleditor.CellEditorFactory;
import aurora.ide.celleditor.ICellEditor;
import aurora.ide.editor.AbstractCMViewer;
import aurora.ide.editor.core.ITableViewer;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.CompositeMapFilter;
import aurora.ide.editor.widgets.GridCellModifier;
import aurora.ide.editor.widgets.PlainCompositeMapCellModifier;
import aurora.ide.editor.widgets.PlainCompositeMapLabelProvider;
import aurora.ide.editor.widgets.PropertyGridContentProvider;
import aurora.ide.editor.widgets.PropertyGridLabelProvider;
import aurora.ide.editor.widgets.core.ICellModifierListener;
import aurora.ide.editor.widgets.core.IGridLabelProvider;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.AddElementAction;
import aurora.ide.node.action.RefreshAction;
import aurora.ide.node.action.RemoveElementAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Element;

public class GridViewer
extends AbstractCMViewer
implements ITableViewer {
    protected CompositeMap data;
    protected String[] columnTitles;
    protected String[] columnNames;
    protected CellEditor[] cellEditors;
    protected Composite container;
    protected ViewForm viewForm;
    protected TableViewer tableViewer;
    protected GridCellModifier cellModifiers;
    protected IGridLabelProvider labelProvider;
    protected ToolBarManager toolBarManager;
    protected int gridStyle;
    protected String filterColumn;
    protected Text filterText;
    private boolean isColumnPacked;
    protected IViewer parent;
    protected CompositeMap selection;
    public HashMap columnEditors = new HashMap();

    public GridViewer() {
    }

    public GridViewer(int gridStyle) {
        this.gridStyle = gridStyle;
    }

    public GridViewer(String[] columnNames, int gridStyle) {
        this.columnNames = columnNames;
        this.gridStyle = gridStyle;
    }

    public GridViewer(CompositeMap data, String[] columnNames, int gridStyle) {
        this.data = data;
        this.columnNames = columnNames;
        this.gridStyle = gridStyle;
    }

    public void addActions(IAction[] actions) {
        if (actions == null) {
            return;
        }
        int i = 0;
        while (i < actions.length) {
            this.toolBarManager.add((IContributionItem)this.createActionContributionItem(actions[i]));
            ++i;
        }
        this.toolBarManager.update(true);
    }

    public void addCellModifierListener(ICellModifierListener listener) {
        this.cellModifiers.addCellModifierListener(listener);
    }

    public void addEditor(String property, ICellEditor cellEditor) {
        this.columnEditors.put(property, cellEditor);
    }

    public void addFilter(ViewerFilter filter) {
        this.labelProvider.refresh();
        this.tableViewer.addFilter(filter);
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public CompositeMap beforeDispose() {
        CommentCompositeMap records = null;
        if ((this.gridStyle & 2) == 0) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            records = (CompositeMap)selection.getFirstElement();
            if (records == null) {
                return null;
            }
        } else {
            Object[] elements = this.getCheckedElements();
            records = new CommentCompositeMap("records");
            int j = 0;
            while (j < elements.length) {
                CompositeMap record = (CompositeMap)elements[j];
                records.addChild(record);
                ++j;
            }
        }
        return records;
    }

    public void setColumnTitles(String[] columnTitles) {
        this.columnTitles = columnTitles;
    }

    public String clearAll(boolean validation) {
        if (this.tableViewer.getTable() != null) {
            String errorMessage = this.clearEditors(validation);
            if (errorMessage != null) {
                return errorMessage;
            }
            this.columnNames = null;
            this.columnTitles = null;
            this.cellEditors = null;
            this.data = null;
            this.isColumnPacked = false;
            this.tableViewer.getTable().dispose();
            this.viewForm.dispose();
            this.container.dispose();
        }
        return null;
    }

    public String clearEditors(boolean validation) {
        ICellEditor ed;
        int i;
        Object[] editors = this.columnEditors.values().toArray();
        if (this.getInput() != null && this.getInput().getChildsNotNull().size() > 0) {
            i = 0;
            while (i < editors.length) {
                ed = (ICellEditor)editors[i];
                if (validation && !ed.validValue(ed.getSelection())) {
                    return ed.getErrorMessage();
                }
                ++i;
            }
        }
        i = 0;
        while (i < editors.length) {
            ed = (ICellEditor)editors[i];
            ed.dispose();
            ++i;
        }
        this.columnEditors.clear();
        return null;
    }

    public Composite createViewer(Composite parent) throws ApplicationException {
        this.container = this.createContainer(parent);
        this.filterText = this.createSerchBar();
        this.viewForm = this.createViewForm();
        this.toolBarManager = this.createToolBar();
        this.tableViewer = this.createTableViewer();
        if ((this.gridStyle & 0x20) == 0) {
            this.viewForm.setTopLeft((Control)this.toolBarManager.getControl());
        }
        this.viewForm.setContent(this.tableViewer.getControl());
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GridViewer.this.selection = GridViewer.this.beforeDispose();
            }
        });
        if (this.data != null) {
            this.setData(this.data);
        }
        return this.container;
    }

    public void setTableSorter(ViewerSorter viewSorter) {
        this.tableViewer.setSorter(viewSorter);
    }

    public void createViewer(Composite parent, CompositeMap data) throws ApplicationException {
        this.createViewer(parent);
        this.setData(data);
    }

    public ICellEditor getCellEditor(String property) {
        Object editor = this.columnEditors.get(property);
        if (editor != null) {
            return (ICellEditor)editor;
        }
        return null;
    }

    public Object[] getCheckedElements() {
        TableItem[] children = this.tableViewer.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getChecked()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public Control getControl() {
        return this.container;
    }

    public String getFilterColumn() {
        return this.filterColumn;
    }

    public String[] getColumnNames() throws ApplicationException {
        if (this.columnNames == null) {
            this.columnNames = CompositeMapUtil.getArrayAttrNames(this.data);
        }
        return this.columnNames;
    }

    public String[] getColumnTitles() throws ApplicationException {
        if (this.columnTitles == null) {
            this.columnTitles = this.getColumnNames();
        }
        return this.columnTitles;
    }

    public CompositeMap getInput() {
        return this.data;
    }

    public IViewer getParent() {
        return this.parent;
    }

    public CompositeMap getSelection() {
        if (!this.container.isDisposed()) {
            return this.beforeDispose();
        }
        return this.selection;
    }

    public CompositeMap getFocus() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        CompositeMap record = (CompositeMap)selection.getFirstElement();
        return record;
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public void packColumns() {
        if (this.tableViewer.getTable() == null || this.isColumnPacked) {
            return;
        }
        int i = 0;
        while (i < this.tableViewer.getTable().getColumnCount()) {
            TableColumn column = this.tableViewer.getTable().getColumn(i);
            column.pack();
            ++i;
        }
        this.isColumnPacked = true;
    }

    public void refresh(boolean dirty) {
        if (dirty && this.parent != null) {
            this.parent.refresh(true);
        } else if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
            if (this.data != null && this.data.getChilds() != null) {
                this.labelProvider.refresh();
                this.tableViewer.setInput((Object)this.data);
            } else {
                this.tableViewer.getTable().removeAll();
            }
        }
    }

    public void removeCellModifierListener(ICellModifierListener listener) {
        this.cellModifiers.removeCellModifierListener(listener);
    }

    public void setActions(IAction[] actions) {
        this.toolBarManager.removeAll();
        if (actions == null) {
            return;
        }
        int i = 0;
        while (i < actions.length) {
            this.toolBarManager.add((IContributionItem)this.createActionContributionItem(actions[i]));
            ++i;
        }
        this.toolBarManager.update(true);
    }

    public void setCellEditors(CellEditor[] cellEditors) {
        this.cellEditors = cellEditors;
    }

    public void setData(CompositeMap data) throws ApplicationException {
        this.data = data;
        if (this.tableViewer != null) {
            this.createDefaultActions();
            if (this.tableViewer.getColumnProperties() == null) {
                this.createTableColumns();
            }
            if (data != null && data.getChilds() != null) {
                this.tableViewer.setInput((Object)data);
                if (this.isAllChecked()) {
                    this.setAllChecked(this.tableViewer.getTable(), true);
                }
            }
        }
    }

    public void refreshData() {
        this.tableViewer.setInput((Object)this.data);
    }

    public void setFilterColumn(String filterColumn) {
        this.filterColumn = filterColumn;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setGridStyle(int gridStyle) {
        this.gridStyle = gridStyle;
    }

    public void setParent(IViewer parent) {
        this.parent = parent;
    }

    protected void createDefaultActions() {
        this.toolBarManager.removeAll();
        if ((this.gridStyle & 0x20) == 0 && (this.gridStyle & 8) != 0) {
            Element element = null;
            try {
                element = CompositeMapUtil.getElement(this.data);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (element != null && element.isArray()) {
                QualifiedName qName = element.getElementType().getQName();
                AddElementAction addAction = new AddElementAction(this, this.data, qName, 0);
                addAction.setText("");
                addAction.setHoverImageDescriptor(AuroraPlugin.getImageDescriptor(LocaleMessage.getString("add.icon")));
                RemoveElementAction removeAction = new RemoveElementAction(this, 2);
                RefreshAction refreshAction = new RefreshAction(this, 2);
                this.toolBarManager.add((IContributionItem)this.createActionContributionItem((IAction)addAction));
                this.toolBarManager.add((IContributionItem)this.createActionContributionItem((IAction)refreshAction));
                this.toolBarManager.add((IContributionItem)this.createActionContributionItem((IAction)removeAction));
                this.toolBarManager.update(true);
                this.tableViewer.getTable().addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 127) {
                            GridViewer.this.removeElement();
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
            }
        }
        if ((this.gridStyle & 2) != 0) {
            Action allCheckAction = new Action(LocaleMessage.getString("all.checed"), AuroraPlugin.getImageDescriptor(LocaleMessage.getString("checked.icon"))){

                public void run() {
                    GridViewer.this.setAllChecked(GridViewer.this.tableViewer.getTable(), true);
                }
            };
            Action unAllCheckAction = new Action(LocaleMessage.getString("non.checed"), AuroraPlugin.getImageDescriptor(LocaleMessage.getString("unchecked.icon"))){

                public void run() {
                    GridViewer.this.setAllChecked(GridViewer.this.tableViewer.getTable(), false);
                }
            };
            this.toolBarManager.add((IContributionItem)this.createActionContributionItem((IAction)allCheckAction));
            this.toolBarManager.add((IContributionItem)this.createActionContributionItem((IAction)unAllCheckAction));
            this.toolBarManager.update(true);
        }
    }

    protected CellEditor[] getCellEditors() throws ApplicationException {
        if (this.cellEditors != null) {
            return this.cellEditors;
        }
        if ((this.gridStyle & 8) == 0) {
            String[] columnNames = this.getColumnNames();
            this.cellEditors = new CellEditor[columnNames.length];
            int i = 0;
            while (i < columnNames.length) {
                TextCellEditor tce = new TextCellEditor((Composite)this.tableViewer.getTable());
                Text text = (Text)tce.getControl();
                text.setEditable(false);
                this.cellEditors[i] = tce;
                ++i;
            }
        } else {
            List attrib_list = CompositeMapUtil.getArrayAttrs(this.data);
            this.cellEditors = new CellEditor[attrib_list.size()];
            int id = 0;
            for (Attribute attrib : attrib_list) {
                ICellEditor cellEditor = CellEditorFactory.getInstance().createCellEditor(this, attrib, null, null);
                if (cellEditor != null) {
                    this.cellEditors[id++] = cellEditor.getCellEditor();
                    this.addEditor(attrib.getLocalName(), cellEditor);
                    continue;
                }
                this.cellEditors[id++] = new TextCellEditor((Composite)this.tableViewer.getTable());
            }
        }
        return this.cellEditors;
    }

    protected Composite createContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        return container;
    }

    protected void createTableCompoment() throws ApplicationException {
        if ((this.gridStyle & 8) == 0 && (this.gridStyle & 0x100) == 0) {
            this.labelProvider = new PlainCompositeMapLabelProvider(this.getColumnNames());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.tableViewer.setCellModifier((ICellModifier)new PlainCompositeMapCellModifier());
        } else {
            this.labelProvider = new PropertyGridLabelProvider(this.getColumnNames(), this);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.cellModifiers = new GridCellModifier(this);
            this.tableViewer.setCellModifier((ICellModifier)this.cellModifiers);
        }
    }

    protected ToolBarManager createToolBar() {
        ToolBar toolBar = new ToolBar((Composite)this.viewForm, 0x820000);
        ToolBarManager toolBarManager = new ToolBarManager(toolBar);
        return toolBarManager;
    }

    protected ToolBar createToolBar(ViewForm viewForm) {
        ToolBar toolBar = new ToolBar((Composite)viewForm, 0x820000);
        this.toolBarManager = new ToolBarManager(toolBar);
        return toolBar;
    }

    private ActionContributionItem createActionContributionItem(IAction action) {
        ActionContributionItem aci = new ActionContributionItem(action);
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        return aci;
    }

    private Text createSerchBar() {
        Text filterText = null;
        if ((this.gridStyle & 0x10) != 0) {
            Label headerLabel = new Label(this.container, 0);
            String columnText = this.filterColumn;
            if (this.columnNames != null && this.columnTitles != null) {
                int i = 0;
                while (i < this.columnNames.length) {
                    if (this.filterColumn.equals(this.columnNames[i])) {
                        columnText = this.columnTitles[i];
                        break;
                    }
                    ++i;
                }
            }
            headerLabel.setText(String.valueOf(LocaleMessage.getString("please.input")) + columnText + LocaleMessage.getString("prefix.of.column"));
            GridData gd = new GridData(768);
            headerLabel.setLayoutData((Object)gd);
            filterText = new Text(this.container, 2180);
            gd.heightHint = 15;
            filterText.setLayoutData((Object)gd);
        }
        return filterText;
    }

    private void createTableColumn(TableViewer tableViewer) throws ApplicationException {
        Image idp = ImagesUtils.getImage("attribute.gif");
        String[] fullColumnTitles = this.getfullColumnTitles();
        int i = 0;
        while (i < fullColumnTitles.length) {
            TableColumn column = new TableColumn(tableViewer.getTable(), 16384);
            column.setText(fullColumnTitles[i]);
            column.setImage(idp);
            if (i == 0) {
                column.pack();
            } else {
                this.setColumnWidth(column, tableViewer, fullColumnTitles.length - 1);
            }
            ++i;
        }
    }

    private void setColumnWidth(TableColumn column, TableViewer tableViewer, int propertyLength) {
        int defaultScreenWidth = 800;
        int defaultColumnWidth = 120;
        int appendWidth = 100;
        int width = tableViewer.getTable().getParent().getBounds().width;
        width = width == 0 ? 800 : width;
        int columnWidth = (width - 100) / propertyLength;
        if (columnWidth > 120) {
            column.setWidth(columnWidth);
            return;
        }
        if ((4 & this.gridStyle) != 0) {
            column.pack();
        } else {
            column.setWidth(columnWidth);
        }
    }

    protected void createTableColumns() throws ApplicationException {
        this.columnNames = this.getColumnNames();
        this.tableViewer.setColumnProperties(this.getfullColumnNames());
        this.createDefaultActions();
        this.createTableCompoment();
        this.createTableColumn(this.tableViewer);
        CellEditor[] editors = this.getfullCellEditor();
        this.tableViewer.setCellEditors(editors);
    }

    private String[] getfullColumnNames() throws ApplicationException {
        String[] columnNames = this.getColumnNames();
        String[] fullColumnNames = new String[columnNames.length + 1];
        fullColumnNames[0] = "seq";
        System.arraycopy(columnNames, 0, fullColumnNames, 1, columnNames.length);
        return fullColumnNames;
    }

    private String[] getfullColumnTitles() throws ApplicationException {
        String[] columnTitles = this.getColumnTitles();
        String[] fullColumnTitles = new String[columnTitles.length + 1];
        fullColumnTitles[0] = (this.gridStyle & 0x80) == 0 ? "\u5e8f\u53f7" : "";
        System.arraycopy(columnTitles, 0, fullColumnTitles, 1, columnTitles.length);
        return fullColumnTitles;
    }

    private CellEditor[] getfullCellEditor() throws ApplicationException {
        CellEditor[] cellEditor = this.getCellEditors();
        CellEditor[] fullCellEditor = new CellEditor[cellEditor.length + 1];
        System.arraycopy(cellEditor, 0, fullCellEditor, 1, cellEditor.length);
        return fullCellEditor;
    }

    protected TableViewer createTableViewer() {
        int style = 0;
        style = (this.gridStyle & 2) == 0 ? 68356 : 68386;
        TableViewer tableViewer = new TableViewer((Composite)this.viewForm, style);
        tableViewer.setContentProvider((IContentProvider)new PropertyGridContentProvider());
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.getTable().setHeaderVisible(true);
        if (this.isAllChecked()) {
            this.setAllChecked(tableViewer.getTable(), true);
        }
        if (this.isSerchable()) {
            final CompositeMapFilter filter = new CompositeMapFilter(this.filterColumn);
            tableViewer.addFilter((ViewerFilter)filter);
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String filterChars = GridViewer.this.filterText.getText();
                    filterChars = filterChars.toUpperCase();
                    filter.setFilterString(filterChars);
                    GridViewer.this.refresh(false);
                }
            });
        }
        return tableViewer;
    }

    protected ViewForm createViewForm() {
        ViewForm viewForm = new ViewForm(this.container, 0);
        GridData gd = new GridData(1808);
        viewForm.setLayoutData((Object)gd);
        viewForm.setLayout((Layout)new FillLayout());
        return viewForm;
    }

    private boolean isAllChecked() {
        return (this.gridStyle & 0x40) != 0;
    }

    private boolean isSerchable() {
        return (this.gridStyle & 0x10) != 0;
    }

    public void setAllChecked(Table table, boolean state) {
        TableItem[] children = table.getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            item.setChecked(state);
            ++i;
        }
    }
}

