/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.component.wizard.ActionsFactory;
import aurora.ide.editor.AbstractCMViewer;
import aurora.ide.editor.core.IViewer;
import aurora.ide.editor.widgets.CompositeMapTreeContentProvider;
import aurora.ide.editor.widgets.CompositeMapTreeLabelProvider;
import aurora.ide.editor.widgets.ToolBarAddElementListener;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.helpers.LocaleMessage;
import aurora.ide.node.action.ActionInfo;
import aurora.ide.node.action.CopyElementAction;
import aurora.ide.node.action.ElementDoubleClickListener;
import aurora.ide.node.action.PasteAction;
import aurora.ide.node.action.RefreshAction;
import aurora.ide.node.action.RemoveElementAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import uncertain.composite.CompositeMap;

public class CompositeMapTreeViewer
extends AbstractCMViewer {
    protected TreeViewer treeViewer;
    protected IViewer parentViewer;
    private CompositeMap input;
    public static final String VirtualNode = "VirtualNode";

    public CompositeMapTreeViewer(IViewer parentViewer, CompositeMap data) {
        this.parentViewer = parentViewer;
        this.input = data;
    }

    public void create(Composite parent) {
        ViewForm viewForm = new ViewForm(parent, 0);
        viewForm.setLayout((Layout)new FillLayout());
        Tree tree = new Tree((Composite)viewForm, 0);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CompositeMapTreeLabelProvider());
        CompositeMap parentData = this.input.getParent();
        if (parentData == null) {
            parentData = this.createVirtualParentNode(this.input);
        }
        this.treeViewer.setContentProvider((IContentProvider)new CompositeMapTreeContentProvider(this.input));
        this.treeViewer.setInput((Object)parentData);
        this.fillContextMenu();
        this.fillKeyListener();
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new ElementDoubleClickListener(this));
        viewForm.setContent(this.treeViewer.getControl());
        this.fillElementToolBar((Composite)viewForm);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public Object getViewer() {
        return this.treeViewer;
    }

    public void setSelection(Object data) {
        this.selectedData = (CompositeMap)data;
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    public void setFocus(Object data) {
        this.focusData = (CompositeMap)data;
    }

    public void setDirty(boolean dirty) {
        this.parentViewer.refresh(true);
    }

    public void refresh(boolean dirty) {
        if (dirty) {
            this.parentViewer.refresh(true);
        } else {
            this.treeViewer.refresh();
        }
    }

    public void setInput(CompositeMap data) {
        CompositeMap parent = data.getParent();
        if (parent == null) {
            parent = this.createVirtualParentNode(data);
        }
        this.treeViewer.setContentProvider((IContentProvider)new CompositeMapTreeContentProvider(data));
        this.treeViewer.setInput((Object)parent);
    }

    public CompositeMap getInput() {
        return this.input;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public MenuManager addChildElements() throws ApplicationException {
        String text = LocaleMessage.getString("add.element.label");
        ImageDescriptor imageDes = AuroraPlugin.getImageDescriptor(LocaleMessage.getString("add.icon"));
        MenuManager childElementMenus = new MenuManager(text, imageDes, null);
        CompositeMap comp = this.focusData;
        ActionInfo actionProperties = new ActionInfo(this, comp);
        ActionsFactory.getInstance().addActionsToMenuManager(childElementMenus, actionProperties);
        return childElementMenus;
    }

    public void fillContextMenu() {
        MenuManager mgr;
        MenuManager menuManager = mgr = new MenuManager("#PopupMenu");
        mgr.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                try {
                    MenuManager childElements = CompositeMapTreeViewer.this.addChildElements();
                    manager.add((IContributionItem)childElements);
                }
                catch (ApplicationException e) {
                    DialogUtil.showExceptionMessageBox(e);
                }
                manager.add((IAction)new CopyElementAction(CompositeMapTreeViewer.this, CopyElementAction.getDefaultImageDescriptor(), CopyElementAction.getDefaultText()));
                manager.add((IAction)new PasteAction(CompositeMapTreeViewer.this, 6));
                manager.add((IAction)new RemoveElementAction(CompositeMapTreeViewer.this, 6));
                manager.add((IAction)new RefreshAction(CompositeMapTreeViewer.this, 6));
            }
        });
        Menu menu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public void fillKeyListener() {
        this.treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 99) {
                    CompositeMapTreeViewer.this.copyElement();
                } else if (e.stateMask == 262144 && e.keyCode == 118) {
                    CompositeMapTreeViewer.this.pasteElement();
                } else if (e.keyCode == 127) {
                    CompositeMapTreeViewer.this.removeElement();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void fillElementToolBar(Composite shell) {
        ToolBar toolBar = new ToolBar(shell, 0x820000);
        Menu menu = new Menu((Control)shell);
        ToolItem addItem = new ToolItem(toolBar, 4);
        this.setToolItemShowProperty(addItem, LocaleMessage.getString("add.element.label"), "add.gif");
        addItem.addListener(13, (Listener)new ToolBarAddElementListener(toolBar, menu, addItem, this));
        ToolItem cutItem = new ToolItem(toolBar, 8);
        this.setToolItemShowProperty(cutItem, LocaleMessage.getString("cut"), "cut.gif");
        cutItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CompositeMapTreeViewer.this.cutElement();
            }
        });
        ToolItem copyItem = new ToolItem(toolBar, 8);
        this.setToolItemShowProperty(copyItem, LocaleMessage.getString("copy"), "copy.gif");
        copyItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CompositeMapTreeViewer.this.copyElement();
            }
        });
        ToolItem pasteItem = new ToolItem(toolBar, 8);
        this.setToolItemShowProperty(pasteItem, LocaleMessage.getString("paste"), "paste.gif");
        pasteItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CompositeMapTreeViewer.this.pasteElement();
            }
        });
        ToolItem refreshItem = new ToolItem(toolBar, 8);
        this.setToolItemShowProperty(refreshItem, LocaleMessage.getString("refresh"), "refresh.gif");
        refreshItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CompositeMapTreeViewer.this.treeViewer.refresh();
                LoadSchemaManager.refeshSchemaManager();
            }
        });
        ToolItem removeItem = new ToolItem(toolBar, 8);
        this.setToolItemShowProperty(removeItem, LocaleMessage.getString("delete"), "delete.gif");
        removeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CompositeMapTreeViewer.this.removeElement();
            }
        });
        toolBar.pack();
        ((ViewForm)shell).setTopLeft((Control)toolBar);
    }

    private void setToolItemShowProperty(ToolItem toolItem, String text, String iconPath) {
        if (text != null && !text.equals("")) {
            toolItem.setToolTipText(text);
        }
        if (iconPath != null && !iconPath.equals("")) {
            Image icon = ImagesUtils.getImage(iconPath);
            toolItem.setImage(icon);
        }
    }

    private CompositeMap createVirtualParentNode(CompositeMap node) {
        if (node == null) {
            return null;
        }
        CompositeMap parentNode = node.getParent();
        if (parentNode != null) {
            return parentNode;
        }
        CommentCompositeMap virtualNode = new CommentCompositeMap(VirtualNode);
        virtualNode.addChild(node);
        return virtualNode;
    }
}

