/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.ImagesUtils;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.schema.Element;

public class CompositeMapTreeLabelProvider
extends BaseLabelProvider
implements ILabelProvider {
    public Image getImage(Object element) {
        CompositeMap elemenntCm = (CompositeMap)element;
        Element ele = CompositeMapUtil.getElement(elemenntCm);
        if (ele != null && ele.isArray()) {
            return ImagesUtils.getImage("array.gif");
        }
        return ImagesUtils.getImage("element.gif");
    }

    public String getText(Object obj) {
        String elementText = null;
        CompositeMap elemenntCm = (CompositeMap)obj;
        String tagName = elemenntCm.getRawName();
        String elementName = this.getElementName(elemenntCm);
        elementText = elementName != null && !elementName.equals("") ? elementName : tagName;
        Element element = CompositeMapUtil.getElement(elemenntCm);
        if (element != null && element.isArray()) {
            int nodes = elemenntCm.getChildsNotNull().size();
            return "[" + nodes + "]" + elementText;
        }
        return elementText;
    }

    private String getElementName(CompositeMap element) {
        String tagName = element.getRawName();
        Element elm = CompositeMapUtil.getElement(element);
        String elemDesc = null;
        if (elm != null && !elm.isArray()) {
            if (elm.getDisplayMask() != null) {
                elemDesc = TextParser.parse((String)elm.getDisplayMask(), (CompositeMap)element);
            }
            if (elemDesc != null) {
                tagName = String.valueOf(tagName) + " " + elemDesc;
            }
        }
        if (elemDesc == null) {
            if (element.get((Object)"id") != null) {
                elemDesc = element.getString((Object)"id");
            } else if (element.get((Object)"name") != null) {
                elemDesc = element.get((Object)"name").toString();
            } else if (element.get((Object)"Name") != null) {
                elemDesc = element.get((Object)"Name").toString();
            }
            if (elemDesc != null) {
                tagName = String.valueOf(tagName) + " (" + elemDesc + ")";
            }
        }
        return tagName;
    }
}

