/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.xml.validate;

import aurora.ide.editor.textpage.xml.validate.XMLErrorHandler;
import aurora.ide.helpers.DialogUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidator {
    private static SAXParserFactory parser_factory = SAXParserFactory.newInstance();
    private XMLErrorHandler errorHandler;

    static {
        parser_factory.setNamespaceAware(true);
        parser_factory.setValidating(false);
    }

    public XMLValidator(XMLErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void validate(InputSource source) {
        block7: {
            try {
                SAXParser parser = parser_factory.newSAXParser();
                XMLReader xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(new DefaultHandler());
                if (this.errorHandler != null) {
                    xmlReader.setErrorHandler(this.errorHandler);
                }
                xmlReader.parse(source);
            }
            catch (ParserConfigurationException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.configurationError(e);
                }
            }
            catch (SAXException e) {
                if (this.errorHandler != null) {
                    this.errorHandler.configurationError(e);
                }
            }
            catch (IOException e) {
                if (this.errorHandler == null) break block7;
                this.errorHandler.configurationError(e);
            }
        }
    }

    public void validate(InputStream stream) {
        this.validate(new InputSource(stream));
    }

    public void validate(String xml) {
        try {
            this.validate(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void validate(IFile file) {
        try {
            this.validate(file.getContents());
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public void validate(File file) {
        try {
            this.validate(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            DialogUtil.showExceptionMessageBox(e);
        }
    }
}

