/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.RegionUtil;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;

public class QuickAssistUtil {
    public static CompositeMap findMap(CompositeMap rootMap, IDocument doc, int offset) {
        List childs = rootMap.getChildsNotNull();
        for (CompositeMap map : childs) {
            CompositeMapInfo info = new CompositeMapInfo(map, doc);
            IRegion region = info.getMapRegion();
            if (!RegionUtil.isInRegion(region, offset)) continue;
            return QuickAssistUtil.findMap(map, doc, offset);
        }
        return rootMap;
    }

    public static CompositeMapInfo findMapInfo(CompositeMap rootMap, IDocument doc, int offset) {
        List childs = rootMap.getChildsNotNull();
        CompositeMapInfo info = new CompositeMapInfo(rootMap, doc);
        for (CompositeMap map : childs) {
            CompositeMapInfo inf = new CompositeMapInfo(map, doc);
            IRegion region = inf.getMapRegion();
            if (!RegionUtil.isInRegion(region, offset)) continue;
            return QuickAssistUtil.findMapInfo(map, doc, offset);
        }
        return info;
    }

    public static int getEditDistance(char[] a, char[] b) {
        int m = a.length;
        int n = b.length;
        int[] d = new int[n + 1];
        int i = 0;
        while (i <= n) {
            d[i] = i;
            ++i;
        }
        i = 1;
        while (i <= m) {
            int y = i - 1;
            int j = 1;
            while (j <= n) {
                int x = y;
                y = d[j];
                int z = j > 1 ? d[j - 1] : i;
                int del = a[i - 1] == b[j - 1] ? 0 : 1;
                d[j] = Math.min(Math.min(x + del, y + 1), z + 1);
                ++j;
            }
            ++i;
        }
        int temp = d[n];
        return temp;
    }

    public static int getEditDistance(String t, String s) {
        return QuickAssistUtil.getEditDistance(t.toLowerCase().toCharArray(), s.toLowerCase().toCharArray());
    }

    public static int getApproiateEditDistance(String s1, String s2) {
        int ed = QuickAssistUtil.getEditDistance(s1, s2);
        long len = 1L << ed;
        if (len < 0L || len > (long)s2.length()) {
            return -1;
        }
        return ed;
    }
}

