/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.editor.textpage.quickfix.AbstractProposalCreator;
import aurora.ide.editor.textpage.quickfix.AttrProposalCreator;
import aurora.ide.editor.textpage.quickfix.BmProposalCreator;
import aurora.ide.editor.textpage.quickfix.DsProposalCreator;
import aurora.ide.editor.textpage.quickfix.ForeignFieldProposalCreator;
import aurora.ide.editor.textpage.quickfix.LocalFieldProposalCreator;
import aurora.ide.editor.textpage.quickfix.TagProposalCreator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import uncertain.composite.CompositeMap;

public class CompletionProposalCreator {
    private CompositeMap rootMap;
    private IDocument doc;
    private IMarker marker;
    private String markerType = "";

    public CompletionProposalCreator(IDocument doc, CompositeMap rootMap, IMarker marker) {
        this.rootMap = rootMap;
        this.doc = doc;
        this.marker = marker;
        try {
            this.markerType = marker.getType();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public ICompletionProposal[] getCompletionProposal() {
        AbstractProposalCreator creator = null;
        if (this.markerType.equals("aurora.ide.undefinedAttribute")) {
            creator = new AttrProposalCreator(this.doc, this.rootMap, this.marker);
        } else if (this.markerType.equals("aurora.ide.undefinedDataSet")) {
            creator = new DsProposalCreator(this.doc, this.rootMap, this.marker);
        } else if (this.markerType.equals("aurora.ide.undefinedBM")) {
            creator = new BmProposalCreator(this.doc, this.rootMap, this.marker);
        } else if (this.markerType.equals("aurora.ide.undefinedTag")) {
            creator = new TagProposalCreator(this.doc, this.rootMap, this.marker);
        } else if (this.markerType.equals("aurora.ide.undefinedForeignField")) {
            creator = new ForeignFieldProposalCreator(this.doc, this.rootMap, this.marker);
        } else if (this.markerType.equals("aurora.ide.undefinedLocalField")) {
            creator = new LocalFieldProposalCreator(this.doc, this.rootMap, this.marker);
        }
        if (creator != null) {
            return creator.createProposal();
        }
        return null;
    }
}

