/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.editor.textpage.quickfix.AbstractProposalCreator;
import aurora.ide.editor.textpage.quickfix.Messages;
import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import aurora.ide.editor.textpage.quickfix.SortElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.util.NLS;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrProposalCreator
extends AbstractProposalCreator {
    public AttrProposalCreator(IDocument doc, CompositeMap rootMap, IMarker marker) {
        super(doc, rootMap, marker);
    }

    @Override
    protected boolean isFixable() {
        return super.isFixable() && this.getCursorMap().getString((Object)this.getMarkerWord()) != null;
    }

    @Override
    protected void create(ArrayList<ICompletionProposal> result) {
        CompositeMap map = this.getCursorMap();
        String word = this.getMarkerWord();
        CompositeMapInfo info = new CompositeMapInfo(map, this.getDocument());
        IRegion attrRegion = info.getAttrRegion(word);
        if (attrRegion == null) {
            return;
        }
        ArrayList<SortElement> comp = this.getAvailableAttrNames(map);
        for (SortElement se : comp) {
            String attrName = se.name;
            CompletionProposal cp = new CompletionProposal(attrName, attrRegion.getOffset(), word.length(), attrName.length(), img_rename, NLS.bind((String)Messages.AttrProposalCreator_0, (Object)word, (Object)attrName), null, NLS.bind((String)Messages.AttrProposalCreator_2, (Object)attrName));
            result.add((ICompletionProposal)cp);
        }
        result.add((ICompletionProposal)new CompletionProposal("", attrRegion.getOffset() - 1, attrRegion.getLength() + 1, 0, img_remove, Messages.AttrProposalCreator_4, null, Messages.AttrProposalCreator_5));
    }

    private Set<String> getUsedAttrNames(CompositeMap map) {
        Set enterySet = map.entrySet();
        HashSet<String> attrSet = new HashSet<String>();
        for (Map.Entry e : enterySet) {
            if (e.getKey() == null) continue;
            attrSet.add(((String)e.getKey()).toLowerCase());
        }
        return attrSet;
    }

    private ArrayList<SortElement> getAvailableAttrNames(CompositeMap map) {
        List<Attribute> definedAttribute;
        ArrayList<SortElement> comp = new ArrayList<SortElement>();
        Set<String> attrSet = this.getUsedAttrNames(map);
        try {
            definedAttribute = SxsdUtil.getAttributesNotNull(map);
        }
        catch (Exception e) {
            return comp;
        }
        for (Attribute attr : definedAttribute) {
            int ed;
            String aname = attr.getName();
            if (attrSet.contains(aname.toLowerCase()) || (ed = QuickAssistUtil.getApproiateEditDistance(this.getMarkerWord(), aname)) <= 0) continue;
            comp.add(new SortElement(aname, ed));
        }
        Collections.sort(comp);
        return comp;
    }
}

