/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.quickfix;

import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import aurora.ide.helpers.ImagesUtils;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProposalCreator {
    public static Image img_new = null;
    public static Image img_remove = null;
    public static Image img_rename = null;
    private CompositeMap rootMap;
    private IDocument doc;
    private IMarker marker;
    private IRegion markerRegion;
    private int line = 0;
    private String word;
    private String markerType;
    private int markerOffset;
    private int markerLength;
    private CompositeMap cursorMap;
    private ArrayList<ICompletionProposal> results = new ArrayList();

    static {
        try {
            img_new = ImagesUtils.getImage("add.gif");
            img_remove = ImagesUtils.getImage("delete.gif");
            img_rename = ImagesUtils.getImage("rename.gif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AbstractProposalCreator(IDocument doc, CompositeMap rootMap, IMarker marker) {
        this.rootMap = rootMap;
        this.doc = doc;
        this.marker = marker;
        this.markerOffset = marker.getAttribute("charStart", 0);
        this.markerLength = marker.getAttribute("charEnd", 0) - this.markerOffset;
        this.markerRegion = new Region(this.markerOffset, this.markerLength);
        try {
            this.line = doc.getLineOfOffset(this.markerOffset);
            this.word = doc.get(this.markerOffset, this.markerLength);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        try {
            this.markerType = marker.getType();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.cursorMap = QuickAssistUtil.findMap(rootMap, doc, this.markerOffset);
    }

    protected CompositeMap getRootMap() {
        return this.rootMap;
    }

    protected CompositeMap getCursorMap() {
        return this.cursorMap;
    }

    protected IDocument getDocument() {
        return this.doc;
    }

    protected int getMarkerOffset() {
        return this.markerOffset;
    }

    protected int getMarkerLength() {
        return this.markerLength;
    }

    protected IRegion getMarkerRegion() {
        return this.markerRegion;
    }

    protected int getMarkerLine() {
        return this.line;
    }

    protected String getMarkerWord() {
        return this.word;
    }

    protected IMarker getMarker() {
        return this.marker;
    }

    protected String getMarkerType() {
        return this.markerType;
    }

    protected boolean isFixable() {
        return this.markerType != null && this.word != null && this.rootMap != null && this.doc != null;
    }

    protected boolean isValidWord(String w) {
        char[] ics;
        char[] cArray = ics = new char[]{'\'', '\"', ' ', '\t', '\r', '\n'};
        int n = ics.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (w.indexOf(c) != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected abstract void create(ArrayList<ICompletionProposal> var1);

    public ICompletionProposal[] createProposal() {
        if (!this.isFixable()) {
            return null;
        }
        this.create(this.results);
        ICompletionProposal[] cps = new ICompletionProposal[this.results.size()];
        this.results.toArray(cps);
        return cps;
    }
}

