/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.js.validate;

import aurora.ide.editor.textpage.IReconcileListener;
import aurora.ide.editor.textpage.js.validate.AnnotationReporter;
import aurora.ide.editor.textpage.js.validate.JavascriptValidator;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public class JSValidator
implements IReconcileListener {
    private static final String SCRIPT = "<script( .*){0,1}>";
    private static final String C_DATA_BEGIN = "<![CDATA[";
    private static final String C_DATA_END = "]]>";
    private AnnotationReporter reporter;
    private IDocument document;
    private ISourceViewer mSourceViewer;

    public JSValidator(ISourceViewer sourceViewer) {
        this.mSourceViewer = sourceViewer;
        this.document = sourceViewer.getDocument();
    }

    public AnnotationReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new AnnotationReporter(this.mSourceViewer.getAnnotationModel());
        }
        return this.reporter;
    }

    private void validate(IDocument document, ITypedRegion partition) throws BadLocationException {
        int beginOffset = partition.getOffset() + C_DATA_BEGIN.length();
        int length = partition.getLength() - C_DATA_BEGIN.length() - C_DATA_END.length();
        int beginLine = document.getLineOfOffset(beginOffset);
        String source = document.get(beginOffset, length);
        AnnotationReporter reporter = this.getReporter();
        reporter.reset(document, beginLine, beginOffset);
        JavascriptValidator validator = new JavascriptValidator(reporter);
        validator.validate("javascript", source);
    }

    public void reconcile() {
        this.document = this.mSourceViewer.getDocument();
        if (this.document == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                StyledText textWidget = JSValidator.this.mSourceViewer.getTextWidget();
                if (textWidget == null) {
                    return;
                }
                int offset = textWidget.getCaretOffset();
                if (offset <= 0) {
                    return;
                }
                try {
                    ITypedRegion partition = JSValidator.this.document.getPartition(offset);
                    int offset2 = partition.getOffset() - 1;
                    if (offset2 <= 0) {
                        return;
                    }
                    ITypedRegion parentRegion = JSValidator.this.document.getPartition(offset2);
                    String parentNode = JSValidator.this.document.get(parentRegion.getOffset(), parentRegion.getLength());
                    if (parentNode == null) {
                        return;
                    }
                    String type = partition.getType();
                    if ("XML_CDATA".equals(type) && parentNode.matches(JSValidator.SCRIPT)) {
                        JSValidator.this.validate(JSValidator.this.document, partition);
                    }
                }
                catch (BadLocationException e) {
                    DialogUtil.logErrorException(e);
                }
            }
        });
    }
}

