/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.hover;

import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.builder.RegionUtil;
import aurora.ide.builder.SxsdUtil;
import aurora.ide.editor.textpage.hover.HoverInformationControlCreator;
import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.schema.ITypeDelegate;
import aurora.ide.schema.SchemaTypeManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

public class TextHover
extends DefaultTextHover
implements ITextHoverExtension {
    private ISourceViewer sourceViewer;
    private static String style = "<style>body,table{ font-family:sans-serif; font-size:9pt; background:#FFFFE1; } table,td,th {border:1px solid #888 ;border-collapse:collapse;}</style>";
    private MarkerAnnotation lastAnno = null;
    private IDocument doc;
    private CompositeMap map;

    public TextHover(ISourceViewer sourceViewer) {
        super(sourceViewer);
        this.sourceViewer = sourceViewer;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new HoverInformationControlCreator(this.lastAnno);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String hover = this.getMarkerInfo(this.sourceViewer, hoverRegion);
        if (hover != null) {
            return TextHover.html(hover);
        }
        this.doc = textViewer.getDocument();
        String word = null;
        try {
            word = this.doc.get(hoverRegion.getOffset(), hoverRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        try {
            this.map = CompositeMapUtil.loaderFromString(this.doc.get());
        }
        catch (Exception e) {
            return null;
        }
        CompositeMap cursorMap = QuickAssistUtil.findMap(this.map, this.doc, hoverRegion.getOffset());
        CompositeMapInfo info = new CompositeMapInfo(cursorMap, this.doc);
        if (hoverRegion.equals(info.getMapNameRegion()) || hoverRegion.equals(info.getMapEntTagNameRegion())) {
            return TextHover.html(SxsdUtil.getHtmlDocument(cursorMap));
        }
        Set keySet = cursorMap.keySet();
        for (String key : keySet) {
            IRegion region = info.getAttrNameRegion(key);
            if (region == null) continue;
            if (hoverRegion.equals(region)) {
                return TextHover.html(this.getAttrDocument(cursorMap, key));
            }
            region = info.getAttrValueRegion2(key);
            if (region == null || !RegionUtil.isSubRegion(region, hoverRegion)) continue;
            SchemaTypeManager stm = new SchemaTypeManager(cursorMap);
            ITypeDelegate de = stm.getAttributeTypeDelegate(key);
            if (de != null) {
                return TextHover.html(de.getValue(cursorMap.getString((Object)key)));
            }
            return TextHover.html("<pre>" + cursorMap.getString((Object)key) + "</pre>");
        }
        Map nsMap = cursorMap.getNamespaceMapping();
        HashMap<String, String> reverseNsMap = new HashMap<String, String>();
        if (nsMap != null) {
            for (String key : nsMap.keySet()) {
                reverseNsMap.put((String)nsMap.get(key), key);
            }
        }
        for (String key : reverseNsMap.keySet()) {
            String realKey = "xmlns:" + key;
            IRegion region = info.getAttrNameRegion(realKey);
            if (region == null) continue;
            if (RegionUtil.isSubRegion(region, hoverRegion)) {
                return TextHover.html("XML Namespace : " + key + "   ");
            }
            region = info.getAttrValueRegion2(realKey);
            if (region == null || !RegionUtil.isSubRegion(region, hoverRegion)) continue;
            return TextHover.html("<pre>" + info.getAttrRealValue(realKey) + "</pre>");
        }
        return TextHover.html(word);
    }

    private String getAttrDocument(CompositeMap map, String attrName) {
        StringBuilder sb = new StringBuilder(200);
        List<Attribute> list = null;
        try {
            list = SxsdUtil.getAttributesNotNull(map);
            for (Attribute a : list) {
                if (!attrName.equalsIgnoreCase(a.getName())) continue;
                sb.append(String.valueOf(a.getName()) + "<br/>" + SxsdUtil.notNull(a.getDocument()));
                if (SxsdUtil.getTypeNameNotNull(a).length() > 0) {
                    sb.append("<br/>Type : " + SxsdUtil.getTypeNameNotNull(a));
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            sb.append(e.getMessage());
        }
        return attrName;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument doc = textViewer.getDocument();
        try {
            int line = doc.getLineOfOffset(offset);
            int ls = doc.getLineOffset(line);
            int len = doc.getLineLength(line);
            String text = doc.get(ls, len);
            if (text == null || text.length() == 0) {
                return super.getHoverRegion(textViewer, offset);
            }
            int s = offset - ls;
            int e = offset - ls;
            char c = text.charAt(s);
            if (this.isWordPart(c)) {
                while (s >= 0 && this.isWordPart(text.charAt(s))) {
                    --s;
                }
                ++s;
                while (e < text.length() && this.isWordPart(text.charAt(e))) {
                    ++e;
                }
                return new Region(ls + s, e - s);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return super.getHoverRegion(textViewer, offset);
    }

    private String getMarkerInfo(ISourceViewer sourceViewer, IRegion hoverRegion) {
        IAnnotationModel model = null;
        if (sourceViewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)sourceViewer;
            model = extension.getVisualAnnotationModel();
        } else {
            model = sourceViewer.getAnnotationModel();
        }
        if (model == null) {
            return null;
        }
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            String msg;
            MarkerAnnotation ma;
            Annotation a = (Annotation)e.next();
            if (!(a instanceof MarkerAnnotation)) continue;
            this.lastAnno = ma = (MarkerAnnotation)a;
            Position p = model.getPosition((Annotation)ma);
            if (p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = ma.getText()) == null || msg.trim().length() <= 0) continue;
            return msg;
        }
        this.lastAnno = null;
        return null;
    }

    public static String html(String str) {
        StringBuilder sb = new StringBuilder(5000);
        sb.append("<html><head>");
        sb.append(style);
        sb.append("</head><body>");
        sb.append(str.replace("\\n", "<br/>"));
        sb.append("</body></html>");
        return sb.toString();
    }

    private boolean isWordPart(char c) {
        return c == '-' || Character.isJavaIdentifierPart(c);
    }
}

