/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.contentassist;

import aurora.ide.editor.textpage.contentassist.AttributeStrategy;
import aurora.ide.editor.textpage.contentassist.ChildStrategy;
import aurora.ide.editor.textpage.contentassist.IContentAssistStrategy;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class TagContentAssistProcessor
implements IContentAssistProcessor {
    private XMLTagScanner scanner;

    public TagContentAssistProcessor(XMLTagScanner scanner) {
        this.scanner = scanner;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IContentAssistStrategy strategy;
        block3: {
            IDocument document = viewer.getDocument();
            strategy = null;
            try {
                strategy = this.getAssistStrategy(document, offset);
                if (strategy != null) break block3;
                return null;
            }
            catch (BadLocationException e) {
                DialogUtil.logErrorException(e);
                return null;
            }
        }
        return strategy.computeCompletionProposals(viewer, offset);
    }

    private IContentAssistStrategy getAssistStrategy(IDocument document, int documentOffset) throws BadLocationException {
        ITypedRegion region = document.getPartition(documentOffset);
        if (!"XML_START_TAG".equals(region.getType())) {
            return null;
        }
        this.scanner.setRange(document, region.getOffset(), region.getLength());
        this.scanner.nextToken();
        this.scanner.nextToken();
        int tokenEndOffset = this.scanner.getTokenOffset() + this.scanner.getTokenLength();
        if (tokenEndOffset >= documentOffset) {
            return new ChildStrategy(this.scanner);
        }
        return new AttributeStrategy(this.scanner);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', ' '};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

