/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.contentassist;

import aurora.ide.editor.textpage.contentassist.IContentAssistStrategy;
import aurora.ide.editor.textpage.contentassist.TokenString;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapLocatorParser;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ExceptionUtil;
import aurora.ide.helpers.ImagesUtils;
import aurora.ide.helpers.SystemException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.composite.QualifiedName;
import uncertain.schema.Element;

public class ChildStrategy
implements IContentAssistStrategy {
    private XMLTagScanner scanner;
    private TokenString tokenString;
    private ITextViewer viewer;
    private int cursorOffset;

    public ChildStrategy(XMLTagScanner scanner) {
        this.scanner = scanner;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int cursorOffset) throws BadLocationException {
        this.viewer = viewer;
        this.cursorOffset = cursorOffset;
        IDocument document = viewer.getDocument();
        ITypedRegion region = document.getPartition(cursorOffset);
        if (!"XML_START_TAG".equals(region.getType())) {
            return null;
        }
        try {
            this.tokenString = this.createTokenString();
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return null;
        }
        this.scanner.setRange(document, region.getOffset(), region.getLength());
        String content = document.get();
        try {
            CompositeMap currentCM = this.locateCompositeMap(content, cursorOffset);
            if (currentCM != null && currentCM.getParent() != null) {
                return this.computeUpdateTag(currentCM.getParent());
            }
            return this.getDefaultCompletionProposal();
        }
        catch (ApplicationException e) {
            String originalContent = document.get();
            String changedContent = String.valueOf(originalContent.substring(0, region.getOffset())) + this.createSpace(this.tokenString.getLength()) + originalContent.substring(cursorOffset);
            try {
                CompositeMap parentCompositeMap = this.locateCompositeMap(changedContent, cursorOffset);
                if (parentCompositeMap != null) {
                    return this.computeNewTag(parentCompositeMap);
                }
            }
            catch (ApplicationException e1) {
                Throwable rootCause = ExceptionUtil.getRootCause(e1);
                String errorMessage = ExceptionUtil.getExceptionTraceMessage(rootCause);
                if (errorMessage != null && errorMessage.indexOf("end-tag") != -1) {
                    return this.computeEndTag(errorMessage);
                }
                return this.getDefaultCompletionProposal();
            }
            return this.getDefaultCompletionProposal();
        }
    }

    private ICompletionProposal[] computeEndTag(String errorMessage) {
        if (errorMessage == null || errorMessage.indexOf("end-tag") < 0) {
            return this.getDefaultCompletionProposal();
        }
        int beginIndex = errorMessage.indexOf("element type");
        int endIndex = errorMessage.indexOf("must", beginIndex);
        String content = errorMessage.substring(beginIndex, endIndex);
        beginIndex = content.indexOf("\"");
        endIndex = content.lastIndexOf("\"");
        if (beginIndex == -1 || endIndex == beginIndex) {
            return this.getDefaultCompletionProposal();
        }
        content = "</" + content.substring(beginIndex + 1, endIndex) + ">";
        IDocument document = this.viewer.getDocument();
        try {
            ITypedRegion partitionRegion = document.getPartition(this.cursorOffset);
            int length = this.cursorOffset - partitionRegion.getOffset();
            document.replace(partitionRegion.getOffset(), length, content);
            return null;
        }
        catch (BadLocationException e) {
            DialogUtil.logErrorException(e);
            return null;
        }
    }

    private ICompletionProposal[] computeNewTag(CompositeMap parent) {
        Element ele;
        ArrayList childs = CompositeMapUtil.getAvailableChildElements(parent);
        if (childs == null) {
            childs = new ArrayList();
        }
        if ((ele = CompositeMapUtil.getElement(parent)) == null) {
            return this.getDefaultCompletionProposal();
        }
        childs.addAll(ele.getAllArrays());
        ArrayList<CompletionProposal> avaliableList = new ArrayList<CompletionProposal>();
        String preString = this.tokenString.getStrBeforeCursor();
        for (Element element : childs) {
            String name = CompositeMapUtil.getContextFullName(parent, element.getQName());
            if (preString != null && !name.startsWith(preString)) continue;
            String attributeDocument = element.getDocument();
            String description = name;
            String replaceString = this.computeNewTagReplaceString(parent, element.getQName());
            if (attributeDocument != null) {
                description = String.valueOf(this.formateAttributeName(name)) + " - " + attributeDocument;
            }
            Image contentImage = element.isArray() ? ChildStrategy.getArrayImage() : ChildStrategy.getElementImage();
            avaliableList.add(new CompletionProposal(replaceString, this.tokenString.getDocumentOffset(), this.tokenString.getLength(), name.length() + 1, contentImage, description, null, attributeDocument));
        }
        int allLength = avaliableList.size();
        if (allLength == 0) {
            return this.getDefaultCompletionProposal();
        }
        ICompletionProposal[] result = new ICompletionProposal[allLength];
        int i = 0;
        Iterator iter = avaliableList.iterator();
        while (iter.hasNext()) {
            result[i] = (CompletionProposal)iter.next();
            ++i;
        }
        return result;
    }

    private String computeNewTagReplaceString(CompositeMap context, QualifiedName childQN) {
        String replaceString = CompositeMapUtil.getContextFullName(context, childQN);
        Map prefix_mapping = CompositeUtil.getPrefixMapping((CompositeMap)context);
        Object uri_obj = prefix_mapping.get(childQN.getNameSpace());
        if (uri_obj == null) {
            replaceString = childQN.getPrefix() != null ? String.valueOf(replaceString) + " xmlns:" + childQN.getPrefix() + "=\"" + childQN.getNameSpace() + "\" " : String.valueOf(replaceString) + " xmlns=\"" + childQN.getNameSpace() + "\" ";
        }
        replaceString = String.valueOf(replaceString) + " />";
        return replaceString;
    }

    private ICompletionProposal[] computeUpdateTag(CompositeMap parent) {
        Element ele;
        ArrayList childs = CompositeMapUtil.getAvailableChildElements(parent);
        if (childs == null) {
            childs = new ArrayList();
        }
        if ((ele = CompositeMapUtil.getElement(parent)) == null) {
            return this.getDefaultCompletionProposal();
        }
        childs.addAll(ele.getAllArrays());
        ArrayList<CompletionProposal> avaliableList = new ArrayList<CompletionProposal>();
        String preString = null;
        for (Element element : childs) {
            String name = CompositeMapUtil.getContextFullName(parent, element.getQName());
            if (preString != null && !name.startsWith(preString)) continue;
            String attributeDocument = element.getDocument();
            String description = name;
            String replaceString = name;
            if (attributeDocument != null) {
                description = String.valueOf(this.formateAttributeName(name)) + " - " + attributeDocument;
            }
            Image contentImage = element.isArray() ? ChildStrategy.getArrayImage() : ChildStrategy.getElementImage();
            avaliableList.add(new CompletionProposal(replaceString, this.tokenString.getDocumentOffset(), this.tokenString.getLength(), name.length() + 1, contentImage, description, null, attributeDocument));
        }
        int allLength = avaliableList.size();
        if (allLength == 0) {
            return this.getDefaultCompletionProposal();
        }
        ICompletionProposal[] result = new ICompletionProposal[allLength];
        int i = 0;
        Iterator iter = avaliableList.iterator();
        while (iter.hasNext()) {
            result[i] = (CompletionProposal)iter.next();
            ++i;
        }
        return result;
    }

    private CompositeMap locateCompositeMap(String content, int offset) throws ApplicationException {
        try {
            CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF-8"));
            CompositeMap cm = parser.getCompositeMapFromLine(is, this.getCursorLine(offset));
            return cm;
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
        catch (SAXException e) {
            throw new ApplicationException("\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
        }
        catch (IOException e) {
            throw new ApplicationException("\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
        }
    }

    private int getCursorLine(int offset) {
        return this.viewer.getTextWidget().getLineAtOffset(offset);
    }

    private String formateAttributeName(String attributeName) {
        int defaultLength = 20;
        StringBuffer newAttributeName = new StringBuffer(attributeName);
        int strLength = newAttributeName.length();
        if (strLength < defaultLength) {
            int i = 0;
            while (i < defaultLength - strLength) {
                newAttributeName.append(" ");
                ++i;
            }
        }
        return newAttributeName.toString();
    }

    private static Image getArrayImage() {
        return ImagesUtils.getImage("array.gif");
    }

    private static Image getElementImage() {
        return ImagesUtils.getImage("element.gif");
    }

    private static Image getDefaultImage() {
        return ImagesUtils.getImage("contentassit.gif");
    }

    private ICompletionProposal[] getDefaultCompletionProposal() {
        String text = this.tokenString.getText();
        if (text == null || text.equals("")) {
            return null;
        }
        String replaceString = String.valueOf(this.tokenString.getText()) + " />";
        return new ICompletionProposal[]{new CompletionProposal(replaceString, this.tokenString.getDocumentOffset(), this.tokenString.getLength(), text.length() + 1, ChildStrategy.getDefaultImage(), null, null, null)};
    }

    private TokenString createTokenString() throws ApplicationException {
        TokenString tokenString = null;
        IDocument document = this.viewer.getDocument();
        try {
            ITypedRegion partitionRegion = document.getPartition(this.cursorOffset);
            int tagEnd = this.cursorOffset - partitionRegion.getOffset();
            String partitionText = document.get(partitionRegion.getOffset(), partitionRegion.getLength());
            int partitionLength = partitionRegion.getLength();
            char c = partitionText.charAt(tagEnd);
            while (this.endChar(c, tagEnd, partitionLength)) {
                c = partitionText.charAt(++tagEnd);
            }
            String tagName = partitionText.length() < 2 ? "" : partitionText.substring(1, tagEnd);
            tokenString = new TokenString(tagName, partitionRegion.getOffset() + 1, this.cursorOffset);
        }
        catch (BadLocationException e) {
            throw new SystemException(e);
        }
        return tokenString;
    }

    private boolean endChar(char c, int end, int partitionLength) {
        return !Character.isWhitespace(c) && c != '>' && c != '/' && c != '<' && end < partitionLength - 1 && c != '\"';
    }

    private String createSpace(int length) {
        StringBuffer space = new StringBuffer("");
        int i = 0;
        while (i < length) {
            space.append(" ");
            ++i;
        }
        return space.toString();
    }
}

