/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.builder.RegionUtil;
import aurora.ide.editor.BaseCompositeMapEditor;
import aurora.ide.editor.textpage.TextPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class ToggleCommentAction
extends Action
implements IEditorActionDelegate {
    IEditorPart activeEditor;
    ISelection selection;

    public ToggleCommentAction() {
        this.setActionDefinitionId("aurora.ide.togglecomment");
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    public void run(IAction action) {
        if (this.activeEditor == null || !(this.activeEditor instanceof TextPage)) {
            return;
        }
        TextPage tp = (TextPage)this.activeEditor;
        try {
            this.comment(tp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void comment(TextPage page) throws Exception {
        StringBuilder sb;
        ISelectionProvider selectionProvider = page.getSelectionProvider();
        IDocument doc = page.getInputDocument();
        Point sRange = page.getSelectedRange();
        ITypedRegion partitionRegion = doc.getPartition(sRange.x);
        String pType = partitionRegion.getType();
        if ("XML_CDATA".equals(pType)) {
            if (!RegionUtil.isSubRegion((IRegion)partitionRegion, (IRegion)new Region(sRange.x, sRange.y))) {
                return;
            }
            ITypedRegion pRegion = doc.getPartition(partitionRegion.getOffset() - 1);
            String pNode = this.get(doc, pRegion).toLowerCase();
            if (pNode.matches("<.*script( .*){0,1}>")) {
                this.doLineComment("//", page);
            } else if (pNode.matches(".+-sql.+")) {
                this.doLineComment("--", page);
            }
        }
        if (sRange.y > 7 && (sb = new StringBuilder(this.get(doc, sRange))).subSequence(0, 4).equals("<!--") && sb.subSequence(sb.length() - 3, sb.length()).equals("-->")) {
            int[] delt = this.uncommentXML(sb, 0, sRange.y);
            this.set(doc, sb.toString(), sRange);
            this.select(selectionProvider, sRange.x + delt[1], delt[2]);
            return;
        }
        if ("XML_START_TAG".equals(pType) || "XML_END_TAG".equals(pType)) {
            if (sRange.y == 0 || RegionUtil.isSubRegion((IRegion)partitionRegion, (IRegion)new Region(sRange.x, sRange.y))) {
                String tagText = this.get(doc, partitionRegion);
                this.set(doc, String.format("<!-- %s -->", tagText), partitionRegion);
                this.select(selectionProvider, sRange.x + 5, sRange.y);
                return;
            }
            this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
        } else if ("XML_COMMENT".equals(pType)) {
            if (sRange.y == 0) {
                int sIC = sRange.x - partitionRegion.getOffset();
                int offset = partitionRegion.getOffset();
                int length = partitionRegion.getLength();
                StringBuilder sb2 = new StringBuilder(doc.get(offset, length));
                int[] delt = this.uncommentXML(sb2, sIC, sIC);
                doc.replace(offset, length, sb2.toString());
                this.select(selectionProvider, sRange.x + delt[1], 0);
                return;
            }
            if (RegionUtil.isSubRegion((IRegion)partitionRegion, (IRegion)new Region(sRange.x, sRange.y))) {
                sb = new StringBuilder(this.get(doc, partitionRegion));
                int sIC = sRange.x - partitionRegion.getOffset();
                int eIC = sIC + sRange.y;
                int[] delt = this.uncommentXML(sb, sIC, eIC);
                this.set(doc, sb.toString(), partitionRegion);
                this.select(selectionProvider, sRange.x + delt[1], delt[2]);
                return;
            }
            if (sRange.x == partitionRegion.getOffset()) {
                ITypedRegion[] regions = doc.computePartitioning(sRange.x, sRange.y);
                if (regions.length > 2 || !this.isWhiteRegion(doc, regions[1])) {
                    this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
                    return;
                }
                StringBuilder sb3 = new StringBuilder(this.get(doc, regions[0]));
                int[] delt = this.uncommentXML(sb3, 0, sRange.y);
                this.set(doc, sb3.toString(), regions[0]);
                this.select(selectionProvider, sRange.x, delt[2]);
                return;
            }
            this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
        } else if ("__dftl_partition_content_type".equals(pType)) {
            if (sRange.y == 0) {
                return;
            }
            Region sRegion = new Region(sRange.x, sRange.y);
            if (RegionUtil.isSubRegion((IRegion)partitionRegion, (IRegion)sRegion)) {
                this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
                return;
            }
            ITypedRegion[] regions = doc.computePartitioning(partitionRegion.getOffset(), sRange.x + sRange.y - partitionRegion.getOffset());
            if (regions.length > 3 || !this.isWhiteRegion(doc, regions[0])) {
                this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
                return;
            }
            if (regions.length == 3 && !this.isWhiteRegion(doc, regions[2])) {
                this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
                return;
            }
            if (!doc.getPartition(regions[1].getOffset()).equals(regions[1])) {
                this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
                return;
            }
            String type = regions[1].getType();
            if ("XML_COMMENT".equals(type)) {
                StringBuilder sb4 = new StringBuilder(this.get(doc, sRange));
                int[] delt = this.uncommentXML(sb4, 0, sRange.y);
                this.set(doc, sb4.toString(), sRange);
                this.select(selectionProvider, sRange.x + delt[1], delt[2]);
            } else {
                this.commentSelectedXML(doc, selectionProvider, sRange.x, sRange.y);
            }
        }
    }

    private void commentSelectedXML(IDocument doc, ISelectionProvider sp, int offset, int length) throws Exception {
        String text = doc.get(offset, length);
        String textNew = String.format("<!-- %s -->", text);
        doc.replace(offset, length, textNew);
        this.select(sp, offset, length + 9);
    }

    private boolean isWhiteRegion(IDocument doc, ITypedRegion tRegion) throws Exception {
        if (!"__dftl_partition_content_type".equals(tRegion.getType())) {
            return false;
        }
        char[] cArray = this.get(doc, tRegion).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void run() {
        try {
            this.comment((TextPage)((BaseCompositeMapEditor)AuroraPlugin.getActivePage().getActiveEditor()).getActiveEditor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    private int[] uncommentXML(StringBuilder sb, int sIC, int eIC) {
        int idx1 = sb.indexOf("<!-- ");
        int[] delt = new int[3];
        int sl = 5;
        int el = 4;
        if (idx1 != -1) {
            sb.delete(idx1, idx1 + 5);
        } else {
            idx1 = sb.indexOf("<!--");
            sb.delete(idx1, idx1 + 4);
            sl = 4;
        }
        int idx2 = sb.lastIndexOf(" -->");
        if (idx2 != -1) {
            sb.delete(idx2, idx2 + 4);
        } else {
            idx2 = sb.lastIndexOf("-->");
            sb.delete(idx2, idx2 + 3);
            el = 3;
        }
        idx2 += sl;
        delt[0] = sl + el;
        if (sIC <= idx1 + sl) {
            delt[1] = idx1 - sIC;
            if (eIC > idx1 + sl) {
                delt[2] = Math.min(eIC, idx2) - (idx1 + sl);
            }
        } else if (sIC <= idx2) {
            delt[1] = -sl;
            delt[2] = Math.min(eIC, idx2) - sIC;
        } else {
            delt[1] = -sl + idx2 - sIC;
        }
        return delt;
    }

    private String getTextOfLine(IDocument doc, int line) throws Exception {
        IRegion region = doc.getLineInformation(line);
        return doc.get(region.getOffset(), region.getLength());
    }

    private String commentSingleLine(String lineText, String prefix) {
        StringBuilder sb = new StringBuilder(lineText.length() + 10);
        sb.append(lineText);
        int i = 0;
        while (i < lineText.length()) {
            char c = sb.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.insert(i, String.valueOf(prefix) + " ");
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    private String uncommentSingleLine(String lineText, String prefix) {
        StringBuilder sb = new StringBuilder(lineText.length());
        sb.append(lineText);
        int idx = sb.indexOf(prefix);
        if (idx == -1) {
            return lineText;
        }
        int i = 0;
        while (i < prefix.length()) {
            sb.deleteCharAt(idx);
            ++i;
        }
        if (sb.charAt(idx) == ' ') {
            sb.deleteCharAt(idx);
        }
        return sb.toString();
    }

    private void doLineComment(String prefix, TextPage page) throws Exception {
        IDocument doc = page.getInputDocument();
        Point sRange = page.getSelectedRange();
        int startLine = doc.getLineOfOffset(sRange.x);
        int startOffsetInLine = sRange.x - doc.getLineOffset(startLine);
        ITypedRegion partitionRegion = doc.getPartition(sRange.x);
        if (sRange.y == 0) {
            String text = this.getTextOfLine(doc, startLine);
            String textNew = null;
            boolean tc = this.isCommentOf(text, prefix);
            textNew = tc ? this.uncommentSingleLine(text, prefix) : this.commentSingleLine(text, prefix);
            int[] delt = this.computeDelt(text, textNew, prefix, startOffsetInLine);
            doc.replace(doc.getLineOffset(startLine), text.length(), textNew);
            page.getSelectionProvider().setSelection((ISelection)new TextSelection(sRange.x + delt[0], 0));
            return;
        }
        if (partitionRegion.getOffset() + partitionRegion.getLength() < sRange.x + sRange.y) {
            return;
        }
        int endLine = doc.getLineOfOffset(sRange.x + sRange.y);
        if (doc.getLineOffset(endLine) == sRange.x + sRange.y) {
            --endLine;
        }
        int startOffset = doc.getLineOffset(startLine);
        IRegion endLineRegion = doc.getLineInformation(endLine);
        int length = endLineRegion.getOffset() + endLineRegion.getLength() - startOffset;
        int endOffsetInLine = sRange.x + sRange.y - doc.getLineOffset(endLine);
        String text = doc.get(startOffset, length).replace("\r\n", "\n").replace("\r", "\n");
        String[] ss = text.split("\n");
        StringBuilder sb = new StringBuilder(ss.length * 4 + text.length());
        boolean ct = this.isCommentOf(ss, prefix);
        String textNew = ct ? this.uncommentSingleLine(ss[0], prefix) : this.commentSingleLine(ss[0], prefix);
        int[] delt = this.computeDelt(ss[0], textNew, prefix, startOffsetInLine);
        int offsetDelt = delt[0];
        int lengthDelt = delt[1];
        sb.append(textNew);
        if (ss.length > 1) {
            sb.append(CommentXMLOutputter.LINE_SEPARATOR);
            int i = 1;
            while (i < ss.length - 1) {
                textNew = ct ? this.uncommentSingleLine(ss[i], prefix) : this.commentSingleLine(ss[i], prefix);
                sb.append(textNew);
                sb.append(CommentXMLOutputter.LINE_SEPARATOR);
                lengthDelt += textNew.length() - ss[i].length();
                ++i;
            }
            text = ss[ss.length - 1];
            textNew = ct ? this.uncommentSingleLine(text, prefix) : this.commentSingleLine(text, prefix);
            sb.append(textNew);
            delt = this.computeDelt(text, textNew, prefix, endOffsetInLine);
            lengthDelt += delt[0];
        }
        doc.replace(startOffset, length, sb.toString());
        page.getSelectionProvider().setSelection((ISelection)new TextSelection(sRange.x + offsetDelt, sRange.y + lengthDelt));
    }

    private boolean isCommentOf(String lineText, String prefix) {
        int idx = lineText.indexOf(prefix);
        if (idx == -1) {
            return false;
        }
        int i = 0;
        while (i < idx) {
            if (!Character.isWhitespace(lineText.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isCommentOf(String[] ss, String prefix) {
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.trim().length() != 0 && !this.isCommentOf(s, prefix)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private int getWspLength(String lineText) {
        int i = 0;
        while (i < lineText.length()) {
            if (!Character.isWhitespace(lineText.charAt(i))) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private int getWapLength(String text, String prefix) {
        int idx = text.indexOf(prefix);
        if (Character.isWhitespace(text.charAt(idx += prefix.length()))) {
            return idx + 1;
        }
        return idx;
    }

    private int[] computeDelt(String text, String textNew, String prefix, int offsetIL) {
        int[] delt = new int[2];
        int l1 = text.length();
        int l2 = textNew.length();
        int wsp = this.getWspLength(text);
        if (l1 < l2) {
            if (wsp <= offsetIL) {
                delt[0] = l2 - l1;
            } else {
                delt[1] = l2 - l1;
            }
        } else {
            int wap = this.getWapLength(text, prefix);
            if (wsp >= offsetIL) {
                delt[1] = l2 - l1;
            } else if (wap >= offsetIL) {
                delt[0] = wsp - offsetIL;
                delt[1] = offsetIL - wap;
            } else {
                delt[0] = l2 - l1;
            }
        }
        return delt;
    }

    protected String get(IDocument doc, Object region) throws Exception {
        if (region instanceof IRegion) {
            IRegion r = (IRegion)region;
            return doc.get(r.getOffset(), r.getLength());
        }
        if (region instanceof Point) {
            Point p = (Point)region;
            return doc.get(p.x, p.y);
        }
        throw new RuntimeException("Unknow argument type:" + region.getClass());
    }

    protected void set(IDocument doc, String str, Object region) throws Exception {
        if (region instanceof IRegion) {
            IRegion r = (IRegion)region;
            doc.replace(r.getOffset(), r.getLength(), str);
        } else if (region instanceof Point) {
            Point p = (Point)region;
            doc.replace(p.x, p.y, str);
        } else {
            throw new RuntimeException("Unknow argument type:" + region.getClass());
        }
    }

    protected void select(ISelectionProvider sp, Object ... region) {
        if (region.length == 1) {
            if (region[0] instanceof IRegion) {
                IRegion r = (IRegion)region[0];
                sp.setSelection((ISelection)new TextSelection(r.getOffset(), r.getLength()));
            } else if (region[0] instanceof Point) {
                Point p = (Point)region[0];
                sp.setSelection((ISelection)new TextSelection(p.x, p.y));
            }
        } else if (region.length == 2) {
            sp.setSelection((ISelection)new TextSelection(((Integer)region[0]).intValue(), ((Integer)region[1]).intValue()));
        } else {
            throw new RuntimeException("Unknow argument type:" + region.getClass());
        }
    }
}

