/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.editor.textpage.TextPage;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class GetFileNameAction
extends Action
implements IEditorActionDelegate {
    IEditorPart activeEditor;

    public GetFileNameAction() {
        this.setActionDefinitionId("aurora.ide.text.editor.copy.fileName");
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    public void run() {
        this.run(null);
    }

    public void run(IAction action) {
        if (this.activeEditor == null || !(this.activeEditor instanceof TextPage)) {
            DialogUtil.showErrorMessageBox("\u8fd9\u4e2a\u7c7b\u4e0d\u662f" + TextPage.class.getName());
            return;
        }
        Clipboard cb = new Clipboard(Display.getCurrent());
        IFile ifile = ((IFileEditorInput)this.activeEditor.getEditorInput()).getFile();
        String textData = "";
        try {
            textData = AuroraResourceUtil.getRegisterPath(ifile);
        }
        catch (ApplicationException e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        if (textData.length() <= 0) {
            textData = "  ";
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{textData}, new Transfer[]{textTransfer});
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

