/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.editor.textpage.TextPage;
import aurora.ide.editor.textpage.format.SQLFormat;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class FormatSQL
implements IEditorActionDelegate {
    IEditorPart activeEditor;

    public void run(IAction action) {
        if (this.activeEditor == null || !(this.activeEditor instanceof TextPage)) {
            DialogUtil.showErrorMessageBox("\u8fd9\u4e2a\u7c7b\u4e0d\u662f" + TextPage.class.getName());
            return;
        }
        TextPage tp = (TextPage)this.activeEditor;
        IDocument document = tp.getInputDocument();
        int cursorLine = tp.getCursorLine();
        try {
            int x = tp.getSelectedRange().x;
            if (x <= 0) {
                return;
            }
            ITypedRegion region = document.getPartition(x);
            ITypedRegion parentRegion = document.getPartition(region.getOffset() - 1);
            String parentNode = document.get(parentRegion.getOffset(), parentRegion.getLength());
            int startLine = document.getLineOfOffset(parentRegion.getOffset());
            String txt = document.get(document.getLineOffset(startLine), document.getLineLength(startLine));
            int index = txt.toLowerCase().indexOf("<");
            if (index <= 0) {
                return;
            }
            String prefix = txt.substring(0, index);
            if (!parentNode.matches("<[^/].+sql>")) {
                DialogUtil.showErrorMessageBox("\u6b64\u533a\u57df\u975eSQL\u4ee3\u7801");
                return;
            }
            int begin = region.getOffset() + "<![CDATA[".length();
            int length = region.getLength() - "<![CDATA[".length() - "]]>".length();
            String sqlCode = document.get(begin, length);
            SQLFormat sf = new SQLFormat();
            String[] temp = sf.format(sqlCode).split("\n|\r\n");
            StringBuffer result = new StringBuffer("\n");
            String[] stringArray = temp;
            int n = temp.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                result.append(String.valueOf(prefix) + "    " + s + " \n");
                ++n2;
            }
            result.append(prefix);
            document.replace(begin, length, result.toString());
        }
        catch (Exception e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
        try {
            int offset = document.getLineOffset(cursorLine);
            int length = document.getLineLength(cursorLine);
            if (offset == 0 || length == 0) {
                return;
            }
            tp.setHighlightRange(offset, length, true);
        }
        catch (BadLocationException e) {
            DialogUtil.logErrorException(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }
}

