/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.editor.textpage.format.JSBeautifier;
import aurora.ide.helpers.DialogUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class FormatJS
implements IEditorActionDelegate {
    IEditorPart activeEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
    }

    public void run(IAction action) {
        if (this.activeEditor == null || !(this.activeEditor instanceof TextPage)) {
            return;
        }
        TextPage tp = (TextPage)this.activeEditor;
        IDocument document = tp.getInputDocument();
        int offset = tp.getSelectedRange().x;
        try {
            int length;
            if (offset <= 0) {
                return;
            }
            ITypedRegion region = document.getPartition(offset);
            ITypedRegion parentRegion = document.getPartition(region.getOffset() - 1);
            String parentNode = document.get(parentRegion.getOffset(), parentRegion.getLength());
            int startLine = document.getLineOfOffset(parentRegion.getOffset());
            String txt = document.get(document.getLineOffset(startLine), document.getLineLength(startLine));
            int index = txt.toLowerCase().indexOf("<script");
            if (index <= 0) {
                return;
            }
            String prefix = txt.substring(0, index);
            if (!"XML_CDATA".equals(region.getType()) || !parentNode.toLowerCase().matches("<script( .*){0,1}>")) {
                DialogUtil.showErrorMessageBox("\u6b64\u533a\u57df\u975ejavascript\u4ee3\u7801");
                return;
            }
            int begin = region.getOffset() + "<![CDATA[".length();
            String jsCode = document.get(begin, length = region.getLength() - "<![CDATA[".length() - "]]>".length());
            if (jsCode == null || jsCode.trim().length() == 0) {
                return;
            }
            JSBeautifier bf = new JSBeautifier();
            String indent = "    " + prefix;
            String jsCodeNew = String.valueOf((String.valueOf(CommentXMLOutputter.LINE_SEPARATOR) + bf.beautify(jsCode, bf.opts)).replaceAll("\n", String.valueOf(CommentXMLOutputter.LINE_SEPARATOR) + indent)) + CommentXMLOutputter.LINE_SEPARATOR + prefix;
            if (jsCodeNew.equals(jsCode)) {
                return;
            }
            document.replace(begin, length, jsCodeNew);
            tp.setHighlightRange(offset, 0, true);
        }
        catch (Throwable e) {
            DialogUtil.showExceptionMessageBox(e);
            return;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

