/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.textpage.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.composite.map.CommentXMLOutputter;
import aurora.ide.builder.CompositeMapInfo;
import aurora.ide.editor.BaseCompositeMapEditor;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.editor.textpage.action.FormatJS;
import aurora.ide.editor.textpage.action.FormatSQL;
import aurora.ide.editor.textpage.format.JSBeautifier;
import aurora.ide.editor.textpage.format.SQLFormat;
import aurora.ide.editor.textpage.quickfix.QuickAssistUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import uncertain.composite.CompositeMap;

public class CFormatAction
extends Action
implements IEditorActionDelegate {
    private static final int XML = 0;
    private static final int SQL = 1;
    private static final int JS = 2;
    private IEditorPart activeEditor;
    private FormatJS formatJS;
    private FormatSQL formatSQL;
    private CompositeMap selectMap;
    private IDocument doc;
    private TextPage page;

    public CFormatAction() {
        this.setActionDefinitionId("aurora.ide.format");
        this.formatJS = new FormatJS();
        this.formatSQL = new FormatSQL();
    }

    public void run() {
        this.activeEditor = (TextPage)((BaseCompositeMapEditor)AuroraPlugin.getActivePage().getActiveEditor()).getActiveEditor();
        this.page = (TextPage)this.activeEditor;
        try {
            switch (this.getSelectionType()) {
                case 2: {
                    this.formatJS();
                    break;
                }
                case 1: {
                    this.formatSQL();
                    break;
                }
                case 0: {
                    this.formatXML();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getSelectionType() throws Exception {
        this.doc = this.page.getInputDocument();
        CompositeMap rootMap = this.page.toCompoisteMap();
        this.selectMap = QuickAssistUtil.findMap(rootMap, this.doc, this.page.getSelectedRange().x);
        String mapName = this.selectMap.getName();
        if (mapName.toLowerCase().matches(".*script")) {
            return 2;
        }
        if (mapName.toLowerCase().matches(".+-sql")) {
            return 1;
        }
        return 0;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    private void formatXML() {
        String content = this.doc.get();
        if (content == null) {
            return;
        }
        int offset = this.page.getSelectedRange().x;
        try {
            CompositeMap data = this.page.toCompoisteMap();
            String formatContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + CommentXMLOutputter.defaultInstance().toXML(data, true);
            if (content.equals(formatContent)) {
                return;
            }
            this.page.refresh(formatContent);
            if (offset >= formatContent.length()) {
                offset = formatContent.length();
            }
            this.page.setHighlightRange(offset, 0, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void formatJS() {
        int offset = this.page.getSelectedRange().x;
        CompositeMapInfo info = new CompositeMapInfo(this.selectMap, this.doc);
        IRegion startRegion = info.getStartTagRegion();
        IRegion endRegion = info.getEndTagRegion();
        int jsOffset = startRegion.getOffset() + startRegion.getLength() + "<![CDATA[".length();
        int jsLength = endRegion.getOffset() - "]]>".length() - jsOffset;
        try {
            String jsCode = this.doc.get(jsOffset, jsLength);
            if (jsCode == null || jsCode.trim().length() == 0) {
                return;
            }
            String prefix = info.getLeadPrefix();
            JSBeautifier bf = new JSBeautifier();
            String indent = "    " + prefix;
            String formatedJs = bf.beautify(jsCode.trim(), bf.opts).trim();
            String jsCodeNew = String.valueOf(("\n" + formatedJs).replaceAll("\n", String.valueOf(CommentXMLOutputter.LINE_SEPARATOR) + indent)) + CommentXMLOutputter.LINE_SEPARATOR + prefix;
            if (jsCodeNew.equals(jsCode)) {
                return;
            }
            this.doc.replace(jsOffset, jsLength, jsCodeNew);
            this.page.setHighlightRange(offset, 0, true);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return;
        }
    }

    private void formatSQL() {
        int offset = this.page.getSelectedRange().x;
        CompositeMapInfo info = new CompositeMapInfo(this.selectMap, this.doc);
        IRegion startRegion = info.getStartTagRegion();
        IRegion endRegion = info.getEndTagRegion();
        int sqlOffset = startRegion.getOffset() + startRegion.getLength() + "<![CDATA[".length();
        int sqlLength = endRegion.getOffset() - "]]>".length() - sqlOffset;
        try {
            String sqlCode = this.doc.get(sqlOffset, sqlLength);
            if (sqlCode == null || sqlCode.trim().length() == 0) {
                return;
            }
            String prefix = info.getLeadPrefix();
            String indent = "    " + prefix;
            SQLFormat sf = new SQLFormat();
            String sqlCodeNew = sf.format(sqlCode);
            StringBuilder sb = new StringBuilder(5000);
            sb.append(CommentXMLOutputter.LINE_SEPARATOR);
            String[] stringArray = sqlCodeNew.split("\n|\r\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                sb.append(String.valueOf(indent) + line + CommentXMLOutputter.LINE_SEPARATOR);
                ++n2;
            }
            sb.append(prefix);
            sqlCodeNew = sb.toString();
            if (sqlCodeNew.equals(sqlCode)) {
                return;
            }
            this.doc.replace(sqlOffset, sqlLength, sqlCodeNew);
            this.page.setHighlightRange(offset, 0, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

